/*
 * Decompiled with CFR 0.152.
 */
package org.directwebremoting.guice.util;

import com.google.inject.Key;
import com.google.inject.Provider;
import com.google.inject.util.ToStringBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.directwebremoting.guice.util.ContextCloseHandler;
import org.directwebremoting.guice.util.ContextRegistry;
import org.directwebremoting.guice.util.ContextScope;
import org.directwebremoting.guice.util.FutureTaskProvider;
import org.directwebremoting.guice.util.InstanceProvider;
import org.directwebremoting.guice.util.OutOfScopeException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractContextScope<C, R>
implements ContextScope<C>,
ContextRegistry<C, R> {
    protected final Class<C> type;
    protected final String scopeName;
    private final List<Key<?>> scopedKeys = Collections.synchronizedList(new ArrayList());
    private final ConcurrentMap<C, State> contexts = new ConcurrentHashMap<C, State>();

    protected AbstractContextScope(Class<C> type, String scopeName) {
        this.type = type;
        this.scopeName = scopeName;
    }

    public String toString() {
        return this.scopeName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Key<?>> getKeysInScope() {
        List<Key<?>> list = this.scopedKeys;
        synchronized (list) {
            return new ArrayList(this.scopedKeys);
        }
    }

    @Override
    public <T> Provider<T> scope(final Key<T> key, final Provider<T> creator) {
        this.scopedKeys.add(key);
        final String name = key.toString();
        return new Provider<T>(){

            public T get() {
                FutureTaskProvider futureTask;
                Object context = AbstractContextScope.this.getContext(key);
                Object registry = AbstractContextScope.this.registryFor(context);
                FutureTaskProvider future = AbstractContextScope.this.get(registry, key, name);
                if (future == null && (future = AbstractContextScope.this.putIfAbsent(registry, key, name, futureTask = new FutureTaskProvider(creator))) == null) {
                    future = futureTask;
                    futureTask.run();
                    if (Thread.currentThread().isInterrupted()) {
                        AbstractContextScope.this.remove(registry, key, name, futureTask);
                    }
                }
                return future.get();
            }

            public String toString() {
                return new ToStringBuilder(this.getClass()).add("scopeName", (Object)AbstractContextScope.this.scopeName).add("type", AbstractContextScope.this.type).add("key", (Object)key).add("creator", (Object)creator).toString();
            }
        };
    }

    @Override
    public abstract C get();

    @Override
    public Class<C> type() {
        return this.type;
    }

    @Override
    public Collection<C> getOpenContexts() {
        ArrayList openContexts = new ArrayList();
        for (Object context : this.contexts.keySet()) {
            if (this.contexts.get(context) != State.OPEN) continue;
            openContexts.add(context);
        }
        return openContexts;
    }

    @Override
    public void close(C context, ContextCloseHandler<?> ... closeHandlers) {
        if (!this.contexts.replace(context, State.OPEN, State.CLOSED)) {
            return;
        }
        for (InstanceProvider<?> provider : this.registeredProviders(this.registryFor(context))) {
            Object value = null;
            try {
                value = provider.get();
            }
            catch (RuntimeException e) {
                // empty catch block
            }
            if (value == null) continue;
            for (ContextCloseHandler<?> closeHandler : closeHandlers) {
                this.handleClose(closeHandler, value);
            }
        }
    }

    @Override
    public void closeAll(ContextCloseHandler<?> ... closeHandlers) {
        for (C context : this.getOpenContexts()) {
            this.close(context, closeHandlers);
        }
    }

    private <T> void handleClose(ContextCloseHandler<T> closeHandler, Object value) {
        Class<T> closeType = closeHandler.type();
        if (closeType.isInstance(value)) {
            try {
                closeHandler.close(closeType.cast(value));
            }
            catch (Exception e) {
                // empty catch block
            }
        }
    }

    protected C getContext(Key<?> key) {
        Object context = null;
        RuntimeException caught = null;
        try {
            context = this.get();
            if (this.contexts.putIfAbsent(context, State.OPEN) == State.CLOSED) {
                context = null;
            }
        }
        catch (RuntimeException ex) {
            caught = ex;
        }
        if (context == null) {
            throw new OutOfScopeException(this, key, caught);
        }
        return context;
    }

    private Collection<InstanceProvider<?>> registeredProviders(R registry) {
        ArrayList providers = new ArrayList();
        for (Key<?> key : this.getKeysInScope()) {
            InstanceProvider provider = this.get(registry, key, key.toString());
            if (provider == null) continue;
            providers.add(provider);
        }
        return providers;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum State {
        OPEN,
        CLOSED;

    }
}

