/*
 * Decompiled with CFR 0.152.
 */
package org.directwebremoting.impl;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.directwebremoting.AjaxFilter;
import org.directwebremoting.AjaxFilterChain;
import org.directwebremoting.WebContext;
import org.directwebremoting.WebContextFactory;
import org.directwebremoting.extend.AccessControl;
import org.directwebremoting.extend.AjaxFilterManager;
import org.directwebremoting.extend.Creator;
import org.directwebremoting.extend.MethodDeclaration;
import org.directwebremoting.extend.Module;
import org.directwebremoting.impl.AccessLogLevel;
import org.directwebremoting.util.Continuation;
import org.directwebremoting.util.Loggers;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CreatorModule
implements Module {
    private final Creator creator;
    private final AjaxFilterManager ajaxFilterManager;
    private final AccessControl accessControl;
    private final boolean allowImpossibleTests;
    protected final String accessLogLevel;
    private final boolean debug;
    private static Class<?> advisedClass;
    private static final Log log;

    public CreatorModule(Creator creator, AjaxFilterManager ajaxFilterManager, AccessControl accessControl, boolean allowImpossibleTests, String accessLogLevel, boolean debug) {
        this.creator = creator;
        this.ajaxFilterManager = ajaxFilterManager;
        this.accessControl = accessControl;
        this.allowImpossibleTests = allowImpossibleTests;
        this.accessLogLevel = accessLogLevel;
        this.debug = debug;
    }

    @Override
    public String getName() {
        return this.creator.getJavascript();
    }

    @Override
    public boolean isCacheable() {
        return this.creator.isCacheable();
    }

    @Override
    public MethodDeclaration[] getMethods() {
        Method[] methods = this.creator.getType().getMethods();
        ArrayList<MethodDeclaration> methodDecls = new ArrayList<MethodDeclaration>();
        for (Method method : methods) {
            try {
                this.accessControl.assertMethodDisplayable(this.creator.getType(), method);
            }
            catch (SecurityException ex) {
                if (!this.allowImpossibleTests) continue;
            }
            methodDecls.add(new MethodDeclaration(this.checkProxiedMethod(method)));
        }
        return methodDecls.toArray(new MethodDeclaration[0]);
    }

    @Override
    public MethodDeclaration getMethod(String methodName, Class<?> ... parameterTypes) throws NoSuchMethodException, SecurityException {
        Method method = this.checkProxiedMethod(this.creator.getType().getMethod(methodName, parameterTypes));
        return new MethodDeclaration(method);
    }

    @Override
    public Object executeMethod(MethodDeclaration methodDecl, Object[] parameters) throws Exception {
        Method method = this.creator.getType().getMethod(methodDecl.getName(), methodDecl.getParameterTypes());
        this.accessControl.assertMethodExecutionIsPossible(this.creator.getType(), method);
        Object object = null;
        String scope = this.creator.getScope();
        boolean create = false;
        if (!Modifier.isStatic(method.getModifiers())) {
            WebContext webcx = WebContextFactory.get();
            if (scope.equals("application")) {
                object = webcx.getServletContext().getAttribute(this.getName());
            } else if (scope.equals("session")) {
                object = webcx.getSession().getAttribute(this.getName());
            } else if (scope.equals("script")) {
                object = webcx.getScriptSession().getAttribute(this.getName());
            } else if (scope.equals("request")) {
                object = webcx.getHttpServletRequest().getAttribute(this.getName());
            }
            try {
                if (object == null) {
                    create = true;
                    object = this.creator.getInstance();
                }
            }
            catch (InstantiationException ex) {
                Continuation.rethrowIfContinuation(ex);
                log.info((Object)("Error creating an instance of the following DWR Creator: " + (null != this.creator.getClass() ? this.creator.getClass().getName() : "None Specified") + "."), (Throwable)ex);
                throw ex;
            }
            if (create) {
                if (scope.equals("application")) {
                    webcx.getServletContext().setAttribute(this.getName(), object);
                } else if (scope.equals("session")) {
                    webcx.getSession().setAttribute(this.getName(), object);
                } else if (scope.equals("script")) {
                    webcx.getScriptSession().setAttribute(this.getName(), object);
                } else if (scope.equals("request")) {
                    webcx.getHttpServletRequest().setAttribute(this.getName(), object);
                }
            }
        }
        if (AccessLogLevel.getValue(this.accessLogLevel, this.debug).hierarchy() == 0) {
            StringBuffer buffer = new StringBuffer();
            if (create) {
                buffer.append("Object created, ");
                if (!scope.equals("page")) {
                    buffer.append(" stored in ");
                    buffer.append(scope);
                } else {
                    buffer.append(" not stored");
                }
            } else {
                buffer.append("Object found in ");
                buffer.append(scope);
            }
            buffer.append(".");
            Loggers.ACCESS.info((Object)buffer.toString());
        }
        List<AjaxFilter> filters = this.ajaxFilterManager.getAjaxFilters(this.getName());
        final Iterator<AjaxFilter> it = filters.iterator();
        AjaxFilterChain chain = new AjaxFilterChain(){

            public Object doFilter(Object obj, Method meth, Object[] params) throws Exception {
                if (it.hasNext()) {
                    AjaxFilter next = (AjaxFilter)it.next();
                    return next.doFilter(obj, meth, params, this);
                }
                if (null != obj && meth.getDeclaringClass().equals(obj.getClass()) || Modifier.isStatic(meth.getModifiers())) {
                    return meth.invoke(obj, params);
                }
                Method m = obj.getClass().getMethod(meth.getName(), meth.getParameterTypes());
                return m.invoke(obj, params);
            }
        };
        Object reply = chain.doFilter(object, method, parameters);
        return reply;
    }

    @Override
    public String toString() {
        return this.creator.getClass().getSimpleName() + " for " + this.creator.getType().getName();
    }

    private Method checkProxiedMethod(Method method) {
        Method realMethod = method;
        if (method != null && advisedClass != null && advisedClass.isAssignableFrom(method.getDeclaringClass()) && Proxy.isProxyClass(this.creator.getType())) {
            try {
                Object target = this.creator.getInstance();
                Method targetClassMethod = target.getClass().getMethod("getTargetClass", new Class[0]);
                Class targetClass = (Class)targetClassMethod.invoke(target, new Object[0]);
                realMethod = targetClass.getDeclaredMethod(method.getName(), method.getParameterTypes());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return realMethod;
    }

    static {
        log = LogFactory.getLog(CreatorModule.class);
        try {
            advisedClass = Class.forName("org.springframework.aop.framework.Advised");
            log.debug((Object)"Found org.springframework.aop.framework.Advised enabling AOP checks");
        }
        catch (ClassNotFoundException ex) {
            log.debug((Object)"ClassNotFoundException on org.springframework.aop.framework.Advised skipping AOP checks");
        }
    }
}

