/*
 * Decompiled with CFR 0.152.
 */
package org.directwebremoting.impl;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.TreeMap;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import org.directwebremoting.Container;
import org.directwebremoting.extend.ContainerConfigurationException;
import org.directwebremoting.extend.UninitializingBean;
import org.directwebremoting.impl.AbstractContainer;
import org.directwebremoting.util.LocalUtil;
import org.directwebremoting.util.Loggers;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultContainer
extends AbstractContainer
implements Container {
    protected Map<String, Object> beans = new TreeMap<String, Object>();

    public <T> void addBean(Class<T> base, T bean) {
        this.addParameter(LocalUtil.originalDwrClassName(base.getName()), bean);
    }

    public <T> void addImplementation(Class<T> base, Class<? extends T> implementation) {
        this.addParameter(LocalUtil.originalDwrClassName(base.getName()), implementation.getName());
    }

    public <T> void addImplementationOption(Class<T> base, Class<? extends T> implementation) {
        Object existingOptions = this.beans.get(base.getName());
        if (existingOptions == null) {
            this.beans.put(LocalUtil.originalDwrClassName(base.getName()), implementation.getName());
        } else {
            this.beans.put(LocalUtil.originalDwrClassName(base.getName()), existingOptions + " " + implementation.getName());
        }
    }

    public void addParameter(String askFor, Object valueParam) throws ContainerConfigurationException {
        Object value = valueParam;
        if (value instanceof String) {
            try {
                Class<?> impl = LocalUtil.classForName((String)value);
                value = impl.newInstance();
            }
            catch (ClassNotFoundException ex) {
            }
            catch (InstantiationException ex) {
                throw new ContainerConfigurationException("Unable to instantiate " + value);
            }
            catch (IllegalAccessException ex) {
                throw new ContainerConfigurationException("Unable to access " + value);
            }
        }
        if (!(value instanceof String)) {
            try {
                Class<?> iface = LocalUtil.classForName(askFor);
                if (!iface.isAssignableFrom(value.getClass())) {
                    Loggers.STARTUP.error((Object)("Can't cast: " + value + " to " + askFor));
                }
            }
            catch (ClassNotFoundException ex) {
                // empty catch block
            }
        }
        if (Loggers.STARTUP.isDebugEnabled()) {
            if (value instanceof String) {
                Loggers.STARTUP.debug((Object)("- value: " + askFor + " = " + value));
            } else {
                Loggers.STARTUP.debug((Object)("- impl:  " + askFor + " = " + value.getClass().getName()));
            }
        }
        this.beans.put(askFor, value);
    }

    public String getParameter(String name) {
        Object value = this.beans.get(name);
        return value == null ? null : value.toString();
    }

    public void setupFinished() {
        for (Object bean : this.beans.values()) {
            this.initializeBean(bean);
        }
        this.callInitializingBeans();
    }

    @Override
    public <T> T newInstance(Class<T> type) throws InstantiationException, IllegalAccessException {
        T t = type.newInstance();
        this.initializeBean(t);
        return t;
    }

    @Override
    public void initializeBean(Object bean) {
        if (bean instanceof ServletContext || bean instanceof ServletConfig) {
            Loggers.STARTUP.debug((Object)("- skipping injecting into: " + bean.getClass().getName()));
            return;
        }
        if (!(bean instanceof String)) {
            Method[] methods;
            Loggers.STARTUP.debug((Object)("- autowire: " + bean.getClass().getName()));
            for (Method setter : methods = bean.getClass().getMethods()) {
                Object value;
                if (!setter.getName().startsWith("set") || setter.getName().length() <= 3 || setter.getParameterTypes().length != 1) continue;
                String name = Character.toLowerCase(setter.getName().charAt(3)) + setter.getName().substring(4);
                Class<?> propertyType = setter.getParameterTypes()[0];
                Object setting = this.beans.get(name);
                if (setting != null) {
                    if (propertyType.isAssignableFrom(setting.getClass())) {
                        Loggers.STARTUP.debug((Object)("  - by name: " + name + " = " + setting));
                        DefaultContainer.invoke(setter, bean, setting);
                        continue;
                    }
                    if (setting.getClass() == String.class) {
                        try {
                            value = LocalUtil.simpleConvert((String)setting, propertyType);
                            Loggers.STARTUP.debug((Object)("  - by name: " + name + " = " + value));
                            DefaultContainer.invoke(setter, bean, value);
                        }
                        catch (IllegalArgumentException ex) {}
                        continue;
                    }
                }
                if ((value = this.beans.get(LocalUtil.originalDwrClassName(propertyType.getName()))) != null) {
                    Loggers.STARTUP.debug((Object)("  - by type: " + name + " = " + value.getClass().getName()));
                    DefaultContainer.invoke(setter, bean, value);
                    continue;
                }
                Loggers.STARTUP.debug((Object)("  - no properties for: " + name));
            }
        }
    }

    private static void invoke(Method setter, Object bean, Object value) {
        try {
            setter.invoke(bean, value);
        }
        catch (InvocationTargetException ex) {
            Loggers.STARTUP.error((Object)"  - Exception during auto-wire: ", ex.getTargetException());
        }
        catch (Exception ex) {
            Loggers.STARTUP.error((Object)("  - Error calling setter: " + setter), (Throwable)ex);
        }
    }

    @Override
    public Object getBean(String id) {
        return this.beans.get(id);
    }

    @Override
    public Collection<String> getBeanNames() {
        return Collections.unmodifiableCollection(this.beans.keySet());
    }

    @Override
    public void contextDestroyed() {
        this.contextDestroyed(this.getBeanNames());
    }

    public void contextDestroyed(Collection<String> beanNames) {
        Loggers.STARTUP.debug((Object)("ContextDestroyed for container: " + this.getClass().getSimpleName()));
        for (String beanName : beanNames) {
            Object bean = this.getBean(beanName);
            if (!(bean instanceof UninitializingBean) || bean instanceof Container) continue;
            UninitializingBean scl = (UninitializingBean)bean;
            Loggers.STARTUP.debug((Object)("- For contained bean: " + beanName));
            scl.contextDestroyed();
        }
    }

    @Override
    public void servletDestroyed() {
        this.servletDestroyed(this.getBeanNames());
    }

    public void servletDestroyed(Collection<String> beanNames) {
        Loggers.STARTUP.debug((Object)("ServletDestroyed for container: " + this.getClass().getSimpleName()));
        for (String beanName : beanNames) {
            Object bean = this.getBean(beanName);
            if (!(bean instanceof UninitializingBean) || bean instanceof Container) continue;
            UninitializingBean scl = (UninitializingBean)bean;
            Loggers.STARTUP.debug((Object)("- For contained bean: " + beanName));
            scl.servletDestroyed();
        }
    }
}

