/*
 * Decompiled with CFR 0.152.
 */
package org.directwebremoting.impl;

import java.io.IOException;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.xml.parsers.ParserConfigurationException;
import org.directwebremoting.Container;
import org.directwebremoting.WebContextFactory;
import org.directwebremoting.annotations.AnnotationsConfigurator;
import org.directwebremoting.extend.ConverterManager;
import org.directwebremoting.impl.DwrXmlConfigurator;
import org.directwebremoting.impl.StartupUtil;
import org.directwebremoting.util.FakeServletConfig;
import org.directwebremoting.util.FakeServletContext;
import org.xml.sax.SAXException;

public class TestEnvironment {
    private static Container container;
    private static WebContextFactory.WebContextBuilder webContextBuilder;
    private static final ServletContext servletContext;
    private static final ServletConfig servletConfig;

    public static void configureFromClassResource(String classResourceName) throws IOException, ParserConfigurationException, SAXException {
        DwrXmlConfigurator local = new DwrXmlConfigurator();
        local.setClassResourceName(classResourceName);
        local.configure(container);
    }

    public static void engageThread() {
        webContextBuilder.engageThread(container, null, null);
    }

    public static void disengageThread() {
        webContextBuilder.disengageThread();
    }

    public static ConverterManager getConverterManager() {
        return container.getBean(ConverterManager.class);
    }

    public static Container getContainer() {
        return container;
    }

    public static ServletConfig getServletConfig() {
        return servletConfig;
    }

    public static ServletContext getServletContext() {
        return servletContext;
    }

    public static WebContextFactory.WebContextBuilder getWebContextBuilder() {
        return webContextBuilder;
    }

    static {
        servletContext = new FakeServletContext();
        servletConfig = new FakeServletConfig("dwr-test", servletContext);
        try {
            container = StartupUtil.createAndSetupDefaultContainer(servletConfig);
            webContextBuilder = container.getBean(WebContextFactory.WebContextBuilder.class);
            StartupUtil.configureFromSystemDwrXml(container);
            AnnotationsConfigurator configurator = new AnnotationsConfigurator();
            configurator.configure(container);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
        finally {
            if (webContextBuilder != null) {
                webContextBuilder.disengageThread();
            }
        }
    }
}

