/*
 * Decompiled with CFR 0.152.
 */
package org.directwebremoting.io;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.directwebremoting.io.QueryOptions;
import org.directwebremoting.io.SortCriterion;
import org.directwebremoting.util.LocalUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class StoreRegion {
    private final int start;
    private final int count;
    private final List<SortCriterion> sort;
    private final Map<String, String> query;
    private final QueryOptions queryOptions;

    public StoreRegion() {
        this.start = 0;
        this.count = -1;
        this.sort = new ArrayList<SortCriterion>();
        this.query = new HashMap<String, String>();
        this.queryOptions = new QueryOptions();
    }

    public StoreRegion(int start, int count, List<SortCriterion> sort, Map<String, String> query, QueryOptions queryOptions) {
        this.start = start;
        this.count = count;
        this.queryOptions = queryOptions == null ? new QueryOptions() : queryOptions;
        this.sort = new ArrayList<SortCriterion>();
        if (sort != null) {
            this.sort.addAll(sort);
        }
        this.query = new HashMap<String, String>();
        if (query != null) {
            for (Map.Entry<String, String> entry : query.entrySet()) {
                String value = entry.getValue();
                if ("*".equals(value)) continue;
                this.query.put(entry.getKey(), value);
            }
        }
    }

    public int getStart() {
        return this.start;
    }

    public int getCount() {
        return this.count;
    }

    public List<SortCriterion> getSort() {
        return Collections.unmodifiableList(this.sort);
    }

    public Map<String, String> getQuery() {
        return Collections.unmodifiableMap(this.query);
    }

    @Deprecated
    public void setQuery(Map<String, String> query) {
        this.query.clear();
        if (query != null) {
            for (Map.Entry<String, String> entry : query.entrySet()) {
                String value = entry.getValue();
                if ("*".equals(value)) continue;
                this.query.put(entry.getKey(), value);
            }
        }
    }

    public QueryOptions getQueryOptions() {
        return this.queryOptions;
    }

    @Deprecated
    public void setQueryOptions(QueryOptions queryOptions) {
        throw new IllegalAccessError();
    }

    public String toString() {
        return "StoreRegion[start=" + this.start + ",count=" + this.count + ",sort=" + this.sort + ",query=" + this.query + ", options=" + this.queryOptions + "]";
    }

    public int hashCode() {
        int hash = 342;
        hash += this.sort != null ? ((Object)this.sort).hashCode() : 4835;
        hash += this.query != null ? ((Object)this.query).hashCode() : 5239;
        return hash += this.queryOptions != null ? this.queryOptions.hashCode() : 3982;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (!this.getClass().equals(obj.getClass())) {
            return false;
        }
        StoreRegion that = (StoreRegion)obj;
        if (!LocalUtil.equals(this.sort, that.sort)) {
            return false;
        }
        if (!LocalUtil.equals(this.query, that.query)) {
            return false;
        }
        return LocalUtil.equals(this.queryOptions, that.queryOptions);
    }
}

