/*
 * Decompiled with CFR 0.152.
 */
package org.directwebremoting.json.parse.impl;

import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import org.directwebremoting.json.parse.JsonParseException;
import org.directwebremoting.json.parse.impl.StatefulJsonDecoder;
import org.directwebremoting.util.LocalUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReflectionJsonDecoder
extends StatefulJsonDecoder {
    private final Class<?> marshallInto;

    public ReflectionJsonDecoder(Class<?> marshallInto) {
        this.marshallInto = marshallInto;
    }

    @Override
    protected Object createObject(Object parent, String propertyName) throws JsonParseException {
        return this.createArray(parent, propertyName);
    }

    @Override
    protected Object createArray(Object parent, String propertyName) throws JsonParseException {
        if (parent == null) {
            return this.createType(this.marshallInto);
        }
        Class<?> type = LocalUtil.getPropertyType(parent.getClass(), propertyName);
        return this.createType(type);
    }

    @Override
    protected void addMemberToObject(Object parent, String propertyName, Object member) throws JsonParseException {
        try {
            LocalUtil.setProperty(parent, propertyName, member);
        }
        catch (SecurityException ex) {
            throw new JsonParseException(ex);
        }
        catch (IllegalArgumentException ex) {
            throw new JsonParseException(ex);
        }
        catch (NoSuchMethodException ex) {
            throw new JsonParseException(ex);
        }
        catch (IllegalAccessException ex) {
            throw new JsonParseException(ex);
        }
        catch (InvocationTargetException ex) {
            throw new JsonParseException(ex);
        }
    }

    @Override
    protected void addMemberToArray(Object parent, Object member) {
        Collection col = (Collection)parent;
        col.add(member);
    }

    private Object createType(Class<?> type) throws JsonParseException {
        try {
            return type.newInstance();
        }
        catch (InstantiationException ex) {
            throw new JsonParseException(ex);
        }
        catch (IllegalAccessException ex) {
            throw new JsonParseException(ex);
        }
    }
}

