/*
 * Decompiled with CFR 0.152.
 */
package org.directwebremoting.json.types;

import java.util.Locale;
import org.directwebremoting.json.types.JsonValue;

public class JsonString
extends JsonValue {
    private final String value;

    public JsonString(String value) {
        this.value = value;
    }

    public String getString() {
        return this.value;
    }

    public String toExternalRepresentation() {
        return "'" + JsonString.escapeJavaScript(this.value) + "'";
    }

    public String toString() {
        return this.getString();
    }

    protected static String escapeJavaScript(String str) {
        if (str == null) {
            return null;
        }
        StringBuffer writer = new StringBuffer(str.length() * 2);
        int sz = str.length();
        block12: for (int i = 0; i < sz; ++i) {
            char ch = str.charAt(i);
            if (ch > '\u0fff') {
                writer.append("\\u");
                writer.append(JsonString.hex(ch));
                continue;
            }
            if (ch > '\u00ff') {
                writer.append("\\u0");
                writer.append(JsonString.hex(ch));
                continue;
            }
            if (ch > '\u007f') {
                writer.append("\\u00");
                writer.append(JsonString.hex(ch));
                continue;
            }
            if (ch < ' ') {
                switch (ch) {
                    case '\b': {
                        writer.append('\\');
                        writer.append('b');
                        break;
                    }
                    case '\n': {
                        writer.append('\\');
                        writer.append('n');
                        break;
                    }
                    case '\t': {
                        writer.append('\\');
                        writer.append('t');
                        break;
                    }
                    case '\f': {
                        writer.append('\\');
                        writer.append('f');
                        break;
                    }
                    case '\r': {
                        writer.append('\\');
                        writer.append('r');
                        break;
                    }
                    default: {
                        if (ch > '\u000f') {
                            writer.append("\\u00");
                            writer.append(JsonString.hex(ch));
                            break;
                        }
                        writer.append("\\u000");
                        writer.append(JsonString.hex(ch));
                        break;
                    }
                }
                continue;
            }
            switch (ch) {
                case '\'': {
                    writer.append('\\');
                    writer.append('\'');
                    continue block12;
                }
                case '\"': {
                    writer.append('\\');
                    writer.append('\"');
                    continue block12;
                }
                case '\\': {
                    writer.append('\\');
                    writer.append('\\');
                    continue block12;
                }
                default: {
                    writer.append(ch);
                }
            }
        }
        return writer.toString();
    }

    private static String hex(char ch) {
        return Integer.toHexString(ch).toUpperCase(Locale.ENGLISH);
    }
}

