/*
 * Decompiled with CFR 0.152.
 */
package org.directwebremoting.server.tomcat;

import java.io.IOException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.catalina.CometEvent;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.directwebremoting.extend.Sleeper;

public class TomcatSleeper
implements Sleeper {
    private final AtomicReference<State> state = new AtomicReference<State>(State.INITIAL);
    private final CometEvent event;
    private Runnable onAwakening;
    private static final Log log = LogFactory.getLog(TomcatSleeper.class);

    public TomcatSleeper(CometEvent event) {
        this.event = event;
        event.getHttpServletRequest().setAttribute("org.directwebremoting.server.tomcat.event", (Object)this);
    }

    public void goToSleep(Runnable awakening) {
        if (awakening == null) {
            throw new NullPointerException("Null value for awakening");
        }
        if (this.state.compareAndSet(State.INITIAL, State.ABOUT_TO_SLEEP)) {
            this.event.getHttpServletRequest().setAttribute("org.directwebremoting.server.tomcat.sleep", (Object)true);
            this.onAwakening = awakening;
            this.state.set(State.SLEEPING);
        } else if (this.state.compareAndSet(State.PRE_AWAKENED, State.FINAL)) {
            awakening.run();
        } else {
            throw new IllegalStateException("Attempt to goToSleep in state " + (Object)((Object)this.state.get()));
        }
    }

    public void wakeUp() {
        boolean retry;
        block10: do {
            retry = false;
            switch (this.state.get()) {
                case INITIAL: {
                    this.state.compareAndSet(State.INITIAL, State.PRE_AWAKENED);
                    retry = true;
                    break;
                }
                case PRE_AWAKENED: {
                    break;
                }
                case ABOUT_TO_SLEEP: {
                    try {
                        do {
                            TimeUnit.MILLISECONDS.sleep(1L);
                        } while (this.state.get() == State.ABOUT_TO_SLEEP);
                    }
                    catch (InterruptedException ex) {
                        Thread.currentThread().interrupt();
                        return;
                    }
                    retry = true;
                    break;
                }
                case SLEEPING: {
                    if (this.state.compareAndSet(State.SLEEPING, State.RESUMING)) {
                        this.onAwakening.run();
                        try {
                            this.event.close();
                        }
                        catch (IOException ex) {
                            log.warn((Object)"Error while closing the event", (Throwable)ex);
                        }
                        continue block10;
                    }
                    retry = true;
                    break;
                }
            }
        } while (retry);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum State {
        INITIAL,
        PRE_AWAKENED,
        ABOUT_TO_SLEEP,
        SLEEPING,
        RESUMING,
        FINAL;

    }
}

