/*
 * Decompiled with CFR 0.152.
 */
package org.directwebremoting.servlet;

import org.directwebremoting.extend.NamedConverter;
import org.directwebremoting.servlet.BaseDtoAllHandler;
import org.directwebremoting.servlet.DojoModule;
import org.directwebremoting.util.LocalUtil;

public class DojoDtoAllHandler
extends BaseDtoAllHandler {
    protected String dojoDwrBaseModulePath;
    protected String dojoDtoBaseModulePath;

    public String generateDtoAllScript(String contextPath, String servletPath) {
        DojoModule mod = new DojoModule(contextPath, servletPath, this.dojoDwrBaseModulePath, "dtoall");
        mod.addRequire(this.dojoDwrBaseModulePath, "engine");
        String engineModule = mod.expandModulePath(this.dojoDwrBaseModulePath, "engine");
        mod.addContent("(function() {\n");
        mod.addContent("  var c;\n");
        mod.addContent("  var addedNow = [];\n");
        for (String jsClassName : this.converterManager.getNamedConverterJavaScriptNames()) {
            String dtoModule = mod.expandModulePath(this.dojoDtoBaseModulePath, jsClassName);
            mod.addContent("\n");
            mod.addContent("  dojo.provide(\"" + dtoModule + "\");\n");
            mod.addContent("  if (!" + engineModule + "._mappedClasses[\"" + jsClassName + "\"]) {\n");
            mod.addContent(this.remoter.generateDtoJavaScript(jsClassName, "    ", "c"));
            mod.addContent("    " + engineModule + "._mappedClasses[\"" + jsClassName + "\"] = c;\n");
            mod.addContent("    addedNow[\"" + jsClassName + "\"] = true;\n");
            mod.addContent("  }\n");
            mod.addContent("  dojo.setObject(\"" + dtoModule + "\", " + engineModule + "._mappedClasses[\"" + jsClassName + "\"]);\n");
        }
        for (String jsClassName : this.converterManager.getNamedConverterJavaScriptNames()) {
            NamedConverter namedConv = this.converterManager.getNamedConverter(jsClassName);
            String jsSuperClassName = namedConv.getJavascriptSuperClass();
            if (!LocalUtil.hasLength(jsSuperClassName)) continue;
            String classExpression = engineModule + "._mappedClasses[\"" + jsClassName + "\"]";
            String superClassExpression = engineModule + "._mappedClasses[\"" + jsSuperClassName + "\"]";
            mod.addContent("\n");
            mod.addContent("  if (addedNow[\"" + jsClassName + "\"]) {\n");
            mod.addContent(this.remoter.generateDtoInheritanceJavaScript("    ", classExpression, superClassExpression, engineModule + "._delegate"));
            mod.addContent("  }\n");
        }
        mod.addContent("})();\n");
        return mod.toString();
    }

    public void setDojoDwrBaseModulePath(String modulePath) {
        this.dojoDwrBaseModulePath = modulePath;
    }

    public void setDojoDtoBaseModulePath(String modulePath) {
        this.dojoDtoBaseModulePath = modulePath;
    }
}

