/*
 * Decompiled with CFR 0.152.
 */
package org.directwebremoting.ui.dwr;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.directwebremoting.ScriptBuffer;
import org.directwebremoting.ScriptSessions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Util {
    public static void setValue(String elementId, Object value) {
        Util.setValue(elementId, value, false);
    }

    public static void setValue(String elementId, Object value, boolean escapeHtml) {
        ScriptSessions.addFunctionCall("dwr.util.setValue", elementId, value, Util.getEscapeOptions(escapeHtml));
    }

    public static void setValues(Map<?, ?> values, boolean escapeHtml) {
        ScriptSessions.addFunctionCall("dwr.util.setValues", values, Util.getEscapeOptions(escapeHtml));
    }

    public static void addOptions(String elementId, String[] array) {
        ScriptSessions.addFunctionCall("dwr.util.addOptions", elementId, array);
    }

    public static void addOptions(String elementId, Collection<?> array, String property) {
        ScriptSessions.addFunctionCall("dwr.util.addOptions", elementId, array, property);
    }

    public static void addOptions(String elementId, Collection<?> array, String valueProperty, String textProperty) {
        ScriptSessions.addFunctionCall("dwr.util.addOptions", elementId, array, valueProperty, textProperty);
    }

    public static void removeAllOptions(String elementId) {
        ScriptSessions.addFunctionCall("dwr.util.removeAllOptions", elementId);
    }

    public static void addRows(String elementId, String[][] data, String options) {
        if (null == data || data.length == 0 || null == data[0]) {
            return;
        }
        int rowCount = data.length;
        int colCount = data[0].length;
        Util.buildAddRowsScript(elementId, data, options, rowCount, colCount);
    }

    public static void addRows(String elementId, String[][] data) {
        Util.addRows(elementId, data, null);
    }

    public static void addRows(String elementId, Collection<Collection<String>> data, String options) {
        if (null == data || data.size() == 0 || data.iterator().hasNext()) {
            return;
        }
        int rowCount = data.size();
        int colCount = data.iterator().next().size();
        Util.buildAddRowsScript(elementId, data, options, rowCount, colCount);
    }

    public static void addRows(String elementId, Collection<Collection<String>> data) {
        Util.addRows(elementId, data, null);
    }

    private static void buildAddRowsScript(String elementId, Object data, String options, int rowCount, int colCount) {
        StringBuffer functions = new StringBuffer();
        for (int i = 0; i < colCount; ++i) {
            functions.append("function(data) { return data[").append(i).append("]},");
        }
        if (rowCount > 0) {
            functions.deleteCharAt(functions.length() - 1);
            ScriptBuffer script = new ScriptBuffer();
            script.appendScript("dwr.util.addRows(").appendData(elementId).appendScript(",").appendData(data).appendScript(",").appendScript("[" + functions.toString() + "]").appendScript(options == null ? "" : ", " + options).appendScript(");");
            ScriptSessions.addScript(script);
        }
    }

    public static void removeAllRows(String elementId) {
        ScriptSessions.addFunctionCall("dwr.util.removeAllRows", elementId);
    }

    public static void cloneNode(String elementId) {
        ScriptSessions.addFunctionCall("dwr.util.cloneNode", elementId);
    }

    public static void cloneNode(String elementId, String idPrefix, String idSuffix) {
        ScriptBuffer script = new ScriptBuffer();
        script.appendScript("dwr.util.cloneNode(").appendData(elementId).appendScript(", { idPrefix:").appendData(idPrefix).appendScript(", idSuffix:").appendData(idSuffix).appendScript("});");
        ScriptSessions.addScript(script);
    }

    public static void removeNode(String elementId) {
        ScriptBuffer script = new ScriptBuffer();
        script.appendScript("dwr.util._temp = dwr.util.byId(").appendData(elementId).appendScript("); ").appendScript("if (dwr.util._temp) { dwr.util._temp.parentNode.removeChild(dwr.util._temp); dwr.util._temp = null; }");
        ScriptSessions.addScript(script);
    }

    public static void setClassName(String elementId, String className) {
        ScriptSessions.addFunctionCall("dwr.util.setClassName", elementId, className);
    }

    public static void addClassName(String elementId, String className) {
        ScriptSessions.addFunctionCall("dwr.util.addClassName", elementId, className);
    }

    public static void removeClassName(String elementId, String className) {
        ScriptSessions.addFunctionCall("dwr.util.removeClassName", elementId, className);
    }

    public static void toggleClassName(String elementId, String className) {
        ScriptSessions.addFunctionCall("dwr.util.toggleClassName", elementId, className);
    }

    public static void setStyle(String elementId, String selector, String value) {
        ScriptBuffer script = new ScriptBuffer();
        script.appendScript("dwr.util.byId(").appendData(elementId).appendScript(").style.").appendScript(selector).appendScript("=").appendData(value).appendScript(";");
        ScriptSessions.addScript(script);
    }

    private static Map<String, Boolean> getEscapeOptions(boolean escapeHtml) {
        HashMap<String, Boolean> options = new HashMap<String, Boolean>();
        options.put("escapeHtml", escapeHtml);
        return options;
    }
}

