/*
 * Decompiled with CFR 0.152.
 */
package org.exist.security.realm.ldap;

import javax.naming.NamingException;
import org.exist.config.Configurable;
import org.exist.config.Configuration;
import org.exist.config.Configurator;
import org.exist.config.annotation.ConfigurationClass;
import org.exist.config.annotation.ConfigurationFieldAsElement;
import org.exist.security.realm.ldap.LDAPSearchAccount;
import org.exist.security.realm.ldap.LDAPSearchGroup;

@ConfigurationClass(value="search")
public class LDAPSearchContext
implements Configurable {
    @ConfigurationFieldAsElement(value="base")
    protected String base = null;
    @ConfigurationFieldAsElement(value="default-username")
    protected String defaultUsername = null;
    @ConfigurationFieldAsElement(value="default-password")
    protected String defaultPassword = null;
    @ConfigurationFieldAsElement(value="account")
    protected LDAPSearchAccount searchAccount = null;
    @ConfigurationFieldAsElement(value="group")
    protected LDAPSearchGroup searchGroup = null;
    private final Configuration configuration;

    public LDAPSearchContext(Configuration config) {
        this.configuration = Configurator.configure((Configurable)this, (Configuration)config);
    }

    public String getBase() {
        return this.base;
    }

    public String getAbsoluteBase() throws NamingException {
        if (this.getBase() != null) {
            int index = this.getBase().indexOf("dc=");
            if (index >= 0) {
                return this.getBase().substring(index);
            }
            index = this.getBase().indexOf("DC=");
            if (index >= 0) {
                return this.getBase().substring(index);
            }
        } else {
            throw new NamingException("no 'base' defined");
        }
        throw new NamingException("'base' have no 'dc=' or 'DC='");
    }

    public String getDefaultUsername() {
        return this.defaultUsername;
    }

    public String getDefaultPassword() {
        return this.defaultPassword;
    }

    public LDAPSearchAccount getSearchAccount() {
        return this.searchAccount;
    }

    public LDAPSearchGroup getSearchGroup() {
        return this.searchGroup;
    }

    public boolean isConfigured() {
        return this.configuration != null;
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }
}

