/*
 * Decompiled with CFR 0.152.
 */
package findstruct;

import findstruct.U;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jdom.Document;
import org.jdom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StructModel {
    SM topPart = null;
    Pattern itemPat;
    Pattern itemEndPat;
    Pattern itemEnd2Pat;
    StructOptions rootStructOptions = null;

    public StructModel(Document doc) {
        Element root = doc.getRootElement();
        this.rootStructOptions = new StructOptions(root, null, null, null);
        this.itemPat = this.rootStructOptions.createListPattern();
        this.itemEndPat = Pattern.compile("$", 8);
        this.itemEnd2Pat = Pattern.compile("$^$", 8);
        this.topPart = new SM((Element)root.getChildren().get(0), this, this.rootStructOptions);
    }

    public Element process(String s) {
        if (this.topPart != null) {
            return this.topPart.process(s, 0, s.length());
        }
        return null;
    }

    ArrayList<LFR> findItemMarkers(String s) {
        ArrayList<LFR> r = new ArrayList<LFR>();
        boolean progress = false;
        Matcher m = this.itemPat.matcher(s);
        while (m.find()) {
            try {
                Integer i = new Integer(m.group(2));
                r.add(new LFR(m.start(), m.end(), i, m.group(1), m.group(3)));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return r;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("<StructModel");
        sb.append(" prefix=\"" + this.rootStructOptions.prefix + "\"");
        sb.append(" suffix=\"" + this.rootStructOptions.suffix + "\"");
        sb.append(" flags=" + this.rootStructOptions.patternFlags);
        sb.append(">");
        return sb.toString();
    }

    class LFR
    implements Comparable {
        Integer num;
        int start;
        int end;
        String pre;
        String post;

        LFR(int start, int end, Integer num, String pre, String post) {
            this.num = num;
            this.start = start;
            this.end = end;
            this.pre = pre;
            this.post = post;
        }

        public int compareTo(Object o) {
            if (!(o instanceof LFR)) {
                return -1;
            }
            LFR other = (LFR)o;
            if (this.start < other.start) {
                return -1;
            }
            if (this.start > other.start) {
                return 1;
            }
            if (this.end < other.end) {
                return -1;
            }
            if (this.end > other.end) {
                return 1;
            }
            return 0;
        }

        public String toString() {
            StringBuffer sb = new StringBuffer("<LFR ");
            sb.append(this.num);
            sb.append(": ");
            sb.append(this.start);
            sb.append("-");
            sb.append(this.end);
            sb.append("[");
            sb.append(this.pre);
            sb.append("][");
            sb.append(this.post);
            sb.append("]>");
            return sb.toString();
        }
    }

    class Match
    implements Comparable {
        int start = 0;
        int end = 0;
        SM matched;
        ArrayList<String> keys = null;
        ArrayList<String> vals = new ArrayList();

        Match(int s, int e, SM modelMatched) {
            this.start = s;
            this.end = e;
            this.matched = modelMatched;
        }

        void bind(String key, String val) {
            if (this.keys == null) {
                this.keys = new ArrayList();
                this.vals = new ArrayList();
            }
            this.keys.add(key);
            this.vals.add(val);
        }

        int numBindings() {
            if (this.keys == null) {
                return 0;
            }
            if (this.keys.get(0) == null) {
                return -1;
            }
            return this.keys.size();
        }

        Element bindingToXML(int i) {
            Element e = new Element(this.keys.get(i));
            e.addContent(this.vals.get(i));
            return e;
        }

        public int compareTo(Object o) {
            if (o instanceof Match) {
                Match other = (Match)o;
                if (this.start < other.start) {
                    return -1;
                }
                if (this.start > other.start) {
                    return 1;
                }
                if (this.end < other.end) {
                    return -1;
                }
                if (this.end > other.end) {
                    return 1;
                }
                return 0;
            }
            return -1;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class SM {
        ArrayList<Pattern> beg = new ArrayList();
        String name = null;
        Pattern pattern = null;
        String[] bindings = null;
        StructOptions opts;
        ArrayList<SM> parts = null;
        StructModel context = null;

        SM(Element e, StructModel m, StructOptions defaultOpts) {
            List ch;
            String altString;
            String attrsString;
            this.context = m;
            this.name = e.getName();
            this.opts = new StructOptions(e, defaultOpts);
            this.beg.add(this.opts.createSearchPattern(this.name));
            String patternString = e.getAttributeValue("pattern");
            if (patternString != null) {
                this.pattern = Pattern.compile(patternString, this.opts.patternFlags);
            }
            if ((attrsString = e.getAttributeValue("attrs")) != null) {
                this.bindings = U.split((String)attrsString, (String)",");
            }
            if ((altString = e.getAttributeValue("alt")) != null) {
                String[] attrs;
                String[] stringArray = attrs = U.split((String)altString, (String)",");
                int n = attrs.length;
                int n2 = 0;
                while (n2 < n) {
                    String a = stringArray[n2];
                    this.beg.add(this.opts.createSearchPattern(a));
                    ++n2;
                }
            }
            if ((ch = e.getChildren()).size() > 0) {
                this.parts = new ArrayList(ch.size());
            }
            for (Object po : e.getChildren()) {
                Element se = (Element)po;
                this.parts.add(new SM(se, m, this.opts));
            }
        }

        boolean isPattern() {
            return this.pattern != null;
        }

        public String toString() {
            StringBuffer sb = new StringBuffer("<SM ");
            sb.append(this.name);
            if (this.pattern != null) {
                sb.append(" pattern=\"");
                sb.append(this.pattern);
                sb.append("\"");
            }
            for (Pattern p : this.beg) {
                sb.append(" beg=\"");
                sb.append(p);
                sb.append("\"");
            }
            if (this.parts != null) {
                sb.append(" #");
                sb.append(this.parts.size());
            }
            sb.append(">");
            return sb.toString();
        }

        Element process(String s, int start, int end) {
            Element result = new Element(this.name);
            TreeSet<Match> matches = new TreeSet<Match>();
            if (this.parts != null) {
                for (SM ssm : this.parts) {
                    ArrayList<Match> results = ssm.tryMatch(s, start, end);
                    for (Match m : results) {
                        matches.add(m);
                    }
                }
            }
            Iterator it = matches.iterator();
            Match next = null;
            if (!it.hasNext()) {
                this.addText(result, s, start, end);
                return result;
            }
            next = (Match)it.next();
            Match curr = null;
            int used = start;
            do {
                curr = next;
                Match match = next = it.hasNext() ? (Match)it.next() : null;
                if (used < curr.start) {
                    this.addText(result, s, used, curr.start);
                    used = curr.start;
                } else if (used > curr.start) {
                    System.err.println("Overlapped matches among parts of " + this.name + ": " + used + " vs. " + curr.start);
                }
                SM mod = curr.matched;
                if (curr.matched.isPattern()) {
                    Element patElt = new Element(mod.name);
                    int nb = curr.numBindings();
                    if (nb < 0) {
                        patElt.addContent(curr.vals.get(0));
                    } else {
                        int i = 0;
                        while (i < nb) {
                            patElt.addContent(curr.bindingToXML(i));
                            ++i;
                        }
                    }
                    result.addContent(patElt);
                    used = curr.end;
                    continue;
                }
                used = curr.end;
                int thisEnd = next == null ? end : next.start;
                result.addContent(mod.process(s, used, thisEnd));
                used = thisEnd;
            } while (next != null);
            if (used < end) {
                this.addText(result, s, used, end);
            }
            return result;
        }

        ArrayList<Match> tryMatch(String s, int start, int end) {
            ArrayList<Match> alm = new ArrayList<Match>();
            if (this.isPattern()) {
                Matcher m = this.pattern.matcher(s);
                m.region(start, end);
                while (m.find()) {
                    Match mtch = new Match(m.start(), m.end(), this);
                    if (this.bindings != null) {
                        int gc = Math.min(m.groupCount(), this.bindings.length);
                        int i = 1;
                        while (i <= gc) {
                            mtch.bind(this.bindings[i - 1], m.group(i));
                            ++i;
                        }
                    } else if (m.groupCount() > 0) {
                        mtch.bind(null, m.group(1));
                    }
                    alm.add(mtch);
                }
            } else {
                for (Pattern p : this.beg) {
                    Matcher m = p.matcher(s);
                    m.region(start, end);
                    while (m.find()) {
                        Match mtch = new Match(m.start(), m.end(), this);
                        alm.add(mtch);
                    }
                }
            }
            return alm;
        }

        void addText(Element elt, String s, int start, int end) {
            String content = null;
            try {
                if (start > end) {
                    end = start;
                }
                content = s.substring(start, end);
            }
            catch (Exception e) {
                System.out.println(String.valueOf(start));
                System.out.println(String.valueOf(end));
                System.out.println(s.length());
                e.printStackTrace();
            }
            if (!this.opts.findLists) {
                elt.addContent(content.trim());
            } else {
                ArrayList<LFR> r = StructModel.this.findItemMarkers(content);
                LFR last = null;
                LFR curr = null;
                Iterator<LFR> it = r.iterator();
                int nextItemNum = 1;
                int used = 0;
                Element currList = null;
                while (curr != null || it.hasNext()) {
                    last = curr;
                    LFR lFR = curr = it.hasNext() ? it.next() : null;
                    if (curr != null && curr.num != nextItemNum && curr.num != 1) {
                        System.err.println("Mistaken number " + curr.num + " should be " + nextItemNum);
                        curr = last;
                        continue;
                    }
                    if (last != null) {
                        Element item = new Element("item");
                        item.setAttribute("number", last.num.toString());
                        currList.addContent(item);
                        int itemEnd = content.length();
                        if (curr != null) {
                            itemEnd = curr.start;
                        }
                        int itemBreak = itemEnd;
                        if (curr == null || curr.num == 1) {
                            currList = null;
                            Matcher mLineBreak = StructModel.this.itemEnd2Pat.matcher(content);
                            if (mLineBreak.find(last.end)) {
                                itemBreak = Math.min(itemEnd, mLineBreak.start());
                            }
                        }
                        item.addContent(content.substring(last.end, itemBreak));
                        used = itemBreak;
                        if (itemBreak < itemEnd) {
                            elt.addContent(content.substring(itemBreak, itemEnd));
                            used = itemEnd;
                        }
                    } else {
                        elt.addContent(content.substring(used, curr.start));
                        used = curr.start;
                    }
                    if (curr != null && curr.num == 1) {
                        currList = new Element("list");
                        elt.addContent(currList);
                        nextItemNum = 2;
                        continue;
                    }
                    ++nextItemNum;
                }
                if (used < content.length()) {
                    elt.addContent(content.substring(used));
                }
            }
        }
    }

    class StructOptions {
        String prefix = "";
        String suffix = "";
        boolean findLists = false;
        String listPrefix = "\\s|^|\\s\\(\\s";
        String listPat = "\\d+";
        String listSuffix = "[):\\.]\\s|\\s\\)";
        int patternFlags = 0;

        private StructOptions() {
        }

        private StructOptions(Element e) {
            this(e, null);
        }

        private StructOptions(Element e, StructOptions so) {
            this();
            String v;
            if (so != null) {
                this.copyFrom(so);
            }
            if ((v = e.getAttributeValue("prefix")) != null) {
                this.prefix = v;
            }
            if ((v = e.getAttributeValue("suffix")) != null) {
                this.suffix = v;
            }
            if ((v = e.getAttributeValue("case_insensitive")) != null) {
                this.patternFlags = v.equalsIgnoreCase("yes") ? (this.patternFlags |= 2) : (this.patternFlags &= 0xFFFFFFFD);
            }
            if ((v = e.getAttributeValue("canon_eq")) != null) {
                this.patternFlags = v.equalsIgnoreCase("yes") ? (this.patternFlags |= 0x80) : (this.patternFlags &= 0xFFFFFF7F);
            }
            if ((v = e.getAttributeValue("comments")) != null) {
                this.patternFlags = v.equalsIgnoreCase("yes") ? (this.patternFlags |= 4) : (this.patternFlags &= 0xFFFFFFFB);
            }
            if ((v = e.getAttributeValue("dotall")) != null) {
                this.patternFlags = v.equalsIgnoreCase("yes") ? (this.patternFlags |= 0x20) : (this.patternFlags &= 0xFFFFFFDF);
            }
            if ((v = e.getAttributeValue("multiline")) != null) {
                this.patternFlags = v.equalsIgnoreCase("yes") ? (this.patternFlags |= 8) : (this.patternFlags &= 0xFFFFFFF7);
            }
            if ((v = e.getAttributeValue("unix_lines")) != null) {
                this.patternFlags = v.equalsIgnoreCase("yes") ? (this.patternFlags |= 1) : (this.patternFlags &= 0xFFFFFFFE);
            }
            if ((v = e.getAttributeValue("lists")) != null) {
                this.findLists = v.equalsIgnoreCase("yes");
            }
            if ((v = e.getAttributeValue("listPat")) != null) {
                this.listPat = v;
            }
            if ((v = e.getAttributeValue("listPrefix")) != null) {
                this.listPrefix = v;
            }
            if ((v = e.getAttributeValue("listSuffix")) != null) {
                this.listSuffix = v;
            }
        }

        void copyFrom(StructOptions so) {
            this.prefix = so.prefix;
            this.suffix = so.suffix;
            this.findLists = so.findLists;
            this.listPrefix = so.listPrefix;
            this.listPat = so.listPat;
            this.listSuffix = so.listSuffix;
            this.patternFlags = so.patternFlags;
        }

        private Pattern createSearchPattern(String name) {
            String pat = name.replaceAll("_", "\\\\s+");
            return Pattern.compile(String.valueOf(this.prefix) + pat + this.suffix, this.patternFlags);
        }

        private Pattern createListPattern() {
            return Pattern.compile("(" + this.listPrefix + ")(" + this.listPat + ")(" + this.listSuffix + ")", 8);
        }

        /* synthetic */ StructOptions(Element element, StructOptions structOptions, StructOptions structOptions2, StructOptions structOptions3) {
            this(element);
        }
    }
}

