/*
 * Decompiled with CFR 0.152.
 */
package org.exist.fluent;

import java.util.Calendar;
import java.util.Comparator;
import java.util.Date;
import java.util.GregorianCalendar;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;
import org.exist.util.Base64Encoder;

public class DataUtils {
    public static final Comparator<XMLGregorianCalendar> DATE_TIME_COMPARATOR = new Comparator<XMLGregorianCalendar>(){

        @Override
        public int compare(XMLGregorianCalendar a, XMLGregorianCalendar b) {
            int r = a.compare(b);
            if (r == 2) {
                throw new RuntimeException("date-times not comparable:  " + a + " and " + b);
            }
            return r;
        }
    };
    private static DatatypeFactory datatypeFactory;

    private DataUtils() {
    }

    public static DatatypeFactory datatypeFactory() {
        return datatypeFactory;
    }

    public static Date toDate(XMLGregorianCalendar dateTime) {
        return dateTime.toGregorianCalendar().getTime();
    }

    public static XMLGregorianCalendar toDateTime(Date date) {
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(date);
        return DataUtils.datatypeFactory().newXMLGregorianCalendar(cal).normalize();
    }

    public static XMLGregorianCalendar toDateTime(long millis) {
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTimeInMillis(millis);
        return DataUtils.datatypeFactory().newXMLGregorianCalendar(cal).normalize();
    }

    public static String toXMLString(Object o) {
        Object r = DataUtils.toXMLObject(o);
        if (r.getClass() != String.class) {
            r = r.toString();
        }
        return (String)r;
    }

    public static Object toXMLObject(Object o) {
        if (o instanceof Date) {
            return DataUtils.toDateTime((Date)o).toString();
        }
        if (o instanceof Calendar) {
            return DataUtils.toDateTime(((Calendar)o).getTimeInMillis()).toString();
        }
        if (o instanceof byte[]) {
            Base64Encoder encoder = new Base64Encoder();
            encoder.translate((byte[])o);
            return String.valueOf(encoder.getCharArray());
        }
        return o;
    }

    static {
        try {
            datatypeFactory = DatatypeFactory.newInstance();
        }
        catch (DatatypeConfigurationException e) {
            throw new RuntimeException("unable to configure datatype factory", e);
        }
    }
}

