/*
 * Decompiled with CFR 0.152.
 */
package org.exist.fluent;

import java.util.Date;
import javax.xml.datatype.Duration;
import javax.xml.datatype.XMLGregorianCalendar;
import org.exist.dom.persistent.NodeProxy;
import org.exist.fluent.DataUtils;
import org.exist.fluent.Database;
import org.exist.fluent.DatabaseException;
import org.exist.fluent.ItemList;
import org.exist.fluent.NamespaceMap;
import org.exist.fluent.Node;
import org.exist.fluent.QueryService;
import org.exist.fluent.Resource;
import org.exist.storage.DBBroker;
import org.exist.storage.serializers.Serializer;
import org.exist.xquery.Constants;
import org.exist.xquery.XPathException;
import org.exist.xquery.value.AtomicValue;
import org.exist.xquery.value.NodeValue;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.Type;
import org.xml.sax.SAXException;

public class Item
extends Resource {
    protected final org.exist.xquery.value.Item item;
    static final Item NULL = new Item(){

        @Override
        public boolean booleanValue() {
            return false;
        }

        @Override
        public int intValue() {
            return 0;
        }

        @Override
        public long longValue() {
            return 0L;
        }

        @Override
        public double doubleValue() {
            return 0.0;
        }

        @Override
        public Duration durationValue() {
            return null;
        }

        @Override
        public XMLGregorianCalendar dateTimeValue() {
            return null;
        }

        @Override
        public Date instantValue() {
            return null;
        }

        @Override
        public Node node() {
            return Node.NULL;
        }

        @Override
        public boolean extant() {
            return false;
        }

        @Override
        public QueryService query() {
            return QueryService.NULL;
        }

        @Override
        public String value() {
            return null;
        }

        @Override
        public String valueWithDefault(String defaultValue) {
            return defaultValue;
        }

        @Override
        public String toString() {
            return "NULL item";
        }

        @Override
        Sequence convertToSequence() {
            return Sequence.EMPTY_SEQUENCE;
        }
    };

    Item() {
        super(null, null);
        this.item = null;
    }

    Item(org.exist.xquery.value.Item item, NamespaceMap namespaceBindings, Database db) {
        super(namespaceBindings, db);
        this.item = item;
    }

    public Node node() {
        throw new DatabaseException("this item is not a node: " + this);
    }

    public boolean equals(Object o) {
        if (!(o instanceof Item)) {
            return false;
        }
        Item that = (Item)o;
        if (this.item == that.item) {
            return true;
        }
        if (this.item instanceof AtomicValue && that.item instanceof AtomicValue) {
            AtomicValue thisValue = (AtomicValue)this.item;
            AtomicValue thatValue = (AtomicValue)that.item;
            try {
                return thisValue.getType() == thatValue.getType() && thisValue.compareTo(null, Constants.Comparison.EQ, thatValue);
            }
            catch (XPathException xPathException) {
                // empty catch block
            }
        }
        return false;
    }

    public int hashCode() {
        if (this.item instanceof AtomicValue) {
            AtomicValue value = (AtomicValue)this.item;
            try {
                return value.getType() ^ value.getStringValue().hashCode();
            }
            catch (XPathException e) {
                return value.getType();
            }
        }
        return this.item.hashCode();
    }

    public String type() {
        return Type.getTypeName((int)this.item.getType());
    }

    public boolean extant() {
        return true;
    }

    @Override
    Sequence convertToSequence() {
        return this.item.toSequence();
    }

    public ItemList toItemList() {
        return new ItemList(this.convertToSequence(), this.namespaceBindings.extend(), this.db);
    }

    public Item toAtomicItem() {
        try {
            AtomicValue atomizedItem = this.item.atomize();
            return atomizedItem == this.item ? this : new Item((org.exist.xquery.value.Item)atomizedItem, this.namespaceBindings.extend(), this.db);
        }
        catch (XPathException e) {
            throw new DatabaseException("unable to atomize item", e);
        }
    }

    public String value() {
        try {
            return this.item.getStringValue();
        }
        catch (XPathException e) {
            throw new DatabaseException(e);
        }
    }

    public String valueWithDefault(String defaultValue) {
        return this.value();
    }

    public boolean booleanValue() {
        try {
            return (Boolean)this.item.toJavaObject(Boolean.class);
        }
        catch (XPathException e) {
            throw new DatabaseException(e);
        }
    }

    public int intValue() {
        try {
            return (Integer)this.item.toJavaObject(Integer.class);
        }
        catch (XPathException e) {
            throw new DatabaseException(e);
        }
    }

    public long longValue() {
        try {
            return (Long)this.item.toJavaObject(Long.class);
        }
        catch (XPathException e) {
            throw new DatabaseException(e);
        }
    }

    public double doubleValue() {
        try {
            return (Double)this.item.toJavaObject(Double.class);
        }
        catch (XPathException e) {
            throw new DatabaseException(e);
        }
    }

    public Duration durationValue() {
        try {
            return DataUtils.datatypeFactory().newDuration(this.value());
        }
        catch (IllegalArgumentException e) {
            throw new DatabaseException(e);
        }
    }

    public XMLGregorianCalendar dateTimeValue() {
        try {
            return DataUtils.datatypeFactory().newXMLGregorianCalendar(this.value());
        }
        catch (IllegalArgumentException e) {
            throw new DatabaseException(e);
        }
    }

    public Date instantValue() {
        return DataUtils.toDate(this.dateTimeValue());
    }

    public Comparable<Object> comparableValue() {
        try {
            return this.item.getType() == 21 ? this.item.convertTo(22) : (Comparable)this.item;
        }
        catch (XPathException e) {
            throw new DatabaseException("unable to convert to comparable value", e);
        }
    }

    public String toString() {
        if (this.item instanceof AtomicValue) {
            return this.value();
        }
        assert (this.item instanceof NodeValue);
        DBBroker broker = null;
        try {
            NodeProxy proxy;
            broker = this.db.acquireBroker();
            Serializer serializer = broker.getSerializer();
            if (this.item instanceof NodeProxy && (proxy = (NodeProxy)this.item).isDocument()) {
                String string = serializer.serialize(proxy.getOwnerDocument());
                return string;
            }
            String string = serializer.serialize((NodeValue)this.item);
            return string;
        }
        catch (SAXException e) {
            throw new DatabaseException(e);
        }
        finally {
            this.db.releaseBroker(broker);
        }
    }
}

