/*
 * Decompiled with CFR 0.152.
 */
package org.exist.fluent;

import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.exist.dom.persistent.AVLTreeNodeSet;
import org.exist.fluent.Database;
import org.exist.fluent.DatabaseException;
import org.exist.fluent.Item;
import org.exist.fluent.NamespaceMap;
import org.exist.fluent.Node;
import org.exist.fluent.QueryService;
import org.exist.fluent.Resource;
import org.exist.fluent.Transaction;
import org.exist.fluent.XMLDocument;
import org.exist.xquery.XPathException;
import org.exist.xquery.value.NodeValue;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceIterator;
import org.exist.xquery.value.ValueSequence;

public class ItemList
extends Resource
implements Iterable<Item> {
    private Sequence seq;
    private List<Item> items;
    private List<Item> modifiableItems;
    private ValuesFacet values;
    private NodesFacet nodes;
    static final ItemList NULL = new ItemList(){

        @Override
        public QueryService query() {
            return QueryService.NULL;
        }

        @Override
        public ValuesFacet values() {
            return new ValuesFacet(){

                @Override
                public Iterator<String> iterator() {
                    return Database.emptyIterator();
                }
            };
        }

        @Override
        public NodesFacet nodes() {
            return new NodesFacet(){

                @Override
                public Iterator<Node> iterator() {
                    return Database.emptyIterator();
                }
            };
        }
    };

    private ItemList() {
        super(null, null);
        this.seq = Sequence.EMPTY_SEQUENCE;
        this.modifiableItems = Collections.emptyList();
        this.items = this.modifiableItems;
    }

    ItemList(Sequence seq, NamespaceMap namespaceBindings, Database db) {
        super(namespaceBindings, db);
        this.seq = seq;
        this.modifiableItems = new ArrayList<Item>(seq.getItemCount());
        try {
            SequenceIterator it = seq.iterate();
            while (it.hasNext()) {
                org.exist.xquery.value.Item existItem = it.nextItem();
                if (existItem instanceof NodeValue) {
                    this.modifiableItems.add(new Node((NodeValue)existItem, namespaceBindings.extend(), db));
                    continue;
                }
                this.modifiableItems.add(new Item(existItem, namespaceBindings.extend(), db));
            }
        }
        catch (XPathException xpe) {
            throw new DatabaseException(xpe);
        }
        this.items = Collections.unmodifiableList(this.modifiableItems);
    }

    public void removeDeletedNodes() {
        boolean itemsRemoved = false;
        Iterator<Item> it = this.modifiableItems.iterator();
        while (it.hasNext()) {
            Item item = it.next();
            if (!(item instanceof Node) || !((Node)item).staleMarker.stale()) continue;
            it.remove();
            itemsRemoved = true;
        }
        if (!itemsRemoved) {
            return;
        }
        boolean nodesOnly = true;
        for (Item item : this.items) {
            if (item instanceof Node) continue;
            nodesOnly = false;
            break;
        }
        this.seq = nodesOnly ? new AVLTreeNodeSet() : new ValueSequence();
        try {
            for (Item item : this.items) {
                this.seq.add(item.item);
            }
        }
        catch (XPathException e) {
            throw new DatabaseException(e);
        }
    }

    @Override
    Sequence convertToSequence() {
        for (Item item : this.items) {
            if (!(item instanceof Node)) continue;
            ((Node)item).staleMarker.check();
        }
        return this.seq;
    }

    public int size() {
        return this.items.size();
    }

    public boolean isEmpty() {
        return this.items.isEmpty();
    }

    public Item get(int index) {
        return this.items.get(index);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteAllNodes() {
        Transaction tx = Database.requireTransaction();
        try {
            for (Item item : this.items) {
                if (!(item instanceof Node)) continue;
                ((Node)item).delete();
            }
            tx.commit();
        }
        finally {
            tx.abortIfIncomplete();
        }
    }

    public boolean equals(Object o) {
        if (!(o instanceof ItemList)) {
            return false;
        }
        return this.items.equals(((ItemList)o).items);
    }

    public int hashCode() {
        int hashCode = 1;
        for (Item item : this.items) {
            hashCode = hashCode * 31 + item.hashCode();
        }
        return hashCode;
    }

    @Override
    public Iterator<Item> iterator() {
        return this.items.iterator();
    }

    public List<Item> asList() {
        return this.items;
    }

    public Item[] toArray() {
        return this.items.toArray(new Item[this.size()]);
    }

    public Item[] toArray(Item[] a) {
        return this.items.toArray(a);
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("(");
        boolean first = true;
        for (Item item : this.items) {
            if (first) {
                first = false;
            } else {
                buf.append(", ");
            }
            buf.append(item);
        }
        buf.append(")");
        return buf.toString();
    }

    public ValuesFacet values() {
        if (this.values == null) {
            this.values = new ValuesFacet();
        }
        return this.values;
    }

    public NodesFacet nodes() {
        if (this.nodes == null) {
            this.nodes = new NodesFacet();
        }
        return this.nodes;
    }

    public class NodesFacet
    implements Iterable<Node> {
        private NodesFacet() {
        }

        @Override
        public Iterator<Node> iterator() {
            return new Iterator<Node>(){
                private final Iterator<Item> delegate;
                {
                    this.delegate = ItemList.this.iterator();
                }

                @Override
                public boolean hasNext() {
                    return this.delegate.hasNext();
                }

                @Override
                public Node next() {
                    try {
                        return (Node)this.delegate.next();
                    }
                    catch (ClassCastException e) {
                        throw new DatabaseException("item is not a node");
                    }
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }

        public Set<XMLDocument> documents() {
            HashSet<XMLDocument> docs = new HashSet<XMLDocument>();
            for (Node node : this) {
                try {
                    docs.add(node.document());
                }
                catch (UnsupportedOperationException unsupportedOperationException) {}
            }
            return docs;
        }

        private ItemList itemList() {
            return ItemList.this;
        }

        public boolean equals(Object o) {
            return o instanceof NodesFacet && ItemList.this.equals(((NodesFacet)o).itemList());
        }

        public int hashCode() {
            return ItemList.this.hashCode() + 1;
        }

        public List<Node> asList() {
            return new AbstractList<Node>(){

                @Override
                public Node get(int index) {
                    try {
                        return (Node)ItemList.this.items.get(index);
                    }
                    catch (ClassCastException e) {
                        throw new DatabaseException("item is not a node");
                    }
                }

                @Override
                public int size() {
                    return ItemList.this.items.size();
                }
            };
        }

        public Node[] toArray() {
            return this.asList().toArray(new Node[ItemList.this.size()]);
        }

        public Node[] toArray(Node[] a) {
            return this.asList().toArray(a);
        }

        public String toString() {
            StringBuilder buf = new StringBuilder();
            for (Node node : this) {
                buf.append(node).append('\n');
            }
            return buf.toString();
        }
    }

    public class ValuesFacet
    implements Iterable<String> {
        private ValuesFacet() {
        }

        @Override
        public Iterator<String> iterator() {
            return new Iterator<String>(){
                private final Iterator<Item> delegate;
                {
                    this.delegate = ItemList.this.iterator();
                }

                @Override
                public boolean hasNext() {
                    return this.delegate.hasNext();
                }

                @Override
                public String next() {
                    return this.delegate.next().value();
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }

        private ItemList itemList() {
            return ItemList.this;
        }

        public boolean equals(Object o) {
            return o instanceof ValuesFacet && ItemList.this.equals(((ValuesFacet)o).itemList());
        }

        public int hashCode() {
            return ItemList.this.hashCode() + 2;
        }

        public List<String> asList() {
            return new AbstractList<String>(){

                @Override
                public String get(int index) {
                    return ((Item)ItemList.this.items.get(index)).value();
                }

                @Override
                public int size() {
                    return ItemList.this.items.size();
                }
            };
        }

        public String[] toArray() {
            return this.asList().toArray(new String[ItemList.this.size()]);
        }

        public String[] toArray(String[] a) {
            return this.asList().toArray(a);
        }

        public String toString() {
            return ItemList.this.toString();
        }
    }
}

