/*
 * Decompiled with CFR 0.152.
 */
package org.exist.fluent;

import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.exist.collections.Collection;
import org.exist.collections.triggers.CollectionTrigger;
import org.exist.collections.triggers.DocumentTrigger;
import org.exist.collections.triggers.SAXTrigger;
import org.exist.collections.triggers.TriggerException;
import org.exist.dom.persistent.DocumentImpl;
import org.exist.fluent.Database;
import org.exist.fluent.Document;
import org.exist.fluent.Folder;
import org.exist.fluent.Listener;
import org.exist.fluent.Resource;
import org.exist.fluent.Trigger;
import org.exist.storage.DBBroker;
import org.exist.storage.txn.Txn;
import org.exist.xmldb.XmldbURI;

public class ListenerManager {
    private final Map<EventKey, List<ListenerWrapper>>[] listenerMaps = new Map[Depth.values().length];
    static final ListenerManager INSTANCE = new ListenerManager();

    static String getTriggerConfigXml() {
        return "<triggers><trigger class='org.exist.fluent.ListenerManager$TriggerDispatcher'/></triggers>";
    }

    private ListenerManager() {
        this.listenerMaps[Depth.ZERO.ordinal()] = Collections.synchronizedMap(new HashMap());
        this.listenerMaps[Depth.ONE.ordinal()] = Collections.synchronizedMap(new HashMap());
        this.listenerMaps[Depth.MANY.ordinal()] = Collections.synchronizedSortedMap(new TreeMap());
    }

    private void checkListenerType(Listener listener) {
        if (!(listener instanceof Document.Listener) && !(listener instanceof Folder.Listener)) {
            throw new IllegalArgumentException("invalid listener type " + listener.getClass().getName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void add(String pathPrefix, Depth depth, Set<Trigger> triggers, Listener listener, Resource origin) {
        this.checkListenerType(listener);
        if (triggers.isEmpty()) {
            throw new IllegalArgumentException("cannot add listener with empty set of triggers");
        }
        for (Trigger trigger : triggers) {
            List<ListenerWrapper> list;
            EventKey key = new EventKey(pathPrefix, trigger);
            Object object = this.listenerMaps[depth.ordinal()];
            synchronized (object) {
                list = this.listenerMaps[depth.ordinal()].get(key);
                if (list == null) {
                    list = new LinkedList<ListenerWrapper>();
                    this.listenerMaps[depth.ordinal()].put(key, list);
                }
            }
            object = list;
            synchronized (object) {
                list.add(new ListenerWrapper(listener, origin));
            }
        }
    }

    void remove(String pathPrefix, Depth depth, Listener listener) {
        this.remove(pathPrefix, this.listenerMaps[depth.ordinal()], listener);
    }

    void remove(Listener listener) {
        for (Map<EventKey, List<ListenerWrapper>> map : this.listenerMaps) {
            this.remove(null, map, listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void remove(String path, Map<EventKey, List<ListenerWrapper>> map, Listener listener) {
        this.checkListenerType(listener);
        Map<EventKey, List<ListenerWrapper>> map2 = map;
        synchronized (map2) {
            Iterator<Map.Entry<EventKey, List<ListenerWrapper>>> it = map.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry<EventKey, List<ListenerWrapper>> entry = it.next();
                if (path != null && !entry.getKey().path.equals(path)) continue;
                List<ListenerWrapper> list = entry.getValue();
                synchronized (list) {
                    Iterator<ListenerWrapper> it2 = entry.getValue().iterator();
                    while (it2.hasNext()) {
                        if (!it2.next().sameOrNull(listener)) continue;
                        it2.remove();
                    }
                }
                if (!entry.getValue().isEmpty()) continue;
                it.remove();
            }
        }
    }

    void fire(EventKey key, DocumentImpl doc) {
        this.fire(key, doc, null, true);
    }

    void fire(EventKey key, Collection col) {
        this.fire(key, null, col, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fire(EventKey key, DocumentImpl doc, Collection col, boolean documentEvent) {
        Map.Entry entry;
        EventKey target;
        TreeMap tailMap;
        this.fire(this.listenerMaps[Depth.ZERO.ordinal()].get(key), key, doc, col, documentEvent);
        int k = key.path.lastIndexOf(47);
        assert (k != -1);
        if (k > 0) {
            EventKey trimmedKey = new EventKey(key.path.substring(0, k), key.trigger);
            this.fire(this.listenerMaps[Depth.ONE.ordinal()].get(trimmedKey), key, doc, col, documentEvent);
        }
        SortedMap map = (SortedMap)this.listenerMaps[Depth.MANY.ordinal()];
        Object object = map;
        synchronized (object) {
            tailMap = new TreeMap(map.tailMap(key));
        }
        object = tailMap.entrySet().iterator();
        while (object.hasNext() && (target = (EventKey)(entry = (Map.Entry)object.next()).getKey()).matchesAsPrefix(key)) {
            this.fire((List)entry.getValue(), key, doc, col, documentEvent);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fire(List<ListenerWrapper> list, EventKey key, DocumentImpl doc, Collection col, boolean documentEvent) {
        ArrayList<ListenerWrapper> listCopy;
        if (list == null) {
            return;
        }
        Iterator iterator = list;
        synchronized (iterator) {
            Iterator<ListenerWrapper> it = list.iterator();
            while (it.hasNext()) {
                if (it.next().isAlive()) continue;
                it.remove();
            }
            listCopy = new ArrayList<ListenerWrapper>(list);
        }
        if (documentEvent) {
            for (ListenerWrapper wrap : listCopy) {
                wrap.fireDocumentEvent(key, doc);
            }
        } else {
            for (ListenerWrapper wrap : listCopy) {
                wrap.fireFolderEvent(key, col);
            }
        }
    }

    public static class TriggerDispatcher
    extends SAXTrigger
    implements DocumentTrigger,
    CollectionTrigger {
        private static final Logger LOG = LogManager.getLogger(TriggerDispatcher.class);

        public void configure(DBBroker broker, Collection parent, Map<String, List<? extends Object>> parameters) {
        }

        public Logger getLogger() {
            return LOG;
        }

        public void beforeCreateCollection(DBBroker broker, Txn transaction, XmldbURI uri) throws TriggerException {
            EventKey key = new EventKey(uri.toString(), Trigger.BEFORE_CREATE);
            INSTANCE.fire(key, null, null, false);
        }

        public void afterCreateCollection(DBBroker broker, Txn transaction, Collection collection) throws TriggerException {
            EventKey key = new EventKey(collection.getURI().toString(), Trigger.AFTER_CREATE);
            INSTANCE.fire(key, null, collection, false);
        }

        public void beforeCopyCollection(DBBroker broker, Txn transaction, Collection collection, XmldbURI newUri) throws TriggerException {
            EventKey key = new EventKey(newUri.toString(), Trigger.BEFORE_CREATE);
            INSTANCE.fire(key, null, null, false);
        }

        public void afterCopyCollection(DBBroker broker, Txn transaction, Collection collection, XmldbURI newUri) throws TriggerException {
            EventKey key = new EventKey(newUri.toString(), Trigger.AFTER_CREATE);
            INSTANCE.fire(key, null, collection, false);
        }

        public void beforeMoveCollection(DBBroker broker, Txn transaction, Collection collection, XmldbURI newUri) throws TriggerException {
            EventKey key = new EventKey(collection.getURI().toString(), Trigger.BEFORE_MOVE);
            INSTANCE.fire(key, null, collection, false);
        }

        public void afterMoveCollection(DBBroker broker, Txn transaction, Collection collection, XmldbURI newUri) throws TriggerException {
            EventKey key = new EventKey(collection.getURI().toString(), Trigger.AFTER_MOVE);
            INSTANCE.fire(key, null, collection, false);
        }

        public void beforeDeleteCollection(DBBroker broker, Txn transaction, Collection collection) throws TriggerException {
            EventKey key = new EventKey(collection.getURI().toString(), Trigger.BEFORE_REMOVE);
            INSTANCE.fire(key, null, collection, false);
        }

        public void afterDeleteCollection(DBBroker broker, Txn transaction, XmldbURI uri) throws TriggerException {
            EventKey key = new EventKey(uri.toString(), Trigger.AFTER_REMOVE);
            INSTANCE.fire(key, null, null, false);
        }

        public void beforeCreateDocument(DBBroker broker, Txn transaction, XmldbURI uri) throws TriggerException {
            EventKey key = new EventKey(uri.toString(), Trigger.BEFORE_CREATE);
            INSTANCE.fire(key, null, null, true);
        }

        public void afterCreateDocument(DBBroker broker, Txn transaction, DocumentImpl document) {
            EventKey key = new EventKey(document.getURI().toString(), Trigger.AFTER_CREATE);
            INSTANCE.fire(key, document, null, true);
        }

        public void beforeUpdateDocument(DBBroker broker, Txn transaction, DocumentImpl document) throws TriggerException {
            EventKey key = new EventKey(document.getURI().toString(), Trigger.BEFORE_UPDATE);
            INSTANCE.fire(key, document, null, true);
        }

        public void afterUpdateDocument(DBBroker broker, Txn transaction, DocumentImpl document) {
            EventKey key = new EventKey(document.getURI().toString(), Trigger.AFTER_UPDATE);
            INSTANCE.fire(key, document, null, true);
        }

        public void beforeCopyDocument(DBBroker broker, Txn transaction, DocumentImpl document, XmldbURI newUri) throws TriggerException {
            EventKey key = new EventKey(newUri.toString(), Trigger.BEFORE_CREATE);
            INSTANCE.fire(key, document, null, true);
        }

        public void afterCopyDocument(DBBroker broker, Txn transaction, DocumentImpl document, XmldbURI newUri) {
            EventKey key = new EventKey(document.getURI().toString(), Trigger.AFTER_CREATE);
            INSTANCE.fire(key, document, null, true);
        }

        public void beforeMoveDocument(DBBroker broker, Txn transaction, DocumentImpl document, XmldbURI newUri) throws TriggerException {
            EventKey key = new EventKey(document.getURI().toString(), Trigger.BEFORE_RENAME);
            INSTANCE.fire(key, document, null, true);
        }

        public void afterMoveDocument(DBBroker broker, Txn transaction, DocumentImpl document, XmldbURI newUri) {
            EventKey key = new EventKey(document.getURI().toString(), Trigger.AFTER_RENAME);
            INSTANCE.fire(key, document, null, true);
        }

        public void beforeDeleteDocument(DBBroker broker, Txn transaction, DocumentImpl document) throws TriggerException {
            EventKey key = new EventKey(document.getURI().toString(), Trigger.BEFORE_REMOVE);
            INSTANCE.fire(key, document, null, true);
        }

        public void afterDeleteDocument(DBBroker broker, Txn transaction, XmldbURI uri) {
            EventKey key = new EventKey(uri.toString(), Trigger.AFTER_REMOVE);
            INSTANCE.fire(key, null, null, true);
        }

        public void beforeUpdateDocumentMetadata(DBBroker broker, Txn txn, DocumentImpl document) throws TriggerException {
            EventKey key = new EventKey(document.getURI().toString(), Trigger.BEFORE_UPDATE_META);
            INSTANCE.fire(key, document, null, true);
        }

        public void afterUpdateDocumentMetadata(DBBroker broker, Txn txn, DocumentImpl document) throws TriggerException {
            EventKey key = new EventKey(document.getURI().toString(), Trigger.AFTER_UPDATE_META);
            INSTANCE.fire(key, document, null, true);
        }
    }

    static enum Depth {
        ZERO,
        ONE,
        MANY;

    }

    private static class ListenerWrapper {
        final Reference<Listener> refListener;
        final Resource origin;

        ListenerWrapper(Listener listener, Resource origin) {
            this.refListener = new WeakReference<Listener>(listener);
            this.origin = origin;
        }

        private Document wrap(DocumentImpl doc) {
            return doc == null ? null : Document.newInstance(doc, this.origin);
        }

        private Folder wrap(Collection col) {
            if (col == null) {
                return null;
            }
            return new Folder(col.getURI().getCollectionPath(), false, this.origin);
        }

        boolean sameOrNull(Listener listener) {
            Listener x = this.refListener.get();
            return x == null || x == listener;
        }

        boolean isAlive() {
            return this.refListener.get() != null;
        }

        void fireDocumentEvent(EventKey key, DocumentImpl doc) {
            Listener listener = this.refListener.get();
            if (listener instanceof Document.Listener) {
                ((Document.Listener)listener).handle(new Document.Event(key, this.wrap(doc)));
            }
        }

        void fireFolderEvent(EventKey key, Collection col) {
            Listener listener = this.refListener.get();
            if (listener instanceof Folder.Listener) {
                ((Folder.Listener)listener).handle(new Folder.Event(key, this.wrap(col)));
            }
        }
    }

    static class EventKey
    implements Comparable<EventKey> {
        final String path;
        final Trigger trigger;

        EventKey(String path, Trigger trigger) {
            this.path = Database.normalizePath(path);
            this.trigger = trigger;
        }

        EventKey(String path, int existEventCode, boolean before) {
            this(path, EventKey.toTrigger(existEventCode, before));
        }

        private static Trigger toTrigger(int code, boolean before) {
            switch (code) {
                case 0: {
                    return before ? Trigger.BEFORE_STORE : Trigger.AFTER_STORE;
                }
                case 1: {
                    return before ? Trigger.BEFORE_CREATE : Trigger.AFTER_CREATE;
                }
                case 2: {
                    return before ? Trigger.BEFORE_UPDATE : Trigger.AFTER_UPDATE;
                }
                case 4: 
                case 5: {
                    return before ? Trigger.BEFORE_RENAME : Trigger.AFTER_RENAME;
                }
                case 6: 
                case 7: {
                    return before ? Trigger.BEFORE_MOVE : Trigger.AFTER_MOVE;
                }
                case 8: 
                case 9: {
                    return before ? Trigger.BEFORE_REMOVE : Trigger.AFTER_REMOVE;
                }
            }
            throw new IllegalArgumentException("unknown exist trigger code " + code);
        }

        public boolean equals(Object o) {
            if (o instanceof EventKey) {
                EventKey that = (EventKey)o;
                return this.path.equals(that.path) && this.trigger == that.trigger;
            }
            return false;
        }

        public int hashCode() {
            return this.path.hashCode() * 37 + this.trigger.hashCode();
        }

        @Override
        public int compareTo(EventKey that) {
            int r = this.trigger.compareTo(that.trigger);
            if (r == 0) {
                r = that.path.compareTo(this.path);
            }
            return r;
        }

        boolean matchesAsPrefix(EventKey that) {
            return this.trigger == that.trigger && that.path.startsWith(this.path) && (this.path.equals("/") || this.path.length() == that.path.length() || that.path.charAt(this.path.length()) == '/');
        }
    }
}

