/*
 * Decompiled with CFR 0.152.
 */
package org.exist.fluent;

import java.util.Random;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.exist.collections.Collection;
import org.exist.fluent.Database;
import org.exist.fluent.DatabaseException;
import org.exist.fluent.Folder;
import org.exist.security.PermissionDeniedException;
import org.exist.storage.DBBroker;
import org.exist.util.LockException;
import org.exist.xmldb.XmldbURI;

public abstract class Name {
    protected static final Random rand = new Random();
    protected String givenName;
    protected String oldName;
    protected Collection context;
    private final Database db;
    private static final Pattern NAME_PATTERN = Pattern.compile("(.*)($[0-9a-z]+)?(\\..+)?");

    private Name(Database db) {
        this.db = db;
    }

    Folder stripPathPrefix(Folder base) {
        return base;
    }

    void setOldName(String oldName) {
        assert (this.oldName == null);
        this.oldName = oldName;
    }

    void setContext(Collection context) {
        assert (this.context == null);
        this.context = context;
    }

    public String get() {
        if (this.givenName == null) {
            this.eval();
        }
        return this.givenName;
    }

    protected abstract void eval();

    protected abstract String def();

    public String toString() {
        StringBuilder buf = new StringBuilder();
        if (this.givenName != null) {
            buf.append(this.givenName).append(" ");
        }
        buf.append("{");
        buf.append(this.def());
        buf.append("}");
        return buf.toString();
    }

    protected boolean existsInContext(String proposedName) {
        if (proposedName == null || proposedName.length() == 0) {
            throw new IllegalArgumentException("name null or empty");
        }
        XmldbURI proposedUri = XmldbURI.create((String)proposedName);
        DBBroker _broker = null;
        try {
            _broker = this.db.acquireBroker();
            boolean bl = this.context.hasDocument(_broker, proposedUri) || this.context.hasChildCollection(_broker, proposedUri);
            return bl;
        }
        catch (PermissionDeniedException | LockException e) {
            throw new DatabaseException(e.getMessage(), e);
        }
        finally {
            if (_broker != null) {
                this.db.releaseBroker(_broker);
            }
        }
    }

    protected void evalInsert(String proposedName) {
        if (this.existsInContext(proposedName)) {
            throw new DatabaseException("entry with name " + proposedName + " already exists in destination");
        }
        this.givenName = proposedName;
    }

    protected void evalDeconflict(String proposedName) {
        String suffix;
        if (!this.existsInContext(proposedName)) {
            this.givenName = proposedName;
            return;
        }
        Matcher matcher = NAME_PATTERN.matcher(proposedName);
        boolean matchResult = matcher.matches();
        assert (matchResult);
        String baseName = matcher.group(1);
        if (baseName.length() > 0) {
            baseName = baseName + "$";
        }
        if ((suffix = matcher.group(3)) == null) {
            suffix = "";
        }
        this.evalGenerate(baseName, suffix);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void evalGenerate(String baseName, String suffix) {
        Random random = rand;
        synchronized (random) {
            do {
                this.givenName = baseName + Integer.toHexString(rand.nextInt()) + suffix;
            } while (this.existsInContext(this.givenName));
        }
    }

    public static Name generate(Database db) {
        return Name.generate(db, "");
    }

    public static Name generate(Database db, final String suffix) {
        return new Name(db){

            @Override
            protected void eval() {
                this.evalGenerate("", suffix);
            }

            @Override
            public String def() {
                return "generate" + (suffix.length() == 0 ? "" : " " + suffix);
            }
        };
    }

    public static Name keepAdjust(Database db) {
        return new Name(db){

            @Override
            protected void eval() {
                this.evalDeconflict(this.oldName);
            }

            @Override
            protected String def() {
                return "adjust " + (this.oldName == null ? "old name" : this.oldName);
            }
        };
    }

    public static Name adjust(Database db, String name) {
        return new SpecifiedName(db, name){

            @Override
            protected void eval() {
                this.evalDeconflict(this.specifiedName);
            }

            @Override
            protected String def() {
                return "adjust " + this.specifiedName;
            }
        };
    }

    public static Name keepOverwrite(Database db) {
        return new Name(db){

            @Override
            protected void eval() {
                this.givenName = this.oldName;
            }

            @Override
            protected String def() {
                return "overwrite " + (this.oldName == null ? "old name" : this.oldName);
            }
        };
    }

    public static Name overwrite(Database db, String name) {
        return new SpecifiedName(db, name){

            @Override
            protected void eval() {
                this.givenName = this.specifiedName;
            }

            @Override
            protected String def() {
                return "overwrite " + this.specifiedName;
            }
        };
    }

    public static Name keepCreate(Database db) {
        return new Name(db){

            @Override
            protected void eval() {
                this.evalInsert(this.oldName);
            }

            @Override
            protected String def() {
                return "create " + (this.oldName == null ? "old name" : this.oldName);
            }
        };
    }

    public static Name create(Database db, String name) {
        return new SpecifiedName(db, name){

            @Override
            protected void eval() {
                this.evalInsert(this.specifiedName);
            }

            @Override
            protected String def() {
                return "create " + this.specifiedName;
            }
        };
    }

    private static abstract class SpecifiedName
    extends Name {
        protected String specifiedName;

        SpecifiedName(Database db, String specifiedName) {
            super(db);
            this.specifiedName = specifiedName;
        }

        @Override
        Folder stripPathPrefix(Folder base) {
            int k = this.specifiedName.lastIndexOf(47);
            if (k == -1) {
                return base;
            }
            Folder target = base.children().create(this.specifiedName.substring(0, k));
            this.specifiedName = this.specifiedName.substring(k + 1);
            return target;
        }
    }
}

