/*
 * Decompiled with CFR 0.152.
 */
package org.exist.fluent;

import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;

public class NamespaceMap
implements Cloneable {
    private static final NamespaceMap RESERVED = new ReservedMap();
    protected Map<String, String> map;
    protected NamespaceMap parent;

    public static boolean isReservedPrefix(String prefix) {
        return RESERVED.get(prefix) != null;
    }

    public NamespaceMap(String ... args) {
        if (args.length % 2 != 0) {
            throw new IllegalArgumentException("incomplete pair, " + args.length + " arguments received");
        }
        for (int i = 0; i < args.length; i += 2) {
            this.put(args[i], args[i + 1]);
        }
        this.parent = RESERVED;
    }

    public NamespaceMap extend() {
        NamespaceMap extension = new NamespaceMap(new String[0]);
        extension.parent = this;
        return extension;
    }

    public NamespaceMap clone() {
        try {
            NamespaceMap clone = (NamespaceMap)super.clone();
            if (this.map != null) {
                clone.map = new HashMap<String, String>(this.map);
            }
            return clone;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException("unexpected exception", e);
        }
    }

    public void sever() {
        this.map = this.getCombinedMap();
        this.parent = RESERVED;
    }

    public String get(String key) {
        if (key == null) {
            throw new NullPointerException("null key");
        }
        String result = null;
        if (result == null && this.map != null) {
            result = this.map.get(key);
        }
        if (result == null && this.parent != null) {
            result = this.parent.get(key);
        }
        return result;
    }

    private static void checkKey(String key) {
        if (key == null) {
            throw new NullPointerException("null key");
        }
        if (RESERVED.get(key) != null) {
            throw new IllegalArgumentException("reserved key '" + key + "'");
        }
    }

    public void put(String key, String uri) {
        NamespaceMap.checkKey(key);
        if (NamespaceMap.RESERVED.map.containsValue(uri)) {
            throw new IllegalArgumentException("reserved URI '" + uri + "'");
        }
        if (this.map == null) {
            this.map = new TreeMap<String, String>();
        }
        this.map.put(key, uri);
    }

    public void remove(String key) {
        NamespaceMap.checkKey(key);
        if (this.map != null) {
            this.map.remove(key);
        }
    }

    public void clear() {
        if (this.map != null) {
            this.map.clear();
        }
    }

    public void putAll(NamespaceMap that) {
        if (this.map == null) {
            this.map = new TreeMap<String, String>();
        }
        this.map.putAll(that.getCombinedMap());
    }

    public void replaceWith(NamespaceMap that) {
        this.parent = RESERVED;
        this.map = new HashMap<String, String>(that.getCombinedMap());
    }

    public Map<String, String> getCombinedMap() {
        Map<String, String> all = this.parent.getCombinedMap();
        if (this.map != null) {
            all.putAll(this.map);
        }
        return all;
    }

    public boolean isFreshFrom(NamespaceMap freshParent) {
        return (this.map == null || this.map.isEmpty()) && this.parent == freshParent;
    }

    public boolean equals(Object o) {
        if (!(o instanceof NamespaceMap)) {
            return false;
        }
        return this.getCombinedMap().equals(((NamespaceMap)o).getCombinedMap());
    }

    public int hashCode() {
        return this.getCombinedMap().hashCode();
    }

    private static class ReservedMap
    extends NamespaceMap {
        public ReservedMap() {
            super(new String[0]);
            this.map = new TreeMap();
            this.map.put("xml", "http://www.w3.org/XML/1998/namespace");
            this.map.put("xmlns", "http://www.w3.org/2000/xmlns/");
            assert (this.parent == null);
        }

        @Override
        public Map<String, String> getCombinedMap() {
            return new TreeMap<String, String>();
        }
    }
}

