/*
 * Decompiled with CFR 0.152.
 */
package org.exist.fluent;

import java.io.IOException;
import java.util.Arrays;
import java.util.Date;
import java.util.Iterator;
import javax.xml.datatype.Duration;
import javax.xml.datatype.XMLGregorianCalendar;
import org.exist.collections.Collection;
import org.exist.collections.triggers.DocumentTrigger;
import org.exist.collections.triggers.DocumentTriggers;
import org.exist.collections.triggers.TriggerException;
import org.exist.dom.memtree.ElementImpl;
import org.exist.dom.persistent.DocumentImpl;
import org.exist.dom.persistent.NodeHandle;
import org.exist.dom.persistent.NodeImpl;
import org.exist.dom.persistent.NodeProxy;
import org.exist.dom.persistent.StoredNode;
import org.exist.fluent.AttributeBuilder;
import org.exist.fluent.Database;
import org.exist.fluent.DatabaseException;
import org.exist.fluent.Document;
import org.exist.fluent.ElementBuilder;
import org.exist.fluent.Item;
import org.exist.fluent.Name;
import org.exist.fluent.NamespaceMap;
import org.exist.fluent.QName;
import org.exist.fluent.QueryService;
import org.exist.fluent.StaleMarker;
import org.exist.fluent.Transaction;
import org.exist.fluent.XMLDocument;
import org.exist.storage.io.VariableByteOutputStream;
import org.exist.util.sanity.AssertFailure;
import org.exist.xquery.XPathException;
import org.exist.xquery.value.NodeValue;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.Type;
import org.w3c.dom.DOMException;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class Node
extends Item {
    private XMLDocument document;
    final StaleMarker staleMarker = new StaleMarker();
    static final Node NULL = new Node(){

        @Override
        public ElementBuilder<Node> append() {
            throw new UnsupportedOperationException("cannot append to a null resource");
        }

        @Override
        public void delete() {
        }

        @Override
        public XMLDocument document() {
            throw new UnsupportedOperationException("null resource does not have a document");
        }

        @Override
        public String name() {
            throw new UnsupportedOperationException("null resource does not have a name");
        }

        @Override
        public QName qname() {
            throw new UnsupportedOperationException("null resource does not have a qname");
        }

        @Override
        public ElementBuilder<?> replace() {
            throw new UnsupportedOperationException("cannot replace a null resource");
        }

        @Override
        public AttributeBuilder update() {
            throw new UnsupportedOperationException("cannot update a null resource");
        }

        @Override
        public boolean booleanValue() {
            return Item.NULL.booleanValue();
        }

        @Override
        public double doubleValue() {
            return Item.NULL.doubleValue();
        }

        @Override
        public int intValue() {
            return Item.NULL.intValue();
        }

        @Override
        public long longValue() {
            return Item.NULL.longValue();
        }

        @Override
        public Duration durationValue() {
            return Item.NULL.durationValue();
        }

        @Override
        public XMLGregorianCalendar dateTimeValue() {
            return Item.NULL.dateTimeValue();
        }

        @Override
        public Date instantValue() {
            return Item.NULL.instantValue();
        }

        @Override
        public Node node() {
            return Item.NULL.node();
        }

        @Override
        public boolean extant() {
            return Item.NULL.extant();
        }

        @Override
        public QueryService query() {
            return Item.NULL.query();
        }

        @Override
        public String value() {
            return Item.NULL.value();
        }

        @Override
        public String valueWithDefault(String defaultValue) {
            return Item.NULL.value();
        }

        @Override
        Sequence convertToSequence() {
            return Item.NULL.convertToSequence();
        }

        @Override
        public String toString() {
            return "NULL Node";
        }
    };

    private Node() {
    }

    Node(NodeValue item, NamespaceMap namespaceBindings, Database db) {
        super((org.exist.xquery.value.Item)item, namespaceBindings, db);
        if (item instanceof NodeProxy) {
            NodeProxy proxy = (NodeProxy)item;
            String docPath = proxy.getOwnerDocument().getURI().getCollectionPath();
            this.staleMarker.track(docPath.substring(0, docPath.lastIndexOf(47)));
            this.staleMarker.track(docPath);
            this.staleMarker.track(docPath + "#" + proxy.getNodeId());
        }
    }

    @Override
    Sequence convertToSequence() {
        this.staleMarker.check();
        return super.convertToSequence();
    }

    @Override
    public boolean extant() {
        return !this.staleMarker.stale();
    }

    org.w3c.dom.Node getDOMNode() {
        this.staleMarker.check();
        try {
            org.w3c.dom.Node domNode = ((NodeValue)this.item).getNode();
            if (domNode == null) {
                throw new DatabaseException("unable to load node data");
            }
            return domNode;
        }
        catch (AssertFailure e) {
            throw new DatabaseException(e);
        }
    }

    @Override
    public Node node() {
        return this;
    }

    @Override
    public Comparable<Object> comparableValue() {
        throw new DatabaseException("nodes are not comparable");
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof Node)) {
            return false;
        }
        Node that = (Node)o;
        if (this.item == that.item) {
            return true;
        }
        if (this.item instanceof NodeProxy && that.item instanceof NodeProxy) {
            try {
                return ((NodeProxy)this.item).equals((NodeValue)((NodeProxy)that.item));
            }
            catch (XPathException xPathException) {
                // empty catch block
            }
        }
        return false;
    }

    @Override
    public int hashCode() {
        return this.computeHashCode();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private int computeHashCode() {
        if (!(this.item instanceof NodeProxy)) return this.item.hashCode();
        NodeProxy proxy = (NodeProxy)this.item;
        try (VariableByteOutputStream buf = new VariableByteOutputStream();){
            proxy.getNodeId().write(buf);
            int n = proxy.getOwnerDocument().getURI().hashCode() ^ Arrays.hashCode(buf.toByteArray());
            return n;
        }
        catch (IOException e) {
            throw new RuntimeException("unable to serialize node's id to compute hashCode", e);
        }
    }

    public NamespaceMap inScopeNamespaces() {
        NamespaceMap namespaceMap = new NamespaceMap(new String[0]);
        Iterator<String> it = this.query().all("for $prefix in in-scope-prefixes($_1) return ($prefix, namespace-uri-for-prefix($prefix, $_1))", this).values().iterator();
        while (it.hasNext()) {
            String prefix = it.next();
            String namespace = it.next();
            if (NamespaceMap.isReservedPrefix(prefix)) continue;
            namespaceMap.put(prefix, namespace);
        }
        return namespaceMap;
    }

    public int compareDocumentOrderTo(Node node) {
        if (this.item == node.item) {
            return 0;
        }
        NodeValue nv1 = (NodeValue)this.item;
        NodeValue nv2 = (NodeValue)node.item;
        if (nv1.getImplementationType() != nv2.getImplementationType()) {
            throw new DatabaseException("can't compare different node types, since they can never be in the same document");
        }
        if (nv1.getImplementationType() == 1) {
            NodeProxy n1 = (NodeProxy)this.item;
            NodeProxy n2 = (NodeProxy)node.item;
            if (n1.getOwnerDocument().getDocId() != n2.getOwnerDocument().getDocId()) {
                throw new DatabaseException("can't compare document order of nodes in disparate documents:  this node is in " + this.document() + " and the argument node in " + node.document());
            }
            if (n1.getNodeId().equals(n2.getNodeId())) {
                return 0;
            }
            try {
                return n1.before((NodeValue)n2, false) ? -1 : 1;
            }
            catch (XPathException e) {
                throw new DatabaseException("unable to compare nodes", e);
            }
        }
        if (nv1.getImplementationType() == 0) {
            org.exist.dom.memtree.DocumentImpl n2Doc;
            org.exist.dom.memtree.NodeImpl n1 = (org.exist.dom.memtree.NodeImpl)nv1;
            org.exist.dom.memtree.NodeImpl n2 = (org.exist.dom.memtree.NodeImpl)nv2;
            org.exist.dom.memtree.DocumentImpl n1Doc = n1.getNodeType() == 9 ? (org.exist.dom.memtree.DocumentImpl)n1 : n1.getOwnerDocument();
            org.exist.dom.memtree.DocumentImpl documentImpl = n2Doc = n2.getNodeType() == 9 ? (org.exist.dom.memtree.DocumentImpl)n2 : n2.getOwnerDocument();
            if (n1Doc != n2Doc) {
                throw new DatabaseException("can't compare document order of in-memory nodes created separately");
            }
            try {
                return n1.before((NodeValue)n2, false) ? -1 : 1;
            }
            catch (XPathException e) {
                throw new DatabaseException("unable to compare nodes", e);
            }
        }
        throw new DatabaseException("unknown node implementation type: " + nv1.getImplementationType());
    }

    public XMLDocument document() {
        this.staleMarker.check();
        if (this.document == null) {
            try {
                this.document = Document.newInstance(((NodeProxy)this.item).getOwnerDocument(), this).xml();
            }
            catch (ClassCastException e) {
                throw new UnsupportedOperationException("node is not part of a document in the database");
            }
        }
        return this.document;
    }

    public ElementBuilder<Node> append() {
        this.staleMarker.check();
        try {
            final StoredNode node = (StoredNode)this.getDOMNode();
            return new ElementBuilder<Node>(this.namespaceBindings, true, new ElementBuilder.CompletedCallback<Node>(){

                @Override
                public Node completed(org.w3c.dom.Node[] nodes) {
                    Transaction tx = Node.this.db.requireTransactionWithBroker();
                    try {
                        DocumentImpl ownerDoc = node.getOwnerDocument();
                        tx.lockWrite(ownerDoc);
                        DocumentTrigger trigger = Node.this.fireTriggerBefore(tx);
                        node.appendChildren(tx.tx, Node.toNodeList(nodes), 0);
                        NodeHandle result = (NodeHandle)node.getLastChild();
                        Node.this.touchDefragAndFireTriggerAfter(tx, trigger);
                        tx.commit();
                        if (result == null) {
                            Node node2 = null;
                            return node2;
                        }
                        NodeProxy proxy = new NodeProxy(result);
                        Node node3 = new Node((NodeValue)proxy, Node.this.namespaceBindings.extend(), Node.this.db);
                        return node3;
                    }
                    catch (DOMException e) {
                        throw new DatabaseException(e);
                    }
                    catch (TriggerException e) {
                        throw new DatabaseException("append aborted by listener", e);
                    }
                    finally {
                        tx.abortIfIncomplete();
                    }
                }
            });
        }
        catch (ClassCastException e) {
            if (this.getDOMNode() instanceof org.exist.dom.memtree.NodeImpl) {
                throw new UnsupportedOperationException("appends to in-memory nodes are not supported");
            }
            throw new UnsupportedOperationException("cannot append to a " + Type.getTypeName((int)this.item.getType()));
        }
    }

    public void delete() {
        org.w3c.dom.Node child;
        try {
            child = this.getDOMNode();
        }
        catch (DatabaseException e) {
            return;
        }
        NodeImpl parent = (NodeImpl)child.getParentNode();
        if (child instanceof org.w3c.dom.Document || parent instanceof org.w3c.dom.Document) {
            this.document().delete();
        } else {
            if (parent == null) {
                throw new DatabaseException("cannot delete node with no parent");
            }
            Transaction tx = this.db.requireTransactionWithBroker();
            try {
                if (parent instanceof NodeHandle) {
                    tx.lockWrite((DocumentImpl)((NodeHandle)parent).getOwnerDocument());
                }
                DocumentTrigger trigger = this.fireTriggerBefore(tx);
                parent.removeChild(tx.tx, child);
                this.touchDefragAndFireTriggerAfter(tx, trigger);
                tx.commit();
            }
            catch (DOMException e) {
                throw new DatabaseException(e);
            }
            catch (TriggerException e) {
                throw new DatabaseException("delete aborted by listener", e);
            }
            finally {
                tx.abortIfIncomplete();
            }
        }
    }

    public String name() {
        return this.getDOMNode().getNodeName();
    }

    public QName qname() {
        org.w3c.dom.Node node = this.getDOMNode();
        String localName = node.getLocalName();
        if (localName == null) {
            localName = node.getNodeName();
        }
        return new QName(node.getNamespaceURI(), localName, node.getPrefix());
    }

    public ElementBuilder<?> replace() {
        try {
            final NodeImpl oldNode = (NodeImpl)this.getDOMNode();
            if (oldNode.getParentNode() == null) {
                throw new UnsupportedOperationException("cannot replace a " + Type.getTypeName((int)this.item.getType()) + " with no parent");
            }
            if (oldNode.getParentNode().getNodeType() == 9) {
                return this.document().folder().documents().build(Name.overwrite(this.db, this.document().name()));
            }
            return new ElementBuilder<Object>(this.namespaceBindings, false, new ElementBuilder.CompletedCallback<Object>(){

                @Override
                public Object completed(org.w3c.dom.Node[] nodes) {
                    assert (nodes.length == 1);
                    Transaction tx = Node.this.db.requireTransactionWithBroker();
                    try {
                        DocumentImpl doc = (DocumentImpl)oldNode.getOwnerDocument();
                        tx.lockWrite(doc);
                        DocumentTrigger trigger = Node.this.fireTriggerBefore(tx);
                        ((NodeImpl)oldNode.getParentNode()).replaceChild(tx.tx, nodes[0], (org.w3c.dom.Node)oldNode);
                        Node.this.touchDefragAndFireTriggerAfter(tx, trigger);
                        tx.commit();
                        Object var5_7 = null;
                        return var5_7;
                    }
                    catch (DOMException e) {
                        throw new DatabaseException(e);
                    }
                    catch (TriggerException e) {
                        throw new DatabaseException("append aborted by listener", e);
                    }
                    finally {
                        tx.abortIfIncomplete();
                    }
                }
            });
        }
        catch (ClassCastException e) {
            if (this.getDOMNode() instanceof org.exist.dom.memtree.NodeImpl) {
                throw new UnsupportedOperationException("replacement of in-memory nodes is not supported");
            }
            throw new UnsupportedOperationException("cannot replace a " + Type.getTypeName((int)this.item.getType()));
        }
    }

    public AttributeBuilder update() {
        try {
            final org.exist.dom.persistent.ElementImpl elem = (org.exist.dom.persistent.ElementImpl)this.getDOMNode();
            return new AttributeBuilder((Element)elem, this.namespaceBindings, new AttributeBuilder.CompletedCallback(){

                @Override
                public void completed(NodeList removeList, NodeList addList) {
                    Transaction tx = Node.this.db.requireTransactionWithBroker();
                    try {
                        DocumentImpl doc = elem.getOwnerDocument();
                        tx.lockWrite(doc);
                        DocumentTrigger trigger = Node.this.fireTriggerBefore(tx);
                        elem.removeAppendAttributes(tx.tx, removeList, addList);
                        Node.this.touchDefragAndFireTriggerAfter(tx, trigger);
                        tx.commit();
                    }
                    catch (TriggerException e) {
                        throw new DatabaseException("append aborted by listener", e);
                    }
                    finally {
                        tx.abortIfIncomplete();
                    }
                }
            });
        }
        catch (ClassCastException e) {
            if (this.getDOMNode() instanceof ElementImpl) {
                throw new UnsupportedOperationException("updates on in-memory nodes are not supported");
            }
            throw new UnsupportedOperationException("cannot update attributes on a " + Type.getTypeName((int)this.item.getType()));
        }
    }

    private DocumentTrigger fireTriggerBefore(Transaction tx) throws TriggerException {
        if (!(this.item instanceof NodeProxy)) {
            return null;
        }
        DocumentImpl docimpl = ((NodeProxy)this.item).getOwnerDocument();
        Collection col = docimpl.getCollection();
        DocumentTriggers trigger = new DocumentTriggers(tx.broker, null, col, col.getConfiguration(tx.broker));
        trigger.beforeUpdateDocument(tx.broker, tx.tx, docimpl);
        return trigger;
    }

    private void touchDefragAndFireTriggerAfter(Transaction tx, DocumentTrigger trigger) throws TriggerException {
        DocumentImpl doc = ((NodeProxy)this.item).getOwnerDocument();
        doc.getMetadata().setLastModified(System.currentTimeMillis());
        tx.broker.storeXMLResource(tx.tx, doc);
        if (this.item instanceof NodeProxy) {
            Database.queueDefrag(((NodeProxy)this.item).getOwnerDocument());
        }
        if (trigger == null) {
            return;
        }
        DocumentImpl docimpl = ((NodeProxy)this.item).getOwnerDocument();
        trigger.afterUpdateDocument(tx.broker, tx.tx, docimpl);
    }

    static NodeList toNodeList(final org.w3c.dom.Node[] nodes) {
        return new NodeList(){

            @Override
            public int getLength() {
                return nodes.length;
            }

            @Override
            public org.w3c.dom.Node item(int index) {
                return nodes[index];
            }
        };
    }
}

