/*
 * Decompiled with CFR 0.152.
 */
package org.exist.fluent;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.CharArrayReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PushbackInputStream;
import java.io.PushbackReader;
import java.io.Reader;
import java.io.StringReader;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.util.LinkedList;
import org.exist.fluent.Name;
import org.xml.sax.InputSource;

public abstract class Source {
    private final String oldName;
    protected String encoding;
    private static final int CHUNK_SIZE = 16384;

    private Source(String oldName) {
        this.oldName = oldName;
    }

    public Source encoding(String characterEncoding) {
        if (this.encoding != null) {
            throw new IllegalStateException("encoding already set");
        }
        this.encoding = characterEncoding;
        return this;
    }

    final void applyOldName(Name name) {
        name.setOldName(this.oldName);
    }

    public static XML xml(final File file) {
        final String uri = file.toURI().toASCIIString();
        return new XML(file.getName()){

            @Override
            InputSource createInputSource() throws IOException {
                InputSource src = new InputSource(uri);
                if (this.encoding != null) {
                    src.setEncoding(this.encoding);
                }
                return src;
            }

            @Override
            public String toString() {
                return super.toString() + "file '" + file.getPath() + "'";
            }
        };
    }

    public static Blob blob(final File file) {
        return new Blob(file.getName()){

            @Override
            protected InputStream toInputStream() throws IOException {
                long fileLength = file.length();
                if (fileLength > Integer.MAX_VALUE) {
                    throw new IOException("file too large");
                }
                this.length = (int)fileLength;
                return new BufferedInputStream(new FileInputStream(file));
            }

            @Override
            public String toString() {
                return super.toString() + "file '" + file.getPath() + "'";
            }
        };
    }

    public static XML xml(final InputStream stream) {
        return new XML(){
            private InputStream markedStream;

            @Override
            InputSource createInputSource() throws IOException {
                if (this.markedStream == null) {
                    this.markedStream = stream.markSupported() ? stream : new ByteArrayInputStream(Source.readInputStream(stream, null));
                    this.markedStream.mark(Integer.MAX_VALUE);
                }
                this.markedStream.reset();
                return new InputSource(this.markedStream);
            }

            @Override
            public String toString() {
                return super.toString() + "input stream" + (this.markedStream == stream ? "" : " (cached)");
            }
        };
    }

    public static Blob blob(final InputStream stream) {
        return new Blob(){

            @Override
            protected void createBytes() throws IOException {
                this.contents = Source.readInputStream(stream, null);
                this.length = this.contents.length;
            }

            @Override
            public String toString() {
                return super.toString() + "input stream";
            }
        };
    }

    public static XML xml(final Reader reader) {
        return new XML(){
            private char[] contents;

            @Override
            InputSource createInputSource() throws IOException {
                if (this.contents == null) {
                    this.contents = Source.readReader(reader, null);
                }
                return new InputSource(new CharArrayReader(this.contents));
            }

            @Override
            public String toString() {
                return super.toString() + "reader";
            }
        };
    }

    public static Blob blob(final Reader reader) {
        return new Blob(){

            @Override
            protected void createBytes() throws IOException {
                this.encode(CharBuffer.wrap(Source.readReader(reader, null)));
            }

            @Override
            public String toString() {
                return super.toString() + "reader";
            }
        };
    }

    public static XML xml(final byte[] bytes) {
        return new XML(){

            @Override
            InputSource createInputSource() throws IOException {
                return new InputSource(new ByteArrayInputStream(bytes));
            }

            @Override
            public String toString() {
                return super.toString() + "byte array [" + bytes.length + "]";
            }
        };
    }

    public static Blob blob(final byte[] bytes) {
        return new Blob(){
            {
                this.contents = bytes;
                this.length = bytes.length;
            }

            @Override
            public String toString() {
                return super.toString() + "byte array [" + bytes.length + "]";
            }
        };
    }

    public static XML xml(final String literal) {
        return new XML(){

            @Override
            InputSource createInputSource() throws IOException {
                return new InputSource(new StringReader(literal));
            }

            @Override
            public String toString() {
                return super.toString() + "literal string:\n" + literal;
            }
        };
    }

    public static Blob blob(final String literal) {
        return new Blob(){

            @Override
            protected void createBytes() throws IOException {
                this.encode(CharBuffer.wrap(literal));
            }

            @Override
            public String toString() {
                return super.toString() + "literal string";
            }
        };
    }

    public static XML xml(URL url) throws URISyntaxException {
        final String uri = url.toURI().toASCIIString();
        return new XML(Source.urlToFilename(url)){

            @Override
            InputSource createInputSource() throws IOException {
                return new InputSource(uri);
            }

            @Override
            public String toString() {
                return super.toString() + "at URL '" + uri + "'";
            }
        };
    }

    public static Blob blob(final URL url) {
        return new Blob(Source.urlToFilename(url)){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected InputStream toInputStream() throws IOException {
                URLConnection connection = url.openConnection();
                connection.setAllowUserInteraction(false);
                connection.connect();
                if (connection.getContentLength() == -1) {
                    try {
                        byte[] bytes = null;
                        bytes = Source.readInputStream(connection.getInputStream(), bytes);
                        this.length = bytes.length;
                        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(bytes);
                        return byteArrayInputStream;
                    }
                    finally {
                        connection.getInputStream().close();
                    }
                }
                this.length = connection.getContentLength();
                return connection.getInputStream();
            }

            @Override
            public String toString() {
                return super.toString() + "at URL '" + url + "'";
            }
        };
    }

    private static String urlToFilename(URL url) {
        String path = url.getPath();
        if (path == null || path.length() == 0) {
            return null;
        }
        int k = path.lastIndexOf(47);
        if (k >= 0) {
            path = path.substring(k + 1, path.length());
        }
        return path;
    }

    private static byte[] readInputStream(InputStream stream, byte[] chunk) throws IOException {
        int n;
        PushbackInputStream in = new PushbackInputStream(stream);
        if (chunk == null) {
            chunk = new byte[16384];
        }
        int totalSize = 0;
        LinkedList<byte[]> chunks = new LinkedList<byte[]>();
        chunks.add(chunk);
        int k = 0;
        while ((n = in.read(chunk, k, chunk.length - k)) != -1) {
            totalSize += n;
            if ((k += n) != chunk.length) continue;
            int b = in.read();
            if (b == -1) break;
            in.unread(b);
            chunk = new byte[16384];
            chunks.add(chunk);
            k = 0;
        }
        if (chunks.size() == 1 && ((byte[])chunks.get(0)).length == totalSize) {
            return (byte[])chunks.get(0);
        }
        chunk = new byte[totalSize];
        k = 0;
        for (byte[] a : chunks) {
            System.arraycopy(a, 0, chunk, k, Math.min(totalSize - k, a.length));
            k += a.length;
        }
        return chunk;
    }

    private static char[] readReader(Reader reader, char[] chunk) throws IOException {
        int n;
        PushbackReader in = new PushbackReader(reader);
        if (chunk == null) {
            chunk = new char[16384];
        }
        int totalSize = 0;
        LinkedList<char[]> chunks = new LinkedList<char[]>();
        chunks.add(chunk);
        int k = 0;
        while ((n = in.read(chunk, k, chunk.length - k)) != -1) {
            totalSize += n;
            if ((k += n) != chunk.length) continue;
            int b = in.read();
            if (b == -1) break;
            in.unread(b);
            chunk = new char[16384];
            chunks.add(chunk);
            k = 0;
        }
        if (chunks.size() == 1 && ((char[])chunks.get(0)).length == totalSize) {
            return (char[])chunks.get(0);
        }
        chunk = new char[totalSize];
        k = 0;
        for (char[] a : chunks) {
            System.arraycopy(a, 0, chunk, k, Math.min(totalSize - k, a.length));
            k += a.length;
        }
        return chunk;
    }

    public static abstract class Blob
    extends Source {
        protected byte[] contents;
        protected int offset;
        protected int length;

        private Blob() {
            super(null);
        }

        private Blob(String oldName) {
            super(oldName);
        }

        protected InputStream toInputStream() throws IOException {
            if (this.contents == null) {
                this.createBytes();
            }
            assert (this.contents != null);
            return new ByteArrayInputStream(this.contents, this.offset, this.length);
        }

        protected int getLength() {
            return this.length;
        }

        protected void createBytes() throws IOException {
        }

        public String toString() {
            return "blob ";
        }

        protected void encode(CharBuffer buf) throws CharacterCodingException {
            Charset charset = Charset.forName(this.encoding == null ? "UTF-8" : this.encoding);
            ByteBuffer bb = charset.newEncoder().encode(buf);
            this.contents = bb.array();
            this.offset = bb.arrayOffset();
            this.length = bb.limit();
        }
    }

    public static abstract class XML
    extends Source {
        private XML() {
            super(null);
        }

        private XML(String oldName) {
            super(oldName);
        }

        final InputSource toInputSource() throws IOException {
            InputSource source = this.createInputSource();
            if (this.encoding != null) {
                source.setEncoding(this.encoding);
            }
            return source;
        }

        abstract InputSource createInputSource() throws IOException;

        public String toString() {
            return "xml ";
        }
    }
}

