/*
 * Decompiled with CFR 0.152.
 */
package org.exist.fluent;

import java.lang.ref.WeakReference;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.NoSuchElementException;
import org.exist.fluent.Database;

class WeakMultiValueHashMap<K, V> {
    private static final int SWEEP_COUNT = 100;
    private final Map<K, Collection<WeakReference<V>>> map = new HashMap<K, Collection<WeakReference<V>>>();
    private int putCounter;
    private static final Sweeper SWEEPER = new Sweeper();

    WeakMultiValueHashMap() {
    }

    public synchronized void put(K key, V value) {
        Collection<WeakReference<V>> list = this.map.get(key);
        if (list == null) {
            list = new LinkedList<WeakReference<V>>();
            this.map.put(key, list);
        }
        list.add(new WeakReference<V>(value));
        this.putCounter = (this.putCounter + 1) % 100;
        if (this.putCounter == 0) {
            SWEEPER.clean(this);
        }
    }

    public synchronized void remove(K key) {
        this.map.remove(key);
    }

    public synchronized boolean containsKey(K key) {
        Collection<WeakReference<V>> list = this.map.get(key);
        if (list == null) {
            return false;
        }
        Iterator<WeakReference<V>> it = list.iterator();
        while (it.hasNext()) {
            if (it.next().get() != null) {
                return true;
            }
            it.remove();
        }
        this.map.remove(key);
        return false;
    }

    public synchronized Iterable<V> get(final K key) {
        final Collection<WeakReference<V>> list = this.map.get(key);
        if (list == null) {
            return Database.EMPTY_ITERABLE;
        }
        return new Iterable<V>(){

            @Override
            public Iterator<V> iterator() {
                return new Iterator<V>(){
                    private final Iterator<WeakReference<V>> it;
                    private V nextItem;
                    {
                        this.it = list.iterator();
                        this.advance();
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    private void advance() {
                        WeakMultiValueHashMap weakMultiValueHashMap = WeakMultiValueHashMap.this;
                        synchronized (weakMultiValueHashMap) {
                            while (this.nextItem == null && this.it.hasNext()) {
                                this.nextItem = this.it.next().get();
                                if (this.nextItem != null) continue;
                                this.it.remove();
                            }
                            if (!this.it.hasNext() && list.isEmpty()) {
                                WeakMultiValueHashMap.this.map.remove(key);
                            }
                        }
                    }

                    @Override
                    public boolean hasNext() {
                        this.advance();
                        return this.nextItem != null;
                    }

                    @Override
                    public V next() {
                        this.advance();
                        if (this.nextItem == null) {
                            throw new NoSuchElementException();
                        }
                        Object item = this.nextItem;
                        this.nextItem = null;
                        return item;
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        };
    }

    static {
        Thread thread = new Thread((Runnable)SWEEPER, "WeakMultiValueHashMap sweeper");
        thread.setPriority(2);
        thread.setDaemon(true);
        thread.start();
    }

    private static class Sweeper
    implements Runnable {
        private final LinkedList<WeakMultiValueHashMap<?, ?>> inbox = new LinkedList();

        private Sweeper() {
        }

        public synchronized void clean(WeakMultiValueHashMap<?, ?> map) {
            this.inbox.add(map);
            this.notifyAll();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (true) {
                try {
                    Iterator<Object> it;
                    Object object;
                    WeakMultiValueHashMap<?, ?> map;
                    do {
                        object = this;
                        synchronized (object) {
                            while (this.inbox.isEmpty()) {
                                this.wait();
                            }
                            map = this.inbox.removeFirst();
                            it = this.inbox.iterator();
                            while (it.hasNext()) {
                                if (it.next() != map) continue;
                                it.remove();
                            }
                        }
                    } while (map == null);
                    object = map;
                    synchronized (object) {
                        it = ((WeakMultiValueHashMap)map).map.values().iterator();
                        while (it.hasNext()) {
                            Collection list = (Collection)it.next();
                            Iterator it2 = list.iterator();
                            while (it2.hasNext()) {
                                if (((WeakReference)it2.next()).get() != null) continue;
                                it2.remove();
                            }
                            if (!list.isEmpty()) continue;
                            it.remove();
                        }
                    }
                }
                catch (InterruptedException interruptedException) {
                    return;
                }
            }
        }
    }
}

