/*
 * Decompiled with CFR 0.152.
 */
package org.exist.fluent;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.io.Writer;
import org.exist.dom.persistent.BinaryDocument;
import org.exist.dom.persistent.DocumentImpl;
import org.exist.dom.persistent.NodeProxy;
import org.exist.fluent.Database;
import org.exist.fluent.DatabaseException;
import org.exist.fluent.Document;
import org.exist.fluent.Folder;
import org.exist.fluent.Name;
import org.exist.fluent.NamespaceMap;
import org.exist.fluent.Node;
import org.exist.fluent.QueryService;
import org.exist.storage.DBBroker;
import org.exist.xquery.value.Sequence;
import org.xml.sax.SAXException;

public class XMLDocument
extends Document {
    private final NodeProxy proxy;

    XMLDocument(DocumentImpl dimpl, NamespaceMap namespaceBindings, Database db) {
        super(dimpl, namespaceBindings, db);
        if (dimpl instanceof BinaryDocument) {
            throw new IllegalArgumentException("binary document impl passed to XML document constructor");
        }
        this.proxy = new NodeProxy(dimpl);
    }

    @Override
    Sequence convertToSequence() {
        this.staleMarker.check();
        return this.proxy;
    }

    @Override
    public XMLDocument xml() {
        return this;
    }

    public Node root() {
        this.staleMarker.check();
        return this.query().single("*", new Object[0]).node();
    }

    @Override
    public QueryService query() {
        this.staleMarker.check();
        return super.query();
    }

    @Override
    QueryService createQueryService() {
        return null;
    }

    @Override
    public String toString() {
        return "XML " + super.toString();
    }

    @Override
    public XMLDocument copy(Folder destination, Name name) {
        return (XMLDocument)super.copy(destination, name);
    }

    @Override
    public String contentsAsString() {
        StringWriter writer = new StringWriter();
        this.write(writer);
        return writer.toString();
    }

    @Override
    public void write(OutputStream stream) throws IOException {
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter(stream, this.db.defaultCharacterEncoding);
        this.write(outputStreamWriter);
        outputStreamWriter.flush();
    }

    public void write(Writer writer) {
        this.staleMarker.check();
        DBBroker broker = null;
        try {
            broker = this.db.acquireBroker();
            broker.getSerializer().serialize(this.doc, writer);
        }
        catch (SAXException e) {
            throw new DatabaseException(e);
        }
        finally {
            this.db.releaseBroker(broker);
        }
    }
}

