/*
 * Decompiled with CFR 0.152.
 */
package de.betterform.agent.web;

import de.betterform.agent.web.WebFactory;
import de.betterform.agent.web.WebProcessor;
import de.betterform.agent.web.cache.XFSessionCache;
import de.betterform.agent.web.flux.FluxProcessor;
import de.betterform.xml.config.XFormsConfigException;
import de.betterform.xml.xforms.XFormsProcessor;
import de.betterform.xml.xforms.exception.XFormsException;
import de.betterform.xml.xforms.model.submission.RequestHeaders;
import de.betterform.xml.xslt.TransformerService;
import de.betterform.xml.xslt.impl.CachingTransformerService;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.net.URLDecoder;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.servlet.ServletContext;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.impl.cookie.BasicClientCookie;
import org.infinispan.Cache;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class WebUtil {
    private static final Log LOGGER = LogFactory.getLog(WebUtil.class);
    public static final String HTML_CONTENT_TYPE = "text/html;charset=UTF-8";
    public static final String HTTP_SESSION_ID = "httpSessionId";
    public static final String EXISTDB_USER = "_eXist_xmldb_user";
    private static final String FILENAME = "fileName";
    private static final String PLAIN_PATH = "plainPath";
    private static final String CONTEXT_PATH = "contextPath";

    public static String getRequestURI(HttpServletRequest request) {
        StringBuffer buffer = new StringBuffer(request.getScheme());
        buffer.append("://");
        buffer.append(request.getServerName());
        buffer.append(":");
        buffer.append(request.getServerPort());
        buffer.append(request.getContextPath());
        return buffer.toString();
    }

    public static void printSessionKeys(HttpSession session) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"--------------- http session dump ---------------");
            Enumeration keys = session.getAttributeNames();
            if (keys.hasMoreElements()) {
                while (keys.hasMoreElements()) {
                    String s = (String)keys.nextElement();
                    LOGGER.debug((Object)("sessionkey: " + s + ":" + session.getAttribute(s)));
                }
            } else {
                LOGGER.debug((Object)"--- no keys present in session ---");
            }
        }
    }

    public static void nonCachingResponse(HttpServletResponse response) {
        response.setHeader("Cache-Control", "private, no-store,  no-cache, must-revalidate");
        response.setHeader("Pragma", "no-cache");
        response.setHeader("Expires", "-1");
    }

    public static String getContextRoot(HttpServletRequest request) {
        if (request.getAttribute("ResourcePath") != null) {
            return (String)request.getAttribute("ResourcePath");
        }
        return request.getContextPath();
    }

    public static WebProcessor getWebProcessor(HttpServletRequest request, HttpServletResponse response, HttpSession session) {
        String key = request.getParameter("sessionKey");
        if (key == null) {
            LOGGER.warn((Object)("Request " + request + " has no parameter session key"));
            return null;
        }
        return WebUtil.getWebProcessor(key, request, response, session);
    }

    public static WebProcessor getWebProcessor(String key, HttpServletRequest request, HttpServletResponse response, HttpSession session) {
        Cache<String, FluxProcessor> sessionCache;
        if (key == null || key.equals("")) {
            LOGGER.warn((Object)"SessionKey is null");
            return null;
        }
        try {
            sessionCache = XFSessionCache.getCache();
        }
        catch (XFormsException xfe) {
            sessionCache = null;
        }
        if (sessionCache == null || !sessionCache.containsKey((Object)key)) {
            LOGGER.warn((Object)("No xformsSession for key " + key + " in Cache"));
            return null;
        }
        WebProcessor processor = (WebProcessor)sessionCache.get((Object)key);
        if (processor.getContext() != null) {
            return processor;
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("Element is read from disk " + processor.toString()));
        }
        processor.setRequest(request);
        processor.setResponse(response);
        processor.setHttpSession(session);
        processor.setKey(key);
        processor.getHttpRequestHandler();
        processor.setContext(session.getServletContext());
        try {
            processor.configure();
            processor.createUIGenerator();
            processor.init();
            return processor;
        }
        catch (Exception e) {
            LOGGER.error((Object)"Could not reload xformSession from disk.", (Throwable)e);
            return null;
        }
    }

    public static boolean removeSession(String key) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("removing key: '" + key + "' from cache"));
        }
        boolean removedSession = false;
        try {
            Cache<String, FluxProcessor> sessionCache = XFSessionCache.getCache();
            if (sessionCache != null) {
                removedSession = sessionCache.remove((Object)key) != null;
            }
        }
        catch (XFormsException sessionCache) {
            // empty catch block
        }
        if (LOGGER.isDebugEnabled()) {
            String result = removedSession ? "successful" : "unsuccessful";
            LOGGER.debug((Object)("Removal of session '" + key + "' was " + result));
        }
        return removedSession;
    }

    public static String decodeUrl(String formPath, HttpServletRequest request) throws UnsupportedEncodingException {
        String decoded = URLDecoder.decode(formPath, "UTF-8");
        if (decoded.startsWith("http://")) {
            return decoded;
        }
        String requestURI = WebUtil.getRequestURI(request);
        return requestURI + formPath;
    }

    public static void storeCookies(List<Cookie> requestCookies, XFormsProcessor processor) {
        Vector<BasicClientCookie> commonsCookies = new Vector<BasicClientCookie>();
        if (requestCookies != null && requestCookies.size() > 0) {
            commonsCookies = WebUtil.saveAsBasicClientCookie(requestCookies.iterator(), commonsCookies);
        }
        if (commonsCookies.size() == 0) {
            BasicClientCookie sessionCookie = new BasicClientCookie("JSESSIONID", ((WebProcessor)processor).httpSession.getId());
            sessionCookie.setSecure(false);
            sessionCookie.setDomain(null);
            sessionCookie.setPath(null);
            commonsCookies.add(sessionCookie);
        }
        processor.setContextParam("request-cookie", commonsCookies.toArray(new BasicClientCookie[0]));
    }

    private static Vector<BasicClientCookie> saveAsBasicClientCookie(Iterator iterator, Vector<BasicClientCookie> commonsCookies) {
        while (iterator.hasNext()) {
            Cookie c = (Cookie)iterator.next();
            BasicClientCookie commonsCookie = new BasicClientCookie(c.getName(), c.getValue());
            commonsCookie.setDomain(c.getDomain());
            commonsCookie.setPath(c.getPath());
            commonsCookie.setAttribute("max-age", Integer.toString(c.getMaxAge()));
            commonsCookie.setSecure(c.getSecure());
            commonsCookies.add(commonsCookie);
            if (!LOGGER.isDebugEnabled()) continue;
            LOGGER.debug((Object)"adding cookie >>>>>");
            LOGGER.debug((Object)("name: " + c.getName()));
            LOGGER.debug((Object)("value: " + c.getValue()));
            LOGGER.debug((Object)("path: " + c.getPath()));
            LOGGER.debug((Object)("maxAge: " + c.getMaxAge()));
            LOGGER.debug((Object)("secure: " + c.getSecure()));
            LOGGER.debug((Object)"adding cookie done <<<<<");
        }
        return commonsCookies;
    }

    public static void copyHttpHeaders(HttpServletRequest request, XFormsProcessor processor) {
        RequestHeaders httpHeaders = new RequestHeaders();
        Enumeration headerNames = request.getHeaderNames();
        while (headerNames.hasMoreElements()) {
            String headerName = (String)headerNames.nextElement();
            httpHeaders.addHeader(headerName, request.getHeader(headerName));
            if (!LOGGER.isDebugEnabled()) continue;
            LOGGER.debug((Object)("keeping httpheader: " + headerName + " value: " + request.getHeader(headerName)));
        }
        processor.setContextParam("http-headers", httpHeaders);
    }

    public static String getFormUrlAsString(HttpServletRequest request) throws UnsupportedEncodingException, MalformedURLException {
        String formPath = request.getParameter("form");
        return WebUtil.decodeUrl(formPath, request);
    }

    public static void setContextParams(HttpServletRequest request, HttpSession httpSession, XFormsProcessor processor, String sessionkey) throws XFormsConfigException {
        String s1;
        HashMap<String, String> servletMap = new HashMap<String, String>();
        servletMap.put("betterform.session.id", sessionkey);
        processor.setContextParam("betterform.submission.response", servletMap);
        processor.setContextParam("requestURI", WebUtil.getRequestURI(request));
        String requestURL = request.getRequestURL().toString();
        processor.setContextParam("requestURL", requestURL);
        String contextRoot = WebUtil.getContextRoot(request);
        processor.setContextParam("contextroot", contextRoot);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("context root of webapp: " + processor.getContextParam("contextroot")));
        }
        String requestPath = "";
        URL url = null;
        String plainPath = "";
        try {
            url = new URL(requestURL);
            requestPath = url.getPath();
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        if (requestPath.length() != 0) {
            processor.setContextParam("requestpath", requestPath);
            String fileName = requestPath.substring(requestPath.lastIndexOf(47) + 1, requestPath.length());
            processor.setContextParam(FILENAME, fileName);
            if (requestURL.contains(contextRoot)) {
                plainPath = requestPath.substring(contextRoot.length() + 1, requestPath.length() - fileName.length());
                processor.setContextParam(PLAIN_PATH, plainPath);
            } else {
                String[] urlParts = requestURL.split("/");
                plainPath = urlParts[urlParts.length - 2];
            }
            processor.setContextParam(CONTEXT_PATH, contextRoot + "/" + plainPath);
        }
        processor.setContextParam(HTTP_SESSION_ID, httpSession.getId());
        if (request.isRequestedSessionIdValid()) {
            processor.setContextParam(EXISTDB_USER, httpSession.getAttribute(EXISTDB_USER));
        }
        if ((s1 = request.getPathInfo()) != null) {
            processor.setContextParam("pathInfo", s1);
        }
        processor.setContextParam("queryString", request.getQueryString() != null ? request.getQueryString() : "");
        String realPath = WebFactory.getRealPath(".", httpSession.getServletContext());
        File f = new File(realPath);
        URI fileURI = f.toURI();
        processor.setContextParam("webapp.realpath", fileURI.toString());
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("real path of webapp: " + realPath));
        }
        processor.setContextParam(TransformerService.TRANSFORMER_SERVICE, httpSession.getServletContext().getAttribute(TransformerService.TRANSFORMER_SERVICE));
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("TransformerService: " + httpSession.getServletContext().getAttribute(TransformerService.TRANSFORMER_SERVICE)));
        }
        Enumeration params = request.getParameterNames();
        while (params.hasMoreElements()) {
            String s = (String)params.nextElement();
            String value = request.getParameter(s);
            processor.setContextParam(s, value);
            if (!LOGGER.isDebugEnabled()) continue;
            LOGGER.debug((Object)("added request param '" + s + "' added to context"));
            LOGGER.debug((Object)("param value'" + value));
        }
    }

    public static boolean isMediaTypeXML(String mediatype) {
        boolean isXML;
        boolean bl = isXML = mediatype.startsWith("text") || mediatype.startsWith("application");
        if (isXML) {
            isXML = isXML && (mediatype.contains("xml") || mediatype.contains("xhtml+xml"));
        }
        return isXML;
    }

    public static void doTransform(ServletContext context, HttpServletResponse response, Document input, String stylesheetName, Object params) throws IOException {
        CachingTransformerService transformerService = (CachingTransformerService)context.getAttribute(TransformerService.TRANSFORMER_SERVICE);
        DOMSource xmlSource = new DOMSource(input);
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        try {
            Transformer transformer = transformerService.getTransformerByName(stylesheetName);
            if (params != null && params instanceof Node) {
                transformer.setParameter("params", params);
            }
            transformer.transform(xmlSource, new StreamResult(outputStream));
        }
        catch (TransformerException e) {
            e.printStackTrace();
        }
        response.setContentType(HTML_CONTENT_TYPE);
        response.setContentLength(outputStream.toByteArray().length);
        response.getOutputStream().write(outputStream.toByteArray());
        response.getOutputStream().close();
    }
}

