/*
 * Decompiled with CFR 0.152.
 */
package de.betterform.agent.web.event;

import de.betterform.xml.events.XMLEvent;
import de.betterform.xml.events.XMLEventFactory;
import de.betterform.xml.events.impl.DefaultXMLEventInitializer;
import de.betterform.xml.events.impl.DefaultXMLEventService;
import de.betterform.xml.events.impl.XercesXMLEvent;
import de.betterform.xml.events.impl.XercesXMLEventFactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Element;

public class EventQueue {
    public static List<String> HELPER_ELEMENTS = Arrays.asList("label", "help", "hint", "alert", "value");
    private List<XMLEvent> eventList = new ArrayList<XMLEvent>();
    protected static Log LOGGER = LogFactory.getLog(EventQueue.class);
    private List<XMLEvent> loadEmbedEventList = new ArrayList<XMLEvent>();

    public List<XMLEvent> getEventList() {
        return this.aggregateEventList();
    }

    public void add(XMLEvent event) {
        try {
            XMLEvent clonedEvent = (XMLEvent)event.clone();
            Element target = (Element)((Object)clonedEvent.getTarget());
            clonedEvent.addProperty("targetId", target.getAttributeNS(null, "id"));
            String targetName = target.getLocalName();
            clonedEvent.addProperty("targetName", targetName);
            if ("betterform-item-changed".equals(clonedEvent.getType()) || "betterform-state-changed".equals(clonedEvent.getType()) && HELPER_ELEMENTS.contains(targetName) || "betterform-prototype-cloned".equals(clonedEvent.getType()) || "betterform-item-deleted".equals(clonedEvent.getType())) {
                String parentId = ((Element)target.getParentNode()).getAttributeNS(null, "id");
                clonedEvent.addProperty("parentId", parentId);
            } else if ("betterform-state-changed".equals(clonedEvent.getType()) && "output".equals(targetName) && "label".equals(target.getParentNode().getLocalName()) && "trigger".equals(target.getParentNode().getParentNode().getLocalName())) {
                String parentId = ((Element)target.getParentNode().getParentNode()).getAttributeNS(null, "id");
                clonedEvent.addProperty("parentId", parentId);
                clonedEvent.addProperty("targetName", "label");
            }
            ((XercesXMLEvent)clonedEvent).target = null;
            ((XercesXMLEvent)clonedEvent).currentTarget = null;
            if (this.isLoadEmbedEvent(clonedEvent)) {
                this.loadEmbedEventList.add(clonedEvent);
            } else {
                this.eventList.add(clonedEvent);
            }
        }
        catch (CloneNotSupportedException e) {
            e.printStackTrace();
        }
    }

    public XMLEvent add(String type, String targetId, String targetName) {
        DefaultXMLEventService xmlEventService = new DefaultXMLEventService();
        xmlEventService.setXMLEventFactory(new XercesXMLEventFactory());
        xmlEventService.setXMLEventInitializer(new DefaultXMLEventInitializer());
        XMLEventFactory xmlEventFactory = xmlEventService.getXMLEventFactory();
        XMLEvent xmlEvent = xmlEventFactory.createXMLEvent(type);
        xmlEvent.initXMLEvent(type, false, false, null);
        xmlEvent.addProperty("targetid", targetId);
        xmlEvent.addProperty("targetName", targetName);
        this.eventList.add(xmlEvent);
        return xmlEvent;
    }

    private boolean isLoadEmbedEvent(XMLEvent xmlEvent) {
        if (xmlEvent.getType() == null || xmlEvent.getContextInfo() == null) {
            return false;
        }
        return xmlEvent.getType().equals("betterform-load-uri") && ("embed".equals(xmlEvent.getContextInfo("show")) || "none".equals(xmlEvent.getContextInfo("show")));
    }

    public void flush() {
        this.eventList.clear();
    }

    public void addProperty(XMLEvent progressEvent, String key, String value) {
        Map contextInfo = progressEvent.getContextInfo();
        if (contextInfo != null) {
            contextInfo.put(key, value);
        }
    }

    public List<XMLEvent> aggregateEventList() {
        LinkedList<XMLEvent> aggregatedFocusList = new LinkedList<XMLEvent>();
        Stack<XercesXMLEvent> aggregatedInsertEventsStack = new Stack<XercesXMLEvent>();
        Stack<XMLEvent> aggregatedEmbedEventsStack = new Stack<XMLEvent>();
        ArrayList<XMLEvent> aggregatedEventList = new ArrayList<XMLEvent>(this.eventList.size());
        for (XMLEvent xmlEvent : this.loadEmbedEventList) {
            aggregatedEventList.add(xmlEvent);
        }
        this.loadEmbedEventList.clear();
        for (int i = 0; i < this.eventList.size(); ++i) {
            XMLEvent xmlEvent;
            xmlEvent = (XercesXMLEvent)this.eventList.get(i);
            XercesXMLEvent xmlEventToAdd = new XercesXMLEvent();
            if (xmlEvent.getType().equals("betterform-prototype-cloned")) {
                if (((XercesXMLEvent)xmlEvent).getContextInfo("targetName").equals("itemset")) {
                    xmlEventToAdd.initXMLEvent("betterform-insert-itemset", xmlEvent.getBubbles(), xmlEvent.getCancelable(), ((XercesXMLEvent)xmlEvent).getContextInfo());
                } else {
                    xmlEventToAdd.initXMLEvent("betterform-insert-repeatitem", xmlEvent.getBubbles(), xmlEvent.getCancelable(), ((XercesXMLEvent)xmlEvent).getContextInfo());
                }
                xmlEventToAdd.target = ((XercesXMLEvent)xmlEvent).target;
                ((XercesXMLEvent)xmlEvent).addProperty("generatedIds", new HashMap());
                aggregatedEventList.add(xmlEventToAdd);
                aggregatedInsertEventsStack.push(xmlEventToAdd);
                continue;
            }
            if (xmlEvent.getType().equals("betterform-id-generated") && aggregatedInsertEventsStack.size() > 0) {
                XMLEvent aggregatingInsertEvent = (XMLEvent)aggregatedInsertEventsStack.peek();
                ((HashMap)aggregatingInsertEvent.getContextInfo("generatedIds")).put(((XercesXMLEvent)xmlEvent).getContextInfo("originalId"), ((XercesXMLEvent)xmlEvent).getContextInfo("targetId"));
                continue;
            }
            if (xmlEvent.getType().equals("betterform-item-inserted")) {
                XMLEvent tmpEvent = (XMLEvent)aggregatedInsertEventsStack.pop();
                tmpEvent.addProperty("position", ((XercesXMLEvent)xmlEvent).getContextInfo("position"));
                tmpEvent.addProperty("label", ((XercesXMLEvent)xmlEvent).getContextInfo("label"));
                tmpEvent.addProperty("value", ((XercesXMLEvent)xmlEvent).getContextInfo("value"));
                continue;
            }
            if (xmlEvent.getType().equals("betterform-embed")) {
                aggregatedEventList.add(xmlEvent);
                aggregatedEmbedEventsStack.push(xmlEvent);
                continue;
            }
            if (xmlEvent.getType().equals("betterform-embed-done")) {
                ((XMLEvent)aggregatedEmbedEventsStack.pop()).addProperty("targetElement", ((XercesXMLEvent)xmlEvent).getContextInfo("targetElement"));
                aggregatedEventList.add(xmlEvent);
                continue;
            }
            if (xmlEvent.getType().equals("xforms-focus")) {
                aggregatedFocusList.push(xmlEvent);
                continue;
            }
            aggregatedEventList.add(xmlEvent);
        }
        while (!aggregatedFocusList.isEmpty()) {
            aggregatedEventList.add((XMLEvent)aggregatedFocusList.pollLast());
        }
        return aggregatedEventList;
    }
}

