/*
 * Decompiled with CFR 0.152.
 */
package de.betterform.agent.web.filter;

import de.betterform.agent.web.WebFactory;
import de.betterform.agent.web.WebProcessor;
import de.betterform.agent.web.WebUtil;
import de.betterform.agent.web.cache.XFSessionCache;
import de.betterform.agent.web.event.DefaultUIEventImpl;
import de.betterform.agent.web.filter.BufferedHttpServletResponseWrapper;
import de.betterform.agent.web.flux.FluxProcessor;
import de.betterform.xml.config.Config;
import de.betterform.xml.config.XFormsConfigException;
import de.betterform.xml.xforms.XFormsProcessorImpl;
import de.betterform.xml.xforms.exception.XFormsErrorIndication;
import de.betterform.xml.xforms.exception.XFormsException;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.Enumeration;
import java.util.Map;
import java.util.regex.Pattern;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;
import javax.servlet.http.HttpSession;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.infinispan.Cache;

public class XFormsFilter
implements Filter {
    private static final Log LOG = LogFactory.getLog(XFormsFilter.class);
    private static final String USERAGENT = "dojo";
    protected WebFactory webFactory;
    protected String defaultRequestEncoding = "UTF-8";
    private FilterConfig filterConfig;
    private static final String SRCPARAMETER = "__bf:source";

    public void init(FilterConfig filterConfig) throws ServletException {
        this.filterConfig = filterConfig;
        this.webFactory = new WebFactory();
        this.webFactory.setServletContext(filterConfig.getServletContext());
        try {
            this.webFactory.initConfiguration(USERAGENT);
            this.defaultRequestEncoding = this.webFactory.getConfig().getProperty("defaultRequestEncoding", this.defaultRequestEncoding);
            this.webFactory.initLogging(this.getClass());
            String realPath = WebFactory.getRealPath(".", this.filterConfig.getServletContext());
            this.webFactory.initTransformerService(realPath);
        }
        catch (XFormsConfigException e) {
            throw new ServletException((Throwable)e);
        }
    }

    public void destroy() {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"cleanups allocated resources");
        }
    }

    public void doFilter(ServletRequest srvRequest, ServletResponse srvResponse, FilterChain filterChain) throws IOException, ServletException {
        if (srvRequest.getCharacterEncoding() == null) {
            srvRequest.setCharacterEncoding(this.defaultRequestEncoding);
        }
        HttpServletRequest request = (HttpServletRequest)srvRequest;
        HttpServletResponse response = (HttpServletResponse)srvResponse;
        HttpSession session = request.getSession(true);
        if (request.getHeader("betterform-internal") != null) {
            LOG.warn((Object)"Request from internal betterForm HTTP Client arrived in XFormsFilter");
            String requestURI = request.getRequestURI();
            String mimeType = this.webFactory.getServletContext().getMimeType(requestURI);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("request URI: " + requestURI));
                LOG.debug((Object)("mimeType: " + mimeType));
            }
            if (mimeType != null) {
                srvResponse.setContentType(mimeType);
            } else {
                LOG.warn((Object)"no contenttype set for internal request");
            }
            filterChain.doFilter(srvRequest, srvResponse);
            return;
        }
        try {
            if (Config.getInstance().getProperty("betterform.debug-allowed").equals("true") && request.getParameter(SRCPARAMETER) != null) {
                srvResponse.setContentType("text/plain");
                HttpServletResponseWrapper resp = new HttpServletResponseWrapper((HttpServletResponse)srvResponse){

                    public void setContentType(String s) {
                    }
                };
                filterChain.doFilter(srvRequest, (ServletResponse)resp);
                return;
            }
        }
        catch (XFormsConfigException resp) {
            // empty catch block
        }
        if (request.getParameter("isUpload") != null) {
            this.handleUpload(request, response, session);
        } else if ("GET".equalsIgnoreCase(request.getMethod()) && request.getParameter("submissionResponse") != null) {
            this.doSubmissionReplaceAll(request, response);
        } else if ("GET".equalsIgnoreCase(request.getMethod()) && request.getParameter("submissionResponseXForms") != null) {
            this.doSubmissionReplaceAllXForms(request, response, session);
        } else {
            byte[] data;
            LOG.info((Object)"Passing to Chain");
            BufferedHttpServletResponseWrapper bufResponse = new BufferedHttpServletResponseWrapper((HttpServletResponse)srvResponse);
            filterChain.doFilter(srvRequest, (ServletResponse)bufResponse);
            LOG.info((Object)"Returned from Chain");
            if (!bufResponse.isBuffered()) {
                return;
            }
            if (bufResponse.isCommitted()) {
                return;
            }
            request.setAttribute("useragent", (Object)USERAGENT);
            if (this.handleResponseBody(request, bufResponse) && (data = this.prepareData(bufResponse)).length > 0) {
                request.setAttribute("XFormsInputStream", (Object)new ByteArrayInputStream(data));
            }
            if (this.handleRequestAttributes(request)) {
                bufResponse.getOutputStream().close();
                LOG.info((Object)"Start Filter XForm");
                this.processXForms(request, response, session);
                LOG.info((Object)"End Render XForm");
            } else {
                srvResponse.getOutputStream().write(bufResponse.getData());
                srvResponse.getOutputStream().close();
            }
        }
    }

    private void processXForms(HttpServletRequest request, HttpServletResponse response, HttpSession session) throws IOException, ServletException {
        block9: {
            FluxProcessor webProcessor = null;
            try {
                webProcessor = new FluxProcessor();
                webProcessor.setXformsProcessor(new XFormsProcessorImpl());
                webProcessor.setRequest(request);
                webProcessor.setResponse(response);
                webProcessor.setHttpSession(session);
                webProcessor.setBaseURI(request.getRequestURL().toString());
                webProcessor.setContext(this.webFactory.getServletContext());
                webProcessor.configure();
                webProcessor.setXForms();
                webProcessor.init();
                webProcessor.handleRequest();
                Cache<String, FluxProcessor> cache = XFSessionCache.getCache();
                String key = webProcessor.getKey();
                if (cache.containsKey((Object)key)) {
                    LOG.warn((Object)("Session already exists - key: " + key));
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("adding new session to cache. Key:" + key));
                }
                cache.put((Object)key, (Object)webProcessor);
            }
            catch (Exception e) {
                LOG.error((Object)e.getMessage(), (Throwable)e);
                if (webProcessor == null) break block9;
                if (e instanceof XFormsErrorIndication) {
                    try {
                        session.setAttribute("betterform.hostDoc", (Object)webProcessor.getXForms());
                    }
                    catch (XFormsException e1) {
                        e1.printStackTrace();
                    }
                }
                try {
                    webProcessor.shutdown();
                }
                catch (XFormsException xfe) {
                    LOG.error((Object)("Could not shutdown Processor: Error: " + xfe.getMessage() + " Cause: " + xfe.getCause()));
                }
                session.setAttribute("betterform.exception", (Object)e);
                session.setAttribute("betterform.exception.message", (Object)e.getMessage());
                session.setAttribute("betterform.referer", (Object)request.getRequestURL());
                WebUtil.removeSession(webProcessor.getKey());
                String path = "/" + this.webFactory.getConfig().getProperty("error.page");
                this.webFactory.getServletContext().getRequestDispatcher(path).forward((ServletRequest)request, (ServletResponse)response);
            }
        }
    }

    private void handleUpload(HttpServletRequest request, HttpServletResponse response, HttpSession session) throws ServletException {
        response.setContentType("text/html");
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"*** FluxHelper ***");
        }
        WebProcessor webProcessor = WebUtil.getWebProcessor(request, response, session);
        try {
            if (webProcessor == null) {
                throw new ServletException(Config.getInstance().getErrorMessage("session-invalid"));
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)(this + ": xformssession:" + webProcessor.getKey()));
            }
            DefaultUIEventImpl uiEvent = new DefaultUIEventImpl();
            uiEvent.initEvent("http-request", null, request);
            webProcessor.handleUIEvent(uiEvent);
        }
        catch (Exception e) {
            throw new ServletException((Throwable)e);
        }
    }

    protected byte[] prepareData(BufferedHttpServletResponseWrapper bufResponse) throws UnsupportedEncodingException {
        return this.correctInstanceXMLNS(bufResponse.getData());
    }

    protected boolean handleRequestAttributes(HttpServletRequest request) {
        return request.getAttribute("XFormsInputNode") != null || request.getAttribute("XFormsInputURI") != null || request.getAttribute("XFormsInputSource") != null || request.getAttribute("XFormsInputStream") != null;
    }

    protected boolean handleResponseBody(HttpServletRequest request, BufferedHttpServletResponseWrapper bufResponse) throws UnsupportedEncodingException {
        String contentType;
        if (request.getAttribute("betterform.filter.parseResponseBody") != null) {
            return true;
        }
        if (request.getAttribute("betterform.filter.ignoreResponseBody") != null) {
            return false;
        }
        String acceptedContentType = this.webFactory.getConfig().getProperty("acceptContentTypePattern", "");
        if (!"".equals(acceptedContentType) && (acceptedContentType.equalsIgnoreCase("all_xml") ? bufResponse.hasXMLContentType() : Pattern.matches(acceptedContentType, contentType = bufResponse.getMediaType()))) {
            return true;
        }
        if (this.disableReponseBodyParsing()) {
            return false;
        }
        String strResponse = bufResponse.getDataAsString();
        if (!strResponse.trim().startsWith("<")) {
            return false;
        }
        int xfNSDeclEnd = strResponse.indexOf("=\"http://www.w3.org/2002/xforms\"");
        if (xfNSDeclEnd != -1) {
            String temp = strResponse.substring(0, xfNSDeclEnd);
            int xfNSDeclStart = temp.lastIndexOf(58) + 1;
            String xfNSLocal = temp.substring(xfNSDeclStart);
            if (strResponse.contains('<' + xfNSLocal + ":")) {
                return true;
            }
        }
        try {
            if (Config.getInstance().getProperty("webprocessor.doIncludes").equals("true") && bufResponse.hasXMLContentType()) {
                return true;
            }
        }
        catch (XFormsConfigException e) {
            return false;
        }
        return false;
    }

    protected boolean disableReponseBodyParsing() {
        boolean ignoreResponse = false;
        try {
            ignoreResponse = Config.getInstance().getProperty("filter.ignoreResponseBody").equalsIgnoreCase("true");
        }
        catch (XFormsConfigException e) {
            ignoreResponse = false;
        }
        return ignoreResponse;
    }

    private byte[] removeDocumentTypePI(byte[] content) throws UnsupportedEncodingException {
        String buf = new String(content, "ISO-8859-1");
        int iStartDoctype = buf.indexOf("<!DOCTYPE");
        if (iStartDoctype > -1) {
            int iEndDoctype = buf.indexOf(62, iStartDoctype);
            String newBuf = buf.substring(0, iStartDoctype - 1);
            newBuf = newBuf + buf.substring(iEndDoctype + 1);
            return newBuf.getBytes("ISO-8859-1");
        }
        return content;
    }

    private byte[] correctInstanceXMLNS(byte[] content) throws UnsupportedEncodingException {
        String buffer = new String(content, "UTF-8");
        if (buffer.indexOf("<xforms:instance xmlns=\"\">") == -1) {
            String newBuf = buffer.replace("<xforms:instance>", "<xforms:instance xmlns=\"\">");
            return newBuf.getBytes("UTF-8");
        }
        return content;
    }

    protected void doSubmissionReplaceAll(HttpServletRequest request, HttpServletResponse response) throws IOException {
        Map submissionResponse = this.handleResponseReplaceAll(request, response);
        if (submissionResponse != null) {
            InputStream bodyStream = (InputStream)submissionResponse.get("body");
            BufferedOutputStream outputStream = new BufferedOutputStream((OutputStream)response.getOutputStream());
            int b = bodyStream.read();
            while (b > -1) {
                ((OutputStream)outputStream).write(b);
                b = bodyStream.read();
            }
            bodyStream.close();
            ((OutputStream)outputStream).close();
            return;
        }
        response.sendError(403, "no submission response available");
    }

    protected void doSubmissionReplaceAllXForms(HttpServletRequest request, HttpServletResponse response, HttpSession session) throws IOException, ServletException {
        Map submissionResponse = this.handleResponseReplaceAll(request, response);
        if (submissionResponse != null) {
            request.setAttribute("useragent", (Object)USERAGENT);
            request.setAttribute("XFormsInputStream", submissionResponse.get("body"));
            this.processXForms(request, response, session);
            return;
        }
        response.sendError(403, "no submission response available");
    }

    private Map handleResponseReplaceAll(HttpServletRequest request, HttpServletResponse response) throws IOException {
        Map submissionResponse = null;
        HttpSession session = request.getSession(false);
        WebProcessor webProcessor = WebUtil.getWebProcessor(request, response, session);
        if (session != null && webProcessor != null) {
            String s;
            Enumeration keys;
            if (LOG.isDebugEnabled()) {
                keys = session.getAttributeNames();
                if (keys.hasMoreElements()) {
                    LOG.debug((Object)"--- existing keys in session --- ");
                }
                while (keys.hasMoreElements()) {
                    s = (String)keys.nextElement();
                    LOG.debug((Object)("existing sessionkey: " + s + ":" + session.getAttribute(s)));
                }
            }
            if ((submissionResponse = webProcessor.checkForExitEvent().getContextInfo()) != null) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)"handling submission/@replace='all'");
                    keys = session.getAttributeNames();
                    if (keys.hasMoreElements()) {
                        LOG.debug((Object)"--- existing keys in http session  --- ");
                        while (keys.hasMoreElements()) {
                            s = (String)keys.nextElement();
                            LOG.debug((Object)("existing sessionkey: " + s + ":" + session.getAttribute(s)));
                        }
                    } else {
                        LOG.debug((Object)"--- no keys left in http session  --- ");
                    }
                }
                Map headerMap = (Map)submissionResponse.get("header");
                for (String name : headerMap.keySet()) {
                    if (name.equalsIgnoreCase("Transfer-Encoding")) continue;
                    String value = (String)headerMap.get(name);
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("added header: " + name + "=" + value));
                    }
                    response.setHeader(name, value);
                }
                WebUtil.removeSession(webProcessor.getKey());
            }
        }
        return submissionResponse;
    }
}

