/*
 * Decompiled with CFR 0.152.
 */
package de.betterform.agent.web.flux;

import de.betterform.agent.web.WebProcessor;
import de.betterform.agent.web.WebUtil;
import de.betterform.agent.web.event.DefaultUIEventImpl;
import de.betterform.agent.web.event.EventQueue;
import de.betterform.agent.web.event.UIEvent;
import de.betterform.agent.web.flux.FluxException;
import de.betterform.agent.web.flux.FluxModel;
import de.betterform.agent.web.flux.FluxProcessor;
import de.betterform.agent.web.flux.FluxUtil;
import de.betterform.agent.web.upload.UploadInfo;
import de.betterform.xml.dom.DOMUtil;
import de.betterform.xml.events.XMLEvent;
import de.betterform.xml.events.impl.XercesXMLEventFactory;
import de.betterform.xml.xforms.exception.XFormsException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.directwebremoting.WebContextFactory;
import org.w3c.dom.Element;

public class FluxFacade {
    public static final String FLUX_ACTIVATE_EVENT = "flux-action-event";
    private static final Log LOGGER = LogFactory.getLog(FluxFacade.class);
    private HttpSession session = WebContextFactory.get().getSession(true);
    private HttpServletRequest request = WebContextFactory.get().getHttpServletRequest();
    private HttpServletResponse response = WebContextFactory.get().getHttpServletResponse();

    public List<XMLEvent> init(String sessionKey) throws FluxException {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"FluxProcessor init called on Facade");
        }
        FluxProcessor processor = FluxUtil.getProcessor(sessionKey, this.request, this.response, this.session);
        return processor.getEventQueue().getEventList();
    }

    public List<XMLEvent> dispatchEvent(String id, String sessionKey) throws XFormsException {
        FluxProcessor processor = null;
        try {
            processor = FluxUtil.getProcessor(sessionKey, this.request, this.response, this.session);
            processor.dispatchEvent(id);
            return processor.getEventQueue().getEventList();
        }
        catch (FluxException e) {
            return this.renderErrorMessage(e.getMessage());
        }
    }

    private List<XMLEvent> renderErrorMessage(String message) {
        LOGGER.warn((Object)("betterFORM Error Message: " + message));
        XMLEvent errorEvent = new XercesXMLEventFactory().createXMLEvent("betterform-render-message");
        HashMap<String, String> params = new HashMap<String, String>(1);
        params.put("message", message);
        errorEvent.initXMLEvent("betterform-render-message", true, false, params);
        ArrayList<XMLEvent> list = new ArrayList<XMLEvent>();
        list.add(errorEvent);
        return list;
    }

    public List<XMLEvent> dispatchEventType(String id, String eventType, String sessionKey) throws XFormsException {
        return this.dispatchEventTypeWithContext(id, eventType, sessionKey, Collections.EMPTY_MAP);
    }

    public List<XMLEvent> dispatchEventTypeWithContext(String id, String eventType, String sessionKey, String contextInfo) throws XFormsException {
        HashMap<String, String> params;
        if (contextInfo != null) {
            params = new HashMap<String, String>(1);
            params.put("context-info", contextInfo);
        } else {
            params = Collections.EMPTY_MAP;
        }
        return this.dispatchEventTypeWithContext(id, eventType, sessionKey, params);
    }

    public List<XMLEvent> dispatchEventTypeWithContext(String id, String eventType, String sessionKey, Map contextInfo) throws XFormsException {
        FluxProcessor processor = null;
        try {
            processor = FluxUtil.getProcessor(sessionKey, this.request, this.response, this.session);
            processor.getEventQueue().flush();
        }
        catch (FluxException e) {
            e.printStackTrace();
        }
        try {
            if (contextInfo != null && !contextInfo.isEmpty()) {
                assert (processor != null) : "Processor is null - you likely have no valid session.";
                processor.dispatch(id, eventType, contextInfo, true, false);
            } else {
                assert (processor != null) : "Processor is null - you likely have no valid session.";
                processor.dispatch(id, eventType);
            }
        }
        catch (XFormsException e) {
            return this.renderErrorMessage(e.getMessage());
        }
        return processor.getEventQueue().getEventList();
    }

    public List<XMLEvent> dispatchEventTypeWithContext(String id, String eventType, String sessionKey, Object[] contextInfo) throws XFormsException {
        HashMap<String, Object> params;
        if (contextInfo != null) {
            params = new HashMap<String, Object>();
            for (int i = 0; i < contextInfo.length; ++i) {
                params.put("param" + i, contextInfo[i]);
            }
        } else {
            params = Collections.EMPTY_MAP;
        }
        return this.dispatchEventTypeWithContext(id, eventType, sessionKey, params);
    }

    public List setUIControlValue(String id, String value, String sessionKey) throws XFormsException {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("FluxFProcessor: " + this.toString()));
        }
        DefaultUIEventImpl event = new DefaultUIEventImpl();
        event.initEvent("SETVALUE", id, value);
        List results = null;
        try {
            results = this.handleUIEvent(event, sessionKey);
        }
        catch (FluxException e) {
            return this.renderErrorMessage(e.getMessage());
        }
        return results;
    }

    public List setXFormsValue(String id, String value, String sessionKey) throws FluxException {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("FluxFacade instance: " + this.toString()));
        }
        DefaultUIEventImpl event = new DefaultUIEventImpl();
        event.initEvent("SETVALUE", id, value);
        return this.handleUIEvent(event, sessionKey);
    }

    public Element getXFormsDOM(String sessionKey) throws FluxException {
        try {
            Element resultElem = FluxUtil.getProcessor(sessionKey, this.request, this.response, this.session).getXForms().getDocumentElement();
            if (LOGGER.isDebugEnabled()) {
                DOMUtil.prettyPrintDOM(resultElem);
            }
            return resultElem;
        }
        catch (XFormsException e) {
            throw new FluxException(e);
        }
    }

    public List setRepeatIndex(String id, String position, String sessionKey) throws FluxException {
        DefaultUIEventImpl event = new DefaultUIEventImpl();
        event.initEvent("SETINDEX", id, position);
        return this.handleUIEvent(event, sessionKey);
    }

    public List<XMLEvent> fetchProgress(String id, String filename, String sessionKey) {
        String progress;
        if (this.session != null && this.session.getAttribute("A" + sessionKey + "-uploadInfo") != null) {
            UploadInfo uploadInfo = (UploadInfo)this.session.getAttribute("A" + sessionKey + "-uploadInfo");
            if (uploadInfo.isInProgress()) {
                double p = uploadInfo.getBytesRead() / uploadInfo.getTotalSize();
                progress = p + "";
                float total = uploadInfo.getTotalSize();
                float read = uploadInfo.getBytesRead();
                int iProgress = (int)Math.ceil(read / total * 100.0f);
                if (iProgress < 100) {
                    progress = Integer.toString(iProgress);
                } else {
                    uploadInfo.setStatus("completed");
                    progress = "100";
                }
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug((Object)("Bytes total: " + uploadInfo.getTotalSize()));
                    LOGGER.debug((Object)("Bytes read: " + uploadInfo.getBytesRead()));
                    LOGGER.debug((Object)("elapsed time: " + uploadInfo.getElapsedTime()));
                    LOGGER.debug((Object)("status: " + uploadInfo.getStatus()));
                    LOGGER.debug((Object)("Percent completed: " + Math.ceil(read / total * 100.0f)));
                }
            } else {
                progress = "100";
            }
        } else {
            progress = "100";
        }
        WebProcessor webProcessor = WebUtil.getWebProcessor(sessionKey, this.request, this.response, this.session);
        if (webProcessor == null) {
            return this.renderErrorMessage("ERROR: session " + sessionKey + " does not exist");
        }
        EventQueue eventQueue = null;
        if (webProcessor != null) {
            FluxProcessor processor = (FluxProcessor)webProcessor;
            eventQueue = processor.getEventQueue();
            XMLEvent progressEvent = eventQueue.add("upload-progress-event", id, "upload");
            eventQueue.addProperty(progressEvent, "progress", progress);
            List<XMLEvent> origEvents = eventQueue.getEventList();
            ArrayList<XMLEvent> eventList = new ArrayList<XMLEvent>();
            for (XMLEvent xmlEvent : origEvents) {
                eventList.add(xmlEvent);
            }
            eventQueue.flush();
            return eventList;
        }
        eventQueue = new EventQueue();
        XMLEvent progressEvent = eventQueue.add("upload-progress-event", id, "upload");
        eventQueue.addProperty(progressEvent, "progress", progress);
        return eventQueue.getEventList();
    }

    public List setLocale(String locale, String sessionKey) throws FluxException {
        WebProcessor webProcessor;
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("switching locale to '" + locale + "' for Session:'" + sessionKey + "'"));
        }
        if ((webProcessor = WebUtil.getWebProcessor(sessionKey, this.request, this.response, this.session)) == null) {
            XMLEvent errorEvent = new XercesXMLEventFactory().createXMLEvent("betterform-render-message");
            HashMap<String, String> params = new HashMap<String, String>(1);
            params.put("message", "ERROR: FluxFacade.setLocale(): session " + sessionKey + " does not exist");
            errorEvent.initXMLEvent("betterform-render-message", true, false, params);
            ArrayList<XMLEvent> list = new ArrayList<XMLEvent>();
            list.add(errorEvent);
            return list;
        }
        Locale betterformlocale = new Locale(locale);
        webProcessor.setContextParam("betterform.locale", betterformlocale);
        DefaultUIEventImpl event = new DefaultUIEventImpl();
        event.initEvent("SETLOCALE", "locale", locale);
        return this.handleUIEvent(event, sessionKey);
    }

    public void close(String sessionKey) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("FluxFacade close: " + sessionKey));
        }
        try {
            WebProcessor webProcessor = WebUtil.getWebProcessor(sessionKey, this.request, this.response, this.session);
            if (webProcessor == null) {
                return;
            }
            webProcessor.shutdown();
        }
        catch (XFormsException e) {
            LOGGER.warn((Object)("FluxFacade close: " + sessionKey), (Throwable)e);
        }
        finally {
            WebUtil.removeSession(sessionKey);
        }
    }

    private List handleUIEvent(UIEvent uiEvent, String sessionKey) throws FluxException {
        FluxProcessor processor = FluxUtil.getProcessor(sessionKey, this.request, this.response, this.session);
        if (processor != null) {
            try {
                processor.handleUIEvent(uiEvent);
            }
            catch (XFormsException e) {
                LOGGER.error((Object)e.getMessage());
            }
        } else {
            throw new FluxException("Sorry your session expired. Press Reload to start over.");
        }
        EventQueue eventQueue = processor.getEventQueue();
        List<XMLEvent> eventlog = eventQueue.getEventList();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("Object ID: " + this));
            LOGGER.debug((Object)("EventLog: " + eventlog.toString()));
            LOGGER.debug((Object)("FluxProcessor: " + processor));
        }
        return eventlog;
    }

    public static Element getInstanceDocument(String modelId, String instanceId, String sessionKey) {
        return FluxModel.getInstanceDocument(modelId, instanceId, sessionKey);
    }
}

