/*
 * Decompiled with CFR 0.152.
 */
package de.betterform.agent.web.servlet;

import de.betterform.agent.web.WebFactory;
import de.betterform.agent.web.WebProcessor;
import de.betterform.agent.web.WebUtil;
import de.betterform.xml.config.Config;
import de.betterform.xml.config.XFormsConfigException;
import de.betterform.xml.dom.DOMUtil;
import de.betterform.xml.xforms.exception.XFormsException;
import de.betterform.xml.xpath.XPathUtil;
import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.xforms.XFormsModelElement;

public class XFormsInspectorServlet
extends HttpServlet {
    private static final Log LOGGER = LogFactory.getLog(XFormsInspectorServlet.class);
    public static final String defContentType = "text/html;charset=UTF-8";
    private WebFactory webFactory;

    public String getServletInfo() {
        return "responsible for showing the views to the user in betterForm XForms applications";
    }

    public void destroy() {
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        block8: {
            String resource = request.getRequestURI();
            HttpSession session = request.getSession(true);
            String[] steps = XPathUtil.splitPathExpr(resource);
            String xformsSessionId = resource.indexOf("hostDOM") != -1 ? steps[steps.length - 2] : steps[steps.length - 3];
            WebProcessor processor = WebUtil.getWebProcessor(xformsSessionId, request, response, session);
            if (processor == null) {
                this.sendError(request, response, session, null, "Processor with sessionId '" + xformsSessionId + "' not found.");
                return;
            }
            try {
                XFormsModelElement model;
                response.setContentType("text/html");
                ServletOutputStream out = response.getOutputStream();
                Element rootNode = DOMUtil.createRootElement("data");
                DOMUtil.appendElement(rootNode, "URI", processor.getBaseURI());
                DOMUtil.appendElement(rootNode, "context", request.getContextPath());
                if (resource.indexOf("hostDOM") != -1) {
                    Document host = processor.getXForms();
                    request.setAttribute("betterform.filter.ignoreResponseBody", (Object)"TRUE");
                    WebUtil.doTransform(this.getServletContext(), response, host, "highlightDocument.xsl", rootNode);
                    break block8;
                }
                String modelId = steps[steps.length - 2];
                String instanceId = steps[steps.length - 1];
                try {
                    model = processor.getXFormsModel(modelId);
                }
                catch (XFormsException xe) {
                    this.sendError(request, response, session, xe, "Model with id '" + modelId + "' not found.");
                    return;
                }
                try {
                    Document instance = model.getInstanceDocument(instanceId);
                    DOMUtil.appendElement(rootNode, "model", modelId);
                    DOMUtil.appendElement(rootNode, "instance", instanceId);
                    WebUtil.doTransform(this.getServletContext(), response, instance, "highlightDocument.xsl", rootNode);
                }
                catch (DOMException de) {
                    this.sendError(request, response, session, null, "Instance with id '" + instanceId + "' not found.");
                    return;
                }
            }
            catch (XFormsException e) {
                e.printStackTrace();
            }
        }
    }

    private void sendError(HttpServletRequest request, HttpServletResponse response, HttpSession session, Exception e, String message) throws ServletException, IOException {
        session.setAttribute("betterform.exception", (Object)e);
        session.setAttribute("betterform.exception.message", (Object)message);
        session.setAttribute("betterform.referer", (Object)request.getRequestURL());
        String path = null;
        try {
            path = "/" + Config.getInstance().getProperty("error.page");
        }
        catch (XFormsConfigException ce) {
            ce.printStackTrace();
        }
        this.getServletContext().getRequestDispatcher(path).forward((ServletRequest)request, (ServletResponse)response);
    }
}

