/*
 * Decompiled with CFR 0.152.
 */
package de.betterform.agent.web.servlet;

import de.betterform.agent.web.WebFactory;
import de.betterform.agent.web.WebUtil;
import de.betterform.xml.config.XFormsConfigException;
import de.betterform.xml.dom.DOMUtil;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.OutputStream;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class XFormsRequestURIServlet
extends HttpServlet {
    private static final Log LOGGER = LogFactory.getLog(XFormsRequestURIServlet.class);

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        LOGGER.debug((Object)"hit XFormsRequestURIServlet");
        request.setCharacterEncoding("UTF-8");
        WebUtil.nonCachingResponse(response);
        String formRequestURI = request.getRequestURI().substring(request.getContextPath().length() + 1);
        String realPath = null;
        try {
            realPath = WebFactory.getRealPath(formRequestURI, this.getServletContext());
        }
        catch (XFormsConfigException e) {
            throw new ServletException((Throwable)e);
        }
        File xfDoc = new File(realPath);
        if (request.getHeader("betterform-internal") != null) {
            int read;
            BufferedInputStream in = new BufferedInputStream(new FileInputStream(xfDoc));
            BufferedOutputStream out = new BufferedOutputStream((OutputStream)response.getOutputStream());
            while ((read = in.read()) > -1) {
                out.write(read);
            }
            out.flush();
        } else {
            Document doc;
            try {
                doc = DOMUtil.parseXmlFile(xfDoc, true, false);
            }
            catch (ParserConfigurationException e) {
                throw new ServletException((Throwable)e);
            }
            catch (SAXException e) {
                throw new ServletException((Throwable)e);
            }
            request.setAttribute("XFormsInputNode", (Object)doc);
            response.getOutputStream().close();
        }
    }
}

