/*
 * Decompiled with CFR 0.152.
 */
package de.betterform.agent.web.servlet.compositecontrols;

import de.betterform.agent.web.servlet.compositecontrols.CompositeControlValue;

public class DayTimeDurationValue
implements CompositeControlValue {
    public static final String prefix = "c_datmd_";
    private Integer days = null;
    private Integer hours = null;
    private Integer minutes = null;
    private Integer seconds = null;

    @Override
    public void setPart(String name, String value) {
        String partName = name.substring(prefix.length());
        partName = partName.substring(0, partName.lastIndexOf(95));
        Integer partValue = null;
        try {
            partValue = new Integer(value);
        }
        catch (NumberFormatException e) {
            partValue = new Integer(0);
        }
        if (partName.equals("days")) {
            this.days = partValue;
        } else if (partName.equals("hours")) {
            this.hours = partValue;
        } else if (partName.equals("minutes")) {
            this.minutes = partValue;
        } else if (partName.equals("seconds")) {
            this.seconds = partValue;
        }
    }

    @Override
    public boolean isComplete() {
        return this.days != null && this.hours != null && this.minutes != null && this.seconds != null;
    }

    @Override
    public String toString() {
        if (!this.isComplete()) {
            return new String();
        }
        String dayTimeDuration = new String("P");
        dayTimeDuration = dayTimeDuration + this.days.toString() + 'D';
        dayTimeDuration = dayTimeDuration + 'T';
        dayTimeDuration = dayTimeDuration + this.hours.toString() + 'H';
        dayTimeDuration = dayTimeDuration + this.minutes.toString() + 'M';
        dayTimeDuration = dayTimeDuration + this.seconds.toString() + 'S';
        return dayTimeDuration;
    }
}

