/*
 * Decompiled with CFR 0.152.
 */
package de.betterform.agent.web.utils;

import de.betterform.agent.web.WebFactory;
import de.betterform.agent.web.WebUtil;
import de.betterform.generator.UIGenerator;
import de.betterform.generator.XSLTGenerator;
import de.betterform.xml.config.Config;
import de.betterform.xml.config.XFormsConfigException;
import de.betterform.xml.xforms.XFormsProcessor;
import de.betterform.xml.xforms.exception.XFormsException;
import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.w3c.dom.Element;

public class WebTranscoder {
    public static final String XSL_PARAM_NAME = "xslt";
    public static final String RESOURCE_DIR = "WEB-INF/classes/META-INF/resources/";
    public static final String ACTIONURL_PARAM_NAME = "action_url";
    private XFormsProcessor xformsProcessor;
    private Config configuration;
    private HttpServletRequest request;
    protected transient HttpServletResponse response;
    private ServletContext context;
    private HttpSession httpSession;
    private String useragent;
    private String xformsSessionKey;

    public void setConfiguration(Config configuration) {
        this.configuration = configuration;
    }

    public void setRequest(HttpServletRequest request) {
        this.request = request;
    }

    public void setResponse(HttpServletResponse response) {
        this.response = response;
    }

    public void setContext(ServletContext context) {
        this.context = context;
    }

    public void setHttpSession(HttpSession httpSession) {
        this.httpSession = httpSession;
    }

    public void setUseragent(String useragent) {
        this.useragent = useragent;
    }

    public void setXformsSessionKey(String xformsSessionKey) {
        this.xformsSessionKey = xformsSessionKey;
    }

    public UIGenerator createUIGenerator() throws URISyntaxException, XFormsException {
        String relativeUris = this.configuration.getProperty("forms.uri.relative");
        URI uri = this.getTransformURI();
        XSLTGenerator generator = WebFactory.setupTransformer(uri, this.getContext());
        if (relativeUris.equals("true")) {
            generator.setParameter("contextroot", ".");
        } else {
            generator.setParameter("contextroot", WebUtil.getContextRoot(this.request));
        }
        generator.setParameter("sessionKey", this.xformsSessionKey);
        generator.setParameter("action-url", this.getActionURL());
        generator.setParameter("debug-enabled", String.valueOf(this.configuration.getProperty("betterform.debug-allowed").equals("true")));
        generator.setParameter("unloadingMessage", this.configuration.getProperty("betterform.unloading-message"));
        generator.setParameter("baseURI", this.xformsProcessor.getBaseURI());
        generator.setParameter("user-agent", this.request.getHeader("User-Agent"));
        String triggerPrefix = Config.getInstance().getProperty("betterform.web.triggerPrefix");
        generator.setParameter("trigger-prefix", triggerPrefix);
        return generator;
    }

    private URI getTransformURI() throws XFormsException, URISyntaxException {
        String xslFile = this.request.getParameter(XSL_PARAM_NAME);
        String xsltPath = "WEB-INF/classes/META-INF/resources//xslt";
        if (xslFile != null) {
            return new File(WebFactory.getRealPath(xsltPath, this.getContext())).toURI().resolve(new URI(xslFile));
        }
        Element e = this.xformsProcessor.getXForms().getDocumentElement();
        if (e.hasAttributeNS("http://betterform.sourceforge.net/xforms", "transform")) {
            String transformValue = e.getAttributeNS("http://betterform.sourceforge.net/xforms", "transform");
            return new URI(WebUtil.getRequestURI(this.request) + transformValue);
        }
        String configuredTransform = this.configuration.getStylesheet(this.useragent);
        if (configuredTransform != null) {
            return new File(WebFactory.getRealPath(xsltPath, this.getContext())).toURI().resolve(new URI(configuredTransform));
        }
        throw new XFormsConfigException("There was no xslt stylesheet found on the request URI, the root element of the form or in the configfile");
    }

    private ServletContext getContext() {
        if (this.context != null) {
            return this.context;
        }
        return this.httpSession.getServletContext();
    }

    private String getActionURL() {
        String actionURL;
        String defaultActionURL = this.request.getRequestURI();
        String encodedDefaultActionURL = this.response.encodeURL(defaultActionURL);
        int sessIdx = encodedDefaultActionURL.indexOf(";jsession");
        String sessionId = null;
        if (sessIdx > -1) {
            sessionId = encodedDefaultActionURL.substring(sessIdx);
        }
        if (null == (actionURL = this.request.getParameter(ACTIONURL_PARAM_NAME))) {
            actionURL = encodedDefaultActionURL;
        } else if (null != sessionId) {
            actionURL = actionURL + sessionId;
        }
        actionURL = this.response.encodeURL(actionURL);
        return actionURL;
    }
}

