/*
 * Decompiled with CFR 0.152.
 */
package de.betterform.connector;

import de.betterform.connector.ConnectorFactory;
import de.betterform.connector.SubmissionHandler;
import de.betterform.connector.URIResolver;
import de.betterform.xml.config.Config;
import de.betterform.xml.xforms.exception.XFormsException;
import java.net.URI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Element;

public class DefaultConnectorFactory
extends ConnectorFactory {
    private static Log LOGGER = LogFactory.getLog(DefaultConnectorFactory.class);

    @Override
    public SubmissionHandler createSubmissionHandler(String uri, Element element) throws XFormsException {
        Object instance;
        URI uriObj = this.getAbsoluteURI(uri, element);
        String className = Config.getInstance().getSubmissionHandler(uriObj.getScheme());
        if (className == null) {
            throw new XFormsException("no submission handler registered for '" + uri + "'");
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("creating submission handler for '" + uriObj + "' : " + className));
        }
        if (!((instance = this.createInstance(className)) instanceof SubmissionHandler)) {
            throw new XFormsException("object instance of '" + className + "' is no submission handler");
        }
        SubmissionHandler submissionHandler = (SubmissionHandler)instance;
        submissionHandler.setURI(uriObj.toString());
        submissionHandler.setContext(this.getContext());
        return submissionHandler;
    }

    @Override
    public URIResolver createURIResolver(String uri, Element element) throws XFormsException {
        String className;
        URI uriObj = this.getAbsoluteURI(uri, element);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("creating uri resolver for '" + uriObj + "'"));
        }
        if ((className = Config.getInstance().getURIResolver(uriObj.getScheme())) == null) {
            throw new XFormsException("no uri resolver registered for '" + uri + "'");
        }
        Object instance = this.createInstance(className);
        if (!(instance instanceof URIResolver)) {
            throw new XFormsException("object instance of '" + className + "' is no uri resolver");
        }
        URIResolver uriResolver = (URIResolver)instance;
        uriResolver.setURI(uriObj.toString());
        uriResolver.setContext(this.getContext());
        return uriResolver;
    }

    private Object createInstance(String className) throws XFormsException {
        try {
            Class<?> clazz = Class.forName(className, true, DefaultConnectorFactory.class.getClassLoader());
            return clazz.newInstance();
        }
        catch (ClassNotFoundException cnfe) {
            throw new XFormsException(cnfe);
        }
        catch (InstantiationException ie) {
            throw new XFormsException(ie);
        }
        catch (IllegalAccessException iae) {
            throw new XFormsException(iae);
        }
    }
}

