/*
 * Decompiled with CFR 0.152.
 */
package de.betterform.connector;

import de.betterform.connector.AbstractConnector;
import de.betterform.connector.SubmissionHandler;
import de.betterform.xml.dom.DOMUtil;
import de.betterform.xml.xforms.exception.XFormsException;
import de.betterform.xml.xforms.model.Model;
import de.betterform.xml.xforms.model.submission.Submission;
import de.betterform.xml.xpath.impl.saxon.XPathCache;
import de.betterform.xml.xpath.impl.saxon.XPathUtil;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class ModelSubmissionHandler
extends AbstractConnector
implements SubmissionHandler {
    private static Log LOGGER = LogFactory.getLog(ModelSubmissionHandler.class);

    @Override
    public Map submit(Submission submission, Node instance) throws XFormsException {
        try {
            Model receiverModel;
            String replaceMode = submission.getReplace();
            if (!replaceMode.equals("none") && !replaceMode.equals("instance")) {
                throw new XFormsException("ModelSubmissionHandler only supports 'none' or 'instance' as replace mode");
            }
            String submissionMethod = submission.getMethod();
            String resourceAttr = this.getURI();
            String resourceModelId = null;
            String instanceId = null;
            String xpath = null;
            try {
                int devider = resourceAttr.indexOf("#");
                resourceModelId = resourceAttr.substring(resourceAttr.indexOf(":") + 1, devider);
                int instanceIdStart = resourceAttr.indexOf("(") + 1;
                int instanceIdEnd = resourceAttr.indexOf(")");
                instanceId = resourceAttr.substring(instanceIdStart + 1, instanceIdEnd - 1);
                if (resourceAttr.indexOf("/") == -1) {
                    throw new XFormsException("Syntax error: xpath mustn't be null. You've to provide at least the path to the rootnode.");
                }
                xpath = resourceAttr.substring(resourceAttr.indexOf("/"));
            }
            catch (IndexOutOfBoundsException e) {
                throw new XFormsException("Syntax error in expression: " + resourceAttr);
            }
            if (submissionMethod.equalsIgnoreCase("get")) {
                Model providerModel = submission.getContainerObject().getModel(resourceModelId);
                Model receiverModel2 = submission.getModel();
                Node targetNode = XPathUtil.getAsNode(XPathCache.getInstance().evaluate(providerModel.getInstance(instanceId).getRootContext().getNodeset(), 1, xpath, providerModel.getPrefixMapping(), providerModel.getXPathFunctionContext()), 1);
                if (targetNode == null) {
                    throw new XFormsException("targetNode for xpath: " + xpath + " not found");
                }
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug((Object)"targetNode to replace............");
                    DOMUtil.prettyPrintDOM(targetNode);
                }
                Document result = DOMUtil.newDocument(true, false);
                result.appendChild(result.importNode(targetNode.cloneNode(true), true));
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug((Object)"result Instance after insertion ............");
                    DOMUtil.prettyPrintDOM(result);
                }
                HashMap<String, Document> response = new HashMap<String, Document>(1);
                response.put("betterform.submission.response.document", result);
                return response;
            }
            if (submissionMethod.equalsIgnoreCase("post")) {
                Model providerModel = submission.getModel();
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug((Object)"Instance Data to post............");
                    DOMUtil.prettyPrintDOM(instance);
                }
                receiverModel = submission.getContainerObject().getModel(resourceModelId);
                Node targetNode = XPathUtil.getAsNode(XPathCache.getInstance().evaluate(receiverModel.getInstance(instanceId).getRootContext().getNodeset(), 1, xpath, receiverModel.getPrefixMapping(), receiverModel.getXPathFunctionContext()), 1);
                if (targetNode == null) {
                    throw new XFormsException("targetNode for xpath: " + xpath + " not found");
                }
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug((Object)"targetNode to replace............");
                    DOMUtil.prettyPrintDOM(targetNode);
                }
                if (instance instanceof Document) {
                    Document toImport = (Document)instance;
                    targetNode.getParentNode().replaceChild(targetNode.getOwnerDocument().importNode(toImport.getDocumentElement(), true), targetNode);
                }
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug((Object)"result Instance after insertion ............");
                    DOMUtil.prettyPrintDOM(receiverModel.getDefaultInstance().getInstanceDocument());
                }
            } else {
                throw new XFormsException("Submission method '" + submissionMethod + "' not supported");
            }
            receiverModel.rebuild();
            receiverModel.recalculate();
            receiverModel.revalidate();
            receiverModel.refresh();
            return new HashMap(1);
        }
        catch (Exception e) {
            throw new XFormsException(e);
        }
    }
}

