/*
 * Decompiled with CFR 0.152.
 */
package de.betterform.connector.ant;

import de.betterform.connector.AbstractConnector;
import de.betterform.connector.SubmissionHandler;
import de.betterform.xml.dom.DOMUtil;
import de.betterform.xml.xforms.exception.XFormsException;
import de.betterform.xml.xforms.model.submission.Submission;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.PrintStream;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.tools.ant.BuildListener;
import org.apache.tools.ant.DefaultLogger;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.ProjectHelper;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class AntSubmissionHandler
extends AbstractConnector
implements SubmissionHandler {
    private static Log LOGGER = LogFactory.getLog(AntSubmissionHandler.class);
    private String buildFile = "build.xml";

    @Override
    public Map submit(Submission submission, Node instance) throws XFormsException {
        LOGGER.debug((Object)"AntSubmissionHandler.submit()");
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        if (submission.getMethod().equals("get")) {
            try {
                String uri = this.getURI();
                ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
                ByteArrayOutputStream errorStream = new ByteArrayOutputStream();
                String buildFilePath = new URI(uri).getSchemeSpecificPart().substring(new URI(uri).getSchemeSpecificPart().indexOf(58) + 1);
                if ("".equals(buildFilePath)) {
                    throw new XFormsException("submission method '" + submission.getMethod() + "' at: " + DOMUtil.getCanonicalPath(submission.getElement()) + " not supported");
                }
                File buildFile = new File(buildFilePath);
                String target = null;
                target = uri.contains("#") ? uri.substring(uri.indexOf(35) + 1) : (((Document)instance).getElementsByTagName("target").item(0) != null ? ((Document)instance).getElementsByTagName("target").item(0).getTextContent() : "default");
                LOGGER.debug((Object)("AntSubmissionHandler.runTarget() BuildFile: " + buildFile.getAbsolutePath() + " with Target:" + target));
                this.runTarget(buildFile, target, outputStream, errorStream);
                DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
                factory.setNamespaceAware(true);
                factory.setValidating(false);
                Document document = factory.newDocumentBuilder().newDocument();
                document.appendChild(document.createElementNS(null, "ant"));
                Element rootElement = document.getDocumentElement();
                Attr filename = document.createAttribute("fileName");
                filename.setValue(buildFile.getName());
                rootElement.setAttributeNode(filename);
                Element element = document.createElement("buildFile");
                DOMUtil.setElementValue(element, buildFile.getAbsolutePath());
                rootElement.appendChild(element);
                element = document.createElement("target");
                DOMUtil.setElementValue(element, target);
                rootElement.appendChild(element);
                element = document.createElement("output-stream");
                DOMUtil.setElementValue(element, outputStream.toString());
                rootElement.appendChild(element);
                element = document.createElement("error-stream");
                DOMUtil.setElementValue(element, errorStream.toString());
                rootElement.appendChild(element);
                DOMUtil.prettyPrintDOM((Node)document, stream);
            }
            catch (Exception e) {
                throw new XFormsException(e);
            }
        } else {
            throw new XFormsException("submission method '" + submission.getMethod() + "' at: " + DOMUtil.getCanonicalPath(submission.getElement()) + " not supported");
        }
        HashMap<String, ByteArrayInputStream> response = new HashMap<String, ByteArrayInputStream>();
        response.put("betterform.submission.response.stream", new ByteArrayInputStream(stream.toByteArray()));
        return response;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void runTarget(File buildFile, String target, ByteArrayOutputStream outputStream, ByteArrayOutputStream errorStream) throws Exception {
        Project project = new Project();
        DefaultLogger consoleLogger = new DefaultLogger();
        project.addBuildListener((BuildListener)consoleLogger);
        consoleLogger.setErrorPrintStream(new PrintStream(errorStream));
        consoleLogger.setOutputPrintStream(new PrintStream(outputStream));
        consoleLogger.setMessageOutputLevel(2);
        project.setUserProperty("ant.file", buildFile.getAbsolutePath());
        project.init();
        ProjectHelper projectHelper = ProjectHelper.getProjectHelper();
        project.addReference("ant.projectHelper", (Object)projectHelper);
        projectHelper.parse(project, (Object)buildFile);
        if ("default".equals(target)) {
            String defaultTarget = project.getDefaultTarget();
            if (defaultTarget == null) throw new XFormsException("No target was given for Ant file and no default target is present on the build file");
            project.executeTarget(defaultTarget);
            return;
        } else {
            project.executeTarget(target);
        }
    }
}

