/*
 * Decompiled with CFR 0.152.
 */
package de.betterform.connector.context;

import de.betterform.connector.AbstractConnector;
import de.betterform.connector.SubmissionHandler;
import de.betterform.connector.context.ContextMapResolver;
import de.betterform.xml.dom.DOMUtil;
import de.betterform.xml.xforms.exception.XFormsException;
import de.betterform.xml.xforms.model.submission.Submission;
import java.util.HashMap;
import java.util.Map;
import javax.xml.transform.TransformerException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class ContextMapSubmissionHandler
extends AbstractConnector
implements SubmissionHandler {
    private static Log LOGGER = LogFactory.getLog(ContextMapSubmissionHandler.class);

    @Override
    public Map submit(Submission submission, Node instance) throws XFormsException {
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace((Object)"submitting instance...");
            DOMUtil.prettyPrintDOM(instance);
        }
        if (submission.getMethod().equalsIgnoreCase("get")) {
            if (submission.getReplace().equals("instance")) {
                String contextKey = ContextMapResolver.getContextKeyFormURI(this.getURI());
                Object xmlNode = ContextMapResolver.getNodeFromContext(contextKey, this.getContext());
                if (LOGGER.isTraceEnabled()) {
                    DOMUtil.prettyPrintDOM((Node)xmlNode);
                }
                HashMap<String, Object> response = new HashMap<String, Object>(1);
                response.put("betterform.submission.response.document", xmlNode);
                return response;
            }
            throw new XFormsException("submission replace mode '" + submission.getReplace() + "' not supported");
        }
        if (submission.getMethod().equalsIgnoreCase("put") || submission.getMethod().equalsIgnoreCase("post")) {
            if (submission.getReplace().equals("none")) {
                Document doc;
                String contextKey = ContextMapResolver.getContextKeyFormURI(this.getURI());
                if (contextKey == null) {
                    throw new XFormsException("key name missing");
                }
                if (instance instanceof Element) {
                    doc = DOMUtil.newDocument(true, false);
                    DOMUtil.importAndAppendNode(doc, instance);
                    if (LOGGER.isTraceEnabled()) {
                        LOGGER.trace((Object)"storing instance in context...");
                        DOMUtil.prettyPrintDOM(doc);
                    }
                } else if (instance instanceof Document) {
                    doc = DOMUtil.newDocument(true, false);
                    DOMUtil.importAndAppendNode(doc, ((Document)instance).getDocumentElement());
                } else {
                    throw new XFormsException("Node of type '" + instance.getNodeType() + " is not supported");
                }
                if (LOGGER.isTraceEnabled()) {
                    LOGGER.trace((Object)"storing instance in context...\n");
                    try {
                        DOMUtil.prettyPrintDOM((Node)doc, System.out);
                    }
                    catch (TransformerException e) {
                        e.printStackTrace();
                    }
                }
                this.getContext().put(contextKey, doc);
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug((Object)("storing node in context: " + contextKey + "='" + instance + "'"));
                }
            } else {
                throw new XFormsException("submission replace mode '" + submission.getReplace() + "' not supported");
            }
            return new HashMap();
        }
        throw new XFormsException("submission method '" + submission.getMethod() + "' not supported");
    }
}

