/*
 * Decompiled with CFR 0.152.
 */
package de.betterform.connector.exec;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;

public class ProcessExecutor {
    public int execute(File dir, String command, OutputStream output, OutputStream error) throws IOException, InterruptedException {
        Runtime runtime = Runtime.getRuntime();
        Process process = runtime.exec(this.getSystemCommand(command), null, dir);
        new StreamGobbler(process.getInputStream(), output).start();
        new StreamGobbler(process.getErrorStream(), error).start();
        return process.waitFor();
    }

    private String[] getSystemCommand(String command) {
        String osName = System.getProperty("os.name");
        if (osName.startsWith("Windows")) {
            return new String[]{"cmd.exe", "/C", command};
        }
        return new String[]{"/bin/sh", "-c", command};
    }

    public static int executeStatic(File dir, String command, OutputStream output, OutputStream error) throws IOException, InterruptedException {
        ProcessExecutor executor = new ProcessExecutor();
        return executor.execute(dir, command, output, error);
    }

    private class StreamGobbler
    extends Thread {
        private InputStream input;
        private OutputStream output;

        public StreamGobbler(InputStream input, OutputStream output) {
            this.input = input;
            this.output = output;
        }

        @Override
        public void run() {
            try {
                String line = null;
                BufferedReader reader = new BufferedReader(new InputStreamReader(this.input));
                PrintWriter writer = new PrintWriter(this.output);
                while ((line = reader.readLine()) != null) {
                    writer.println(line);
                }
                writer.flush();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

