/*
 * Decompiled with CFR 0.152.
 */
package de.betterform.connector.exist;

import de.betterform.connector.exist.ExistClientExecutable;
import de.betterform.xml.xforms.exception.XFormsException;
import java.net.URI;
import java.util.Map;
import org.exist.dom.persistent.DocumentImpl;
import org.exist.security.Subject;
import org.exist.storage.BrokerPool;
import org.exist.storage.DBBroker;
import org.exist.storage.txn.TransactionManager;
import org.exist.storage.txn.Txn;
import org.exist.xmldb.XmldbURI;

public class ExistClient {
    private static final String EXIST_USER_KEY = "_eXist_xmldb_user";

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public <T> T execute(String uri, int lock, Map<String, Object> context, ExistClientExecutable<T> exec) throws XFormsException {
        BrokerPool pool = null;
        DBBroker broker = null;
        Txn tx = null;
        TransactionManager txManager = null;
        DocumentImpl xmlResource = null;
        try {
            pool = BrokerPool.getInstance();
            Subject subject = this.getSubject(pool, context);
            broker = pool.get(subject);
            txManager = pool.getTransactionManager();
            if (null != uri) {
                URI dbURI = new URI(uri);
                XmldbURI docURI = XmldbURI.createInternal((String)dbURI.getRawPath());
                xmlResource = broker.getResource(docURI, lock);
            }
            try {
                tx = txManager.beginTransaction();
                exec.setClient(this);
                exec.setBrokerPool(pool);
                exec.setDBBroker(broker);
                exec.setUriString(uri);
                exec.setLock(lock);
                exec.setContext(context);
                T result = exec.execute(tx, pool, broker, xmlResource);
                txManager.commit(tx);
                T t = result;
                return t;
            }
            catch (Exception e) {
                if (null == txManager) throw new XFormsException(e);
                txManager.abort(tx);
                throw new XFormsException(e);
            }
            finally {
                if (null != pool) {
                    if (null != xmlResource) {
                        xmlResource.getUpdateLock().release(lock);
                    }
                    pool.release(broker);
                }
            }
        }
        catch (Exception e) {
            throw new XFormsException(e);
        }
    }

    private Subject getSubject(BrokerPool pool, Map context) {
        Subject subject = (Subject)context.get(EXIST_USER_KEY);
        if (null != subject) {
            return subject;
        }
        return pool.getSecurityManager().getGuestSubject();
    }
}

