/*
 * Decompiled with CFR 0.152.
 */
package de.betterform.connector.file;

import de.betterform.connector.AbstractConnector;
import de.betterform.connector.SubmissionHandler;
import de.betterform.connector.file.FileURIResolver;
import de.betterform.connector.serializer.SerializerRequestWrapper;
import de.betterform.xml.dom.DOMUtil;
import de.betterform.xml.xforms.exception.XFormsException;
import de.betterform.xml.xforms.model.submission.Submission;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class FileSubmissionHandler
extends AbstractConnector
implements SubmissionHandler {
    private static Log LOGGER = LogFactory.getLog(FileSubmissionHandler.class);

    @Override
    public Map submit(Submission submission, Node instance) throws XFormsException {
        if (submission.getMethod().equalsIgnoreCase("get")) {
            try {
                InputStream inputStream;
                File file;
                URI uri = new URI(this.getURI());
                String fileName = uri.getSchemeSpecificPart();
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug((Object)("getting file '" + fileName + "'"));
                }
                if ((file = new File(fileName)).isDirectory()) {
                    Document document = FileURIResolver.buildDirectoryListing(file);
                    ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
                    DOMUtil.prettyPrintDOM((Node)document, outputStream);
                    inputStream = new ByteArrayInputStream(outputStream.toByteArray());
                } else {
                    inputStream = new FileInputStream(new File(fileName));
                }
                HashMap<String, FileInputStream> response = new HashMap<String, FileInputStream>();
                response.put("betterform.submission.response.stream", (FileInputStream)inputStream);
                return response;
            }
            catch (Exception e) {
                throw new XFormsException(e);
            }
        }
        if (submission.getMethod().equalsIgnoreCase("put")) {
            if (!submission.getReplace().equals("none")) {
                throw new XFormsException("submission mode '" + submission.getReplace() + "' not supported");
            }
            try {
                URI uri = new URI(this.getURI());
                String fileName = uri.getSchemeSpecificPart();
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug((Object)("putting file '" + fileName + "'"));
                }
                FileOutputStream stream = new FileOutputStream(new File(fileName));
                SerializerRequestWrapper wrapper = new SerializerRequestWrapper(stream);
                this.serialize(submission, instance, wrapper);
                wrapper.getBodyStream().close();
            }
            catch (Exception e) {
                throw new XFormsException(e);
            }
            return new HashMap();
        }
        if (submission.getMethod().equalsIgnoreCase("delete")) {
            try {
                URI uri = new URI(this.getURI());
                String fileName = uri.getSchemeSpecificPart();
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug((Object)("getting file '" + fileName + "'"));
                }
                File file = new File(fileName);
                file.delete();
            }
            catch (Exception e) {
                throw new XFormsException(e);
            }
            return new HashMap();
        }
        throw new XFormsException("submission method '" + submission.getMethod() + "' not supported");
    }
}

