/*
 * Decompiled with CFR 0.152.
 */
package de.betterform.connector.http;

import de.betterform.connector.SubmissionHandler;
import de.betterform.connector.http.AbstractHTTPConnector;
import de.betterform.connector.serializer.SerializerRequestWrapper;
import de.betterform.connector.util.URIUtil;
import de.betterform.xml.xforms.exception.XFormsException;
import de.betterform.xml.xforms.model.submission.Submission;
import java.io.ByteArrayOutputStream;
import java.util.Map;
import java.util.StringTokenizer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Node;

public class HTTPSubmissionHandler
extends AbstractHTTPConnector
implements SubmissionHandler {
    private static Log LOGGER = LogFactory.getLog(HTTPSubmissionHandler.class);

    @Override
    public Map submit(Submission submission, Node instance) throws XFormsException {
        try {
            boolean streamNotEmpty;
            String method = submission.getMethod();
            String mediatype = "application/xml";
            if (submission.getMediatype() != null) {
                mediatype = submission.getMediatype();
            }
            String encoding = submission.getEncoding();
            if (submission.getEncoding() == null) {
                encoding = this.getDefaultEncoding();
            }
            SerializerRequestWrapper wrapper = new SerializerRequestWrapper(new ByteArrayOutputStream());
            this.serialize(submission, instance, wrapper);
            ByteArrayOutputStream stream = (ByteArrayOutputStream)wrapper.getBodyStream();
            boolean bl = streamNotEmpty = !"".equals(stream.toString());
            if (method.equals("post")) {
                if (streamNotEmpty) {
                    this.post(this.getURI(), stream.toString(encoding), mediatype, encoding);
                } else {
                    this.post(this.getURI(), mediatype, encoding);
                }
            } else if (method.equals("get")) {
                if (URIUtil.getURIWithoutFragment(this.getURI()).indexOf("?") == -1 && streamNotEmpty) {
                    this.get(URIUtil.getURIWithoutFragment(this.getURI()) + "?" + stream.toString(encoding));
                } else if (streamNotEmpty) {
                    this.get(URIUtil.getURIWithoutFragment(this.getURI()) + "&" + stream.toString(encoding));
                } else {
                    this.get(URIUtil.getURIWithoutFragment(this.getURI()));
                }
            } else if (method.equals("put")) {
                if (streamNotEmpty) {
                    this.put(this.getURI(), stream.toString(encoding), mediatype, encoding);
                } else {
                    this.put(this.getURI(), mediatype, encoding);
                }
            } else if (method.equals("multipart-post")) {
                if (streamNotEmpty) {
                    String data = stream.toString(encoding);
                    int i = data.indexOf("\n\n");
                    if (i == -1) {
                        i = data.indexOf("\r\n\r\n");
                        if (i == -1) {
                            throw new XFormsException("serializer sent wrong multipart content.");
                        }
                        i += 2;
                    }
                    String contentType = null;
                    StringTokenizer tok = new StringTokenizer(data.substring(0, i += 2).replaceAll("\r", "").replaceAll("\n ", " ").replaceAll("\n\t", " "));
                    while (tok.hasMoreTokens()) {
                        String name = tok.nextToken("\n");
                        if (!name.toLowerCase().startsWith("content-type:")) continue;
                        contentType = name.substring("content-type:".length());
                        break;
                    }
                    this.post(this.getURI(), data.substring(i), contentType, encoding);
                } else {
                    this.post(this.getURI(), "UTF8", encoding);
                }
            } else if (method.equals("form-data-post")) {
                if (streamNotEmpty) {
                    String type = "multipart/form-data";
                    String boundary = wrapper.getHeader("internal-boundary-mark");
                    if (!"".equals(boundary)) {
                        type = type + "; boundary=" + boundary;
                    }
                    this.post(this.getURI(), stream.toString(encoding), type, encoding);
                } else {
                    this.post(this.getURI(), "multipart/form-data", encoding);
                }
            } else if (method.equals("urlencoded-post")) {
                if (streamNotEmpty) {
                    this.post(this.getURI(), stream.toString(encoding), "application/x-www-form-urlencoded", encoding);
                } else {
                    this.post(this.getURI(), "application/x-www-form-urlencoded", encoding);
                }
            } else if (method.equals("delete")) {
                if (this.getURI().indexOf("?") == -1 && streamNotEmpty) {
                    this.delete(this.getURI() + "?" + stream.toString(encoding));
                } else if (streamNotEmpty) {
                    this.delete(this.getURI() + "&" + stream.toString(encoding));
                } else {
                    this.delete(this.getURI());
                }
            } else if (streamNotEmpty) {
                this.post(this.getURI(), stream.toString(encoding), mediatype, encoding);
            } else {
                this.post(this.getURI(), mediatype, encoding);
            }
            Map response = this.getResponseHeader();
            response.put("betterform.submission.response.stream", this.getResponseBody());
            response.put("response-status-code", String.valueOf(this.statusCode));
            response.put("response-reason-phrase", this.reasonPhrase);
            return response;
        }
        catch (Exception e) {
            throw new XFormsException(e);
        }
    }
}

