/*
 * Decompiled with CFR 0.152.
 */
package de.betterform.connector.http;

import de.betterform.connector.ConnectorFactory;
import de.betterform.connector.http.HTTPSubmissionHandler;
import de.betterform.generator.XSLTGenerator;
import de.betterform.xml.config.Config;
import de.betterform.xml.xforms.exception.XFormsException;
import de.betterform.xml.xforms.model.submission.Submission;
import de.betterform.xml.xslt.TransformerService;
import de.betterform.xml.xslt.impl.CachingTransformerService;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Node;

public class HTTPSubmissionHandlerXI
extends HTTPSubmissionHandler {
    private static Log LOGGER = LogFactory.getLog(HTTPSubmissionHandlerXI.class);

    @Override
    public Map submit(Submission submission, Node instance) throws XFormsException {
        Map result = super.submit(submission, instance);
        InputStream inputStream = (InputStream)result.get("betterform.submission.response.stream");
        if (submission.getReplace().equals("instance")) {
            String xsltPath = Config.getInstance().getProperty("resource.dir.name") + "xslt";
            CachingTransformerService transformerService = (CachingTransformerService)this.getContext().get(TransformerService.TRANSFORMER_SERVICE);
            URI webappRealpath = null;
            try {
                webappRealpath = new URI((String)this.getContext().get("webapp.realpath"));
            }
            catch (URISyntaxException e) {
                throw new XFormsException("URISyntaxException for getContext().get('webapp.realpath')", e);
            }
            String styleSheetURIPath = webappRealpath.getSchemeSpecificPart() + xsltPath;
            URI styleSheetUri = new File(styleSheetURIPath, "include.xsl").toURI();
            XSLTGenerator generator = new XSLTGenerator();
            generator.setTransformerService(transformerService);
            generator.setStylesheetURI(styleSheetUri);
            ConnectorFactory connectorFactory = submission.getContainerObject().getConnectorFactory();
            String baseURI = connectorFactory.getAbsoluteURI(this.getURI(), submission.getElement()).toString();
            String uri = baseURI.substring(0, baseURI.lastIndexOf("/") + 1);
            generator.setParameter("root", uri);
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            generator.setInput(inputStream);
            generator.setOutput(outputStream);
            generator.generate();
            inputStream = new ByteArrayInputStream(outputStream.toByteArray());
        }
        HashMap<String, InputStream> response = new HashMap<String, InputStream>();
        response.put("betterform.submission.response.stream", inputStream);
        return response;
    }
}

