/*
 * Decompiled with CFR 0.152.
 */
package de.betterform.connector.http;

import de.betterform.connector.URIResolver;
import de.betterform.connector.http.AbstractHTTPConnector;
import de.betterform.xml.dom.DOMUtil;
import de.betterform.xml.xforms.exception.XFormsException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.xml.sax.SAXException;

public class HTTPURIResolver
extends AbstractHTTPConnector
implements URIResolver {
    private static Log LOGGER = LogFactory.getLog(HTTPURIResolver.class);

    @Override
    public Object resolve() throws XFormsException {
        URI uri = null;
        try {
            uri = new URI(this.getURI());
        }
        catch (URISyntaxException e) {
            throw new XFormsException(e);
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("getting '" + uri + "'"));
        }
        this.get(this.getURIWithoutFragment());
        InputStream responseStream = this.getResponseBody();
        Map header = this.getResponseHeader();
        String contentType = (String)header.get("Content-Type");
        contentType = this.parseContentType(contentType);
        if ("text/plain".equalsIgnoreCase(contentType) || "text/html".equalsIgnoreCase(contentType)) {
            try {
                return this.inputStreamToString(responseStream);
            }
            catch (IOException e) {
                throw new XFormsException(e);
            }
        }
        if ("application/xml".equalsIgnoreCase(contentType) || "text/xml".equalsIgnoreCase(contentType) || "application/xhtml+xml".equalsIgnoreCase(contentType) || "application/xml+xslt".equalsIgnoreCase(contentType)) {
            try {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug((Object)"converting response stream to XML");
                }
                return this.buildDocument(uri, responseStream);
            }
            catch (Exception e) {
                throw new XFormsException(e);
            }
        }
        LOGGER.warn((Object)("WARN WARN WARN WARN WARN WARN WARN: Contenttype of response can not be handled. contentype:" + contentType));
        return null;
    }

    private Object buildDocument(URI uri, InputStream responseStream) throws SAXException, IOException, ParserConfigurationException, XFormsException {
        return DOMUtil.getFragment(uri, responseStream);
    }

    private String inputStreamToString(InputStream in) throws IOException {
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(in));
        StringBuilder stringBuilder = new StringBuilder();
        String line = null;
        while ((line = bufferedReader.readLine()) != null) {
            stringBuilder.append(line + "\n");
        }
        bufferedReader.close();
        return stringBuilder.toString();
    }

    private String parseContentType(String contentType) {
        int semicolonIndex;
        if (contentType != null && (semicolonIndex = contentType.indexOf(59)) > 0) {
            contentType = contentType.substring(0, semicolonIndex);
        }
        return contentType;
    }
}

