/*
 * Decompiled with CFR 0.152.
 */
package de.betterform.connector.http.ssl;

import de.betterform.connector.http.ssl.BetterFORMKeyStoreManager;
import de.betterform.connector.http.ssl.BetterFORMTrustManager;
import de.betterform.xml.config.Config;
import de.betterform.xml.config.XFormsConfigException;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.GeneralSecurityException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import org.apache.commons.httpclient.contrib.ssl.AuthSSLInitializationError;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class KeyStoreSSLContext {
    private static String keyStorePath = null;
    private static String keyStorePasswd = null;
    private SSLContext sslcontext = null;
    private static Log LOGGER = LogFactory.getLog(KeyStoreSSLContext.class);

    public KeyStoreSSLContext() {
        try {
            keyStorePath = Config.getInstance().getProperty("httpclient.ssl.keystore.path", null);
            keyStorePasswd = Config.getInstance().getProperty("httpclient.ssl.keystore.passwd", null);
        }
        catch (XFormsConfigException xfce) {
            LOGGER.warn((Object)xfce.getLocalizedMessage(), (Throwable)xfce);
        }
    }

    private URL getKeyStoreURL() throws AuthSSLInitializationError {
        if (keyStorePath != null) {
            File keystore = keyStorePath.startsWith(File.separator) ? new File(keyStorePath) : new File(System.getProperty("user.home") + File.separator + keyStorePath);
            try {
                return keystore.toURI().toURL();
            }
            catch (MalformedURLException murle) {
                LOGGER.error((Object)"Wrong Syntax in httpclient.ssl.keystore.path", (Throwable)murle);
                throw new AuthSSLInitializationError("Wrong Syntax in httpclient.ssl.keystore.path");
            }
        }
        throw new AuthSSLInitializationError("You must configure httpclient.ssl.keystore.path in betterform-config.xml!");
    }

    private String getKeyStorePasswd() throws AuthSSLInitializationError {
        if (keyStorePasswd != null) {
            return keyStorePasswd;
        }
        throw new AuthSSLInitializationError("You must configure httpclient.ssl.keystore.passwd in betterform-config.xml!");
    }

    private SSLContext createSSLContext() {
        try {
            TrustManager[] trustmanagers = null;
            KeyManager[] keyManagers = null;
            if (this.getKeyStoreURL() != null) {
                BetterFORMKeyStoreManager bfkm = new BetterFORMKeyStoreManager();
                bfkm.addCustomX509KeyManager(this.getKeyStoreURL(), this.getKeyStorePasswd());
                keyManagers = new KeyManager[]{bfkm};
                BetterFORMTrustManager trustManagers = new BetterFORMTrustManager();
                trustManagers.addCustomX509TrustManager(this.getKeyStoreURL(), this.getKeyStorePasswd());
                trustmanagers = trustManagers.getTrustManagers();
            }
            SSLContext sslcontext = SSLContext.getInstance("SSL");
            sslcontext.init(keyManagers, trustmanagers, null);
            return sslcontext;
        }
        catch (NoSuchAlgorithmException e) {
            LOGGER.error((Object)e.getMessage(), (Throwable)e);
            throw new AuthSSLInitializationError("Unsupported algorithm exception: " + e.getMessage());
        }
        catch (KeyStoreException e) {
            LOGGER.error((Object)e.getMessage(), (Throwable)e);
            throw new AuthSSLInitializationError("Keystore exception: " + e.getMessage());
        }
        catch (GeneralSecurityException e) {
            LOGGER.error((Object)e.getMessage(), (Throwable)e);
            throw new AuthSSLInitializationError("Key management exception: " + e.getMessage());
        }
        catch (IOException e) {
            LOGGER.error((Object)e.getMessage(), (Throwable)e);
            throw new AuthSSLInitializationError("I/O error reading keystore/truststore file: " + e.getMessage());
        }
    }

    public SSLContext getSSLContext() {
        if (this.sslcontext == null) {
            this.sslcontext = this.createSSLContext();
        }
        return this.sslcontext;
    }
}

