/*
 * Decompiled with CFR 0.152.
 */
package de.betterform.connector.serializer;

import de.betterform.connector.InstanceSerializer;
import de.betterform.connector.serializer.SerializerRequestWrapper;
import de.betterform.connector.serializer.XMLSerializer;
import de.betterform.xml.xforms.model.ModelItem;
import de.betterform.xml.xforms.model.submission.Submission;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.mail.BodyPart;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMultipart;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.binary.Hex;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class MultipartRelatedSerializer
implements InstanceSerializer {
    @Override
    public void serialize(Submission submission, Node node, SerializerRequestWrapper wrapper, String defaultEncoding) throws Exception {
        HashMap cache = new HashMap();
        MimeMultipart multipart = new MimeMultipart();
        MimeBodyPart part = new MimeBodyPart();
        multipart.addBodyPart((BodyPart)part);
        String encoding = defaultEncoding;
        if (submission.getEncoding() != null) {
            encoding = submission.getEncoding();
        }
        if (node.getNodeType() == 1 || node.getNodeType() == 9) {
            part.setText(new String(this.serializeXML(multipart, cache, submission, node, encoding), encoding), encoding);
        } else {
            part.setText(node.getTextContent());
        }
        part.setContentID("<instance.xml@start>");
        part.addHeader("Content-Type", "application/xml");
        part.addHeader("Content-Transfer-Encoding", "base64");
        part.setDisposition("attachment");
        part.setFileName("instance.xml");
        multipart.setSubType("related; type=\"" + submission.getMediatype() + "\"; start=\"instance.xml@start\"");
        wrapper.getBodyStream().write(("Content-Type: " + multipart.getContentType() + "\n\nThis is a MIME message.\n").getBytes(encoding));
        multipart.writeTo(wrapper.getBodyStream());
    }

    protected byte[] serializeXML(MimeMultipart multipart, Map cache, Submission submission, Node instance, String encoding) throws Exception {
        if (instance instanceof Document) {
            this.visitNode(cache, ((Document)instance).getDocumentElement(), multipart);
        } else {
            this.visitNode(cache, instance, multipart);
        }
        SerializerRequestWrapper wrapper = new SerializerRequestWrapper(new ByteArrayOutputStream());
        XMLSerializer serializer = new XMLSerializer();
        serializer.serialize(submission, instance, wrapper, encoding);
        ByteArrayOutputStream stream = (ByteArrayOutputStream)wrapper.getBodyStream();
        return stream.toByteArray();
    }

    protected void visitNode(Map cache, Node node, MimeMultipart multipart) throws Exception {
        ModelItem item = (ModelItem)node.getUserData("");
        if (item != null && item.getDeclarationView().getDatatype() != null && item.getDeclarationView().getDatatype().equalsIgnoreCase("anyURI")) {
            String name = item.getFilename();
            if (name == null || item.getValue() == null || item.getValue().equals("")) {
                return;
            }
            String cid = (String)cache.get(name);
            if (cid == null) {
                int count = multipart.getCount();
                cid = name + "@part" + (count + 1);
                MimeBodyPart part = new MimeBodyPart();
                part.setContentID("<" + cid + ">");
                DataHandler dh = new DataHandler((DataSource)new ModelItemDataSource(item));
                part.setDataHandler(dh);
                part.addHeader("Content-Type", item.getMediatype());
                part.addHeader("Content-Transfer-Encoding", "base64");
                part.setDisposition("attachment");
                part.setFileName(name);
                multipart.addBodyPart((BodyPart)part);
                cache.put(name, cid);
            }
            Element element = (Element)node;
            NodeList list = node.getChildNodes();
            for (int i = 0; i < list.getLength(); ++i) {
                Node n = list.item(i);
                if (n.getNodeType() != 3) continue;
                n.setNodeValue("cid:" + cid);
                break;
            }
        } else {
            NodeList list = node.getChildNodes();
            for (int i = 0; i < list.getLength(); ++i) {
                Node n = list.item(i);
                if (n.getNodeType() != 1) continue;
                this.visitNode(cache, n, multipart);
            }
        }
    }

    private class ModelItemDataSource
    implements DataSource {
        private ModelItem item;

        ModelItemDataSource(ModelItem item) {
            this.item = item;
        }

        public String getContentType() {
            String type = this.item.getMediatype();
            if (type == null) {
                type = "application/octet-stream";
            }
            return type;
        }

        public String getName() {
            return this.item.getFilename();
        }

        public InputStream getInputStream() throws IOException {
            byte[] data;
            block5: {
                data = null;
                try {
                    if (this.item.getDeclarationView().getDatatype().equals("anyURI")) {
                        URL url = new URL(this.item.getValue());
                        return url.openStream();
                    }
                    if (this.item.getDeclarationView().getDatatype().equals("base64Binary")) {
                        data = Base64.decodeBase64((byte[])this.item.getValue().getBytes());
                        break block5;
                    }
                    if (this.item.getDeclarationView().getDatatype().equals("hexBinary")) {
                        data = Hex.decodeHex((char[])this.item.getValue().toCharArray());
                        break block5;
                    }
                    throw new IOException("unsupported data type");
                }
                catch (Exception e) {
                    throw new IOException(e.getMessage());
                }
            }
            return new ByteArrayInputStream(data);
        }

        public OutputStream getOutputStream() throws IOException {
            throw new IOException("unsupported operation.");
        }
    }
}

