/*
 * Decompiled with CFR 0.152.
 */
package de.betterform.connector.serializer;

import de.betterform.connector.InstanceSerializer;
import de.betterform.connector.serializer.SerializerRequestWrapper;
import de.betterform.xml.xforms.model.submission.Submission;
import java.util.ArrayList;
import java.util.List;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class XMLSerializer
implements InstanceSerializer {
    @Override
    public void serialize(Submission submission, Node instance, SerializerRequestWrapper wrapper, String defaultEncoding) throws Exception {
        if (instance.getNodeType() == 1 || instance.getNodeType() == 9) {
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            transformer.setOutputProperty("method", "xml");
            if (submission.getVersion() != null) {
                transformer.setOutputProperty("version", submission.getVersion());
            }
            if (submission.getIndent() != null) {
                transformer.setOutputProperty("indent", Boolean.TRUE.equals(submission.getIndent()) ? "yes" : "no");
            }
            if (submission.getIncludeNamespacePrefixes() != null) {
                Element rootElem = (Element)instance.getFirstChild();
                NamedNodeMap attrs = rootElem.getAttributes();
                List<String> includedNamesspace = submission.getIncludeNamespacePrefixes();
                ArrayList<Attr> removeAttributes = new ArrayList<Attr>();
                if (attrs != null) {
                    int attrlength = attrs.getLength();
                    for (int c = 0; c < attrlength; ++c) {
                        Node attr = attrs.item(c);
                        if (!"http://www.w3.org/2000/xmlns/".equals(attr.getNamespaceURI()) || includedNamesspace.contains(attr.getLocalName())) continue;
                        removeAttributes.add((Attr)attr);
                    }
                }
                for (Attr attribute : removeAttributes) {
                    rootElem.removeAttributeNode(attribute);
                }
                instance.replaceChild(instance.getFirstChild(), rootElem);
            }
            if (submission.getMediatype() != null) {
                transformer.setOutputProperty("media-type", submission.getMediatype());
            }
            if (submission.getEncoding() != null) {
                transformer.setOutputProperty("encoding", submission.getEncoding());
            } else {
                transformer.setOutputProperty("encoding", defaultEncoding);
            }
            if (submission.getOmitXMLDeclaration() != null) {
                transformer.setOutputProperty("omit-xml-declaration", submission.getOmitXMLDeclaration() != false ? "yes" : "no");
            }
            if (submission.getStandalone() != null) {
                transformer.setOutputProperty("standalone", Boolean.TRUE.equals(submission.getStandalone()) ? "yes" : "no");
            }
            if (submission.getCDATASectionElements() != null) {
                transformer.setOutputProperty("cdata-section-elements", submission.getCDATASectionElements());
            }
            transformer.transform(new DOMSource(instance), new StreamResult(wrapper.getBodyStream()));
        } else {
            wrapper.getBodyStream().write(instance.getTextContent().getBytes(defaultEncoding));
        }
    }
}

