/*
 * Decompiled with CFR 0.152.
 */
package de.betterform.connector.xmlrpc;

import de.betterform.connector.AbstractConnector;
import de.betterform.connector.URIResolver;
import de.betterform.connector.xmlrpc.RPCClient;
import de.betterform.xml.xforms.exception.XFormsException;
import java.net.URI;
import java.util.Hashtable;
import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Document;

public class XMLRPCURIResolver
extends AbstractConnector
implements URIResolver {
    private static final Log log = LogFactory.getLog(XMLRPCURIResolver.class);

    @Override
    public Object resolve() throws XFormsException {
        try {
            URI uri = new URI(this.getURI());
            log.info((Object)("Getting URI: '" + uri + "'"));
            Vector v = this.parseURI(uri);
            String rpcURL = (String)v.get(0);
            String function = (String)v.get(1);
            Hashtable params = (Hashtable)v.get(2);
            RPCClient rpc = new RPCClient(rpcURL);
            Document document = rpc.getDocument(function, params);
            if (uri.getFragment() != null) {
                return document.getElementById(uri.getFragment());
            }
            return document;
        }
        catch (Exception e) {
            throw new XFormsException(e);
        }
    }

    private Vector parseURI(URI uri) {
        String host = uri.getHost();
        int port = uri.getPort();
        String path = uri.getPath();
        String query = uri.getQuery();
        int finalSlash = path.lastIndexOf(47);
        String basePath = "";
        if (finalSlash > 0) {
            basePath = path.substring(1, finalSlash);
        }
        String function = path.substring(finalSlash + 1, path.length());
        String rpcURL = "http://" + host + ":" + port + "/" + basePath;
        log.debug((Object)("New URL  = " + rpcURL));
        log.debug((Object)("Function = " + function));
        Hashtable<String, String> paramHash = new Hashtable<String, String>();
        if (query != null) {
            String[] params = query.split("&");
            for (int i = 0; i < params.length; ++i) {
                log.debug((Object)("params[" + i + "] = " + params[i]));
                String[] keyval = params[i].split("=");
                log.debug((Object)("\t" + keyval[0] + " -> " + keyval[1]));
                paramHash.put(keyval[0], keyval[1]);
            }
        }
        Vector<Object> ret = new Vector<Object>();
        ret.add(rpcURL);
        ret.add(function);
        ret.add(paramHash);
        return ret;
    }
}

