/*
 * Decompiled with CFR 0.152.
 */
package de.betterform.connector.xslt;

import de.betterform.connector.AbstractConnector;
import de.betterform.connector.ConnectorHelper;
import de.betterform.connector.SubmissionHandler;
import de.betterform.xml.dom.DOMUtil;
import de.betterform.xml.xforms.exception.XFormsException;
import de.betterform.xml.xforms.model.submission.Submission;
import de.betterform.xml.xslt.TransformerService;
import de.betterform.xml.xslt.impl.CachingTransformerService;
import de.betterform.xml.xslt.impl.FileResourceResolver;
import de.betterform.xml.xslt.impl.HttpResourceResolver;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import javax.xml.transform.Transformer;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Node;

public class XSLTSubmissionHandler
extends AbstractConnector
implements SubmissionHandler {
    private static final Log LOGGER = LogFactory.getLog(XSLTSubmissionHandler.class);

    @Override
    public Map submit(Submission submission, Node instance) throws XFormsException {
        try {
            DOMSource domSource;
            CachingTransformerService transformerService;
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("uri: " + this.getURI()));
            }
            URI uri = ConnectorHelper.resolve(submission.getContainerObject().getProcessor().getBaseURI(), this.getURI());
            Map parameters = ConnectorHelper.getURLParameters(uri);
            URI stylesheetURI = ConnectorHelper.removeURLParameters(uri);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("stylesheet uri: " + stylesheetURI));
            }
            if ((transformerService = (CachingTransformerService)this.getContext().get(TransformerService.TRANSFORMER_SERVICE)) == null) {
                if (uri.getScheme().equals("http")) {
                    transformerService = new CachingTransformerService(new HttpResourceResolver());
                } else if (uri.getScheme().equals("file")) {
                    transformerService = new CachingTransformerService(new FileResourceResolver());
                } else {
                    throw new XFormsException("Protocol " + stylesheetURI.getScheme() + " not supported for XSLT Submission Handler");
                }
            }
            if (parameters != null && parameters.get("nocache") != null) {
                transformerService.setNoCache(true);
            }
            Transformer transformer = transformerService.getTransformer(stylesheetURI);
            if (submission.getVersion() != null) {
                transformer.setOutputProperty("version", submission.getVersion());
            }
            if (submission.getIndent() != null) {
                transformer.setOutputProperty("indent", Boolean.TRUE.equals(submission.getIndent()) ? "yes" : "no");
            }
            if (submission.getMediatype() != null) {
                transformer.setOutputProperty("media-type", submission.getMediatype());
            }
            if (submission.getEncoding() != null) {
                transformer.setOutputProperty("encoding", submission.getEncoding());
            } else {
                transformer.setOutputProperty("encoding", "UTF-8");
            }
            if (submission.getOmitXMLDeclaration() != null) {
                transformer.setOutputProperty("omit-xml-declaration", Boolean.TRUE.equals(submission.getOmitXMLDeclaration()) ? "yes" : "no");
            }
            if (submission.getStandalone() != null) {
                transformer.setOutputProperty("standalone", Boolean.TRUE.equals(submission.getStandalone()) ? "yes" : "no");
            }
            if (submission.getCDATASectionElements() != null) {
                transformer.setOutputProperty("cdata-section-elements", submission.getCDATASectionElements());
            }
            if (parameters != null) {
                for (String name : parameters.keySet()) {
                    transformer.setParameter(name, parameters.get(name));
                }
            }
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            long start = System.currentTimeMillis();
            String parseParam = null;
            if (parameters.containsKey("parseString")) {
                parseParam = (String)parameters.get("parseString");
            }
            if (parseParam != null && parseParam.equalsIgnoreCase("true")) {
                String xmlString = DOMUtil.getTextNodeAsString(instance);
                domSource = new DOMSource(DOMUtil.parseString(xmlString, true, false));
            } else {
                domSource = new DOMSource(instance);
            }
            transformer.transform(domSource, new StreamResult(outputStream));
            long end = System.currentTimeMillis();
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("transformation time: " + (end - start) + " ms"));
            }
            ByteArrayInputStream inputStream = new ByteArrayInputStream(outputStream.toByteArray());
            HashMap<String, ByteArrayInputStream> response = new HashMap<String, ByteArrayInputStream>();
            response.put("betterform.submission.response.stream", inputStream);
            return response;
        }
        catch (Exception e) {
            throw new XFormsException(e);
        }
    }
}

