/*
 * Decompiled with CFR 0.152.
 */
package de.betterform.session;

import de.betterform.generator.XSLTGenerator;
import de.betterform.xml.dom.DOMUtil;
import de.betterform.xml.xforms.XFormsProcessorImpl;
import de.betterform.xml.xforms.exception.XFormsException;
import de.betterform.xml.xforms.model.Instance;
import de.betterform.xml.xforms.model.Model;
import de.betterform.xml.xpath.impl.saxon.XPathCache;
import de.betterform.xml.xpath.impl.saxon.XPathUtil;
import de.betterform.xml.xslt.impl.CachingTransformerService;
import de.betterform.xml.xslt.impl.FileResourceResolver;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collections;
import java.util.List;
import javax.xml.transform.TransformerException;
import net.sf.saxon.dom.DOMNodeWrapper;
import net.sf.saxon.dom.DocumentWrapper;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.sxpath.IndependentContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class DefaultSerializer {
    protected static Log LOGGER = LogFactory.getLog(DefaultSerializer.class);
    private XFormsProcessorImpl processor;

    public DefaultSerializer(XFormsProcessorImpl processor) {
        this.processor = processor;
    }

    public Document serialize() throws IOException {
        Document result;
        try {
            result = this.serializeHostDocument();
        }
        catch (XFormsException e) {
            throw new IOException("Error while serializing host document: " + e.getMessage());
        }
        catch (TransformerException e) {
            throw new IOException("Error while transforming host document: " + e.getMessage());
        }
        catch (URISyntaxException e) {
            throw new IOException("Invalid URI: " + e.getMessage());
        }
        return result;
    }

    private Document serializeHostDocument() throws XFormsException, TransformerException, URISyntaxException {
        Document in = this.processor.getXForms();
        Document out = DOMUtil.newDocument(true, false);
        this.resetForm(in, out);
        this.inlineInstances(out);
        LOGGER.debug((Object)"##### resetted XForms #####");
        return out;
    }

    public void inlineInstances(Document out) throws XFormsException {
        DOMNodeWrapper context = DefaultSerializer.getDocumentElementContext(out);
        List models = this.processor.getContainer().getModels();
        for (int i = 0; i < models.size(); ++i) {
            Model model = (Model)models.get(i);
            List instances = model.getInstances();
            for (int j = 0; j < instances.size(); ++j) {
                Instance instance = (Instance)instances.get(j);
                String id = instance.getId();
                String search = "//*[@id='" + id + "']";
                Node outInstance = XPathUtil.getAsNode(XPathCache.getInstance().evaluate((NodeInfo)context, search, Collections.EMPTY_MAP, null), 1);
                Node imported = out.adoptNode(instance.getInstanceDocument().getDocumentElement());
                if (imported == null) {
                    throw new XFormsException("Root Element for Instance '" + instance.getId() + "' not found");
                }
                Element firstChild = DOMUtil.getFirstChildElement(outInstance);
                if (firstChild != null) {
                    outInstance.removeChild(firstChild);
                }
                outInstance.appendChild(imported);
            }
        }
    }

    private void resetForm(Document in, Document out) throws TransformerException, URISyntaxException, XFormsException {
        CachingTransformerService transformerService = new CachingTransformerService(new FileResourceResolver());
        String path = this.getClass().getResource("reset.xsl").getPath();
        String xslFilePath = "file:" + path;
        transformerService.getTransformer(new URI(xslFilePath));
        XSLTGenerator generator = new XSLTGenerator();
        generator.setTransformerService(transformerService);
        generator.setStylesheetURI(new URI(xslFilePath));
        generator.setInput(in);
        generator.setOutput(out);
        generator.generate();
    }

    private static DOMNodeWrapper getDocumentElementContext(Document document) {
        return new DocumentWrapper((Node)document, "configuration.xml", new IndependentContext().getConfiguration()).wrap((Node)document.getDocumentElement());
    }
}

