/*
 * Decompiled with CFR 0.152.
 */
package de.betterform.xml.config;

import de.betterform.connector.InstanceSerializerMap;
import de.betterform.xml.config.DefaultConfig;
import de.betterform.xml.config.XFormsConfigException;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class Config {
    private static Config SINGLETON;
    private static final String DEFAULT_XML_FILE = "default.xml";
    protected static Log LOGGER;
    protected HashMap properties;
    protected Map generators;
    protected HashMap submissionHandlers;
    protected HashMap uriResolvers;
    protected HashMap errorMessages;
    protected HashMap extensionFunctions;
    protected HashMap customElements;
    protected String connectorFactory;
    protected InstanceSerializerMap instanceSerializerMap;

    protected Config() throws XFormsConfigException {
    }

    private static void initSingleton(InputStream stream) throws XFormsConfigException {
        String configClassName = System.getProperty(Config.class.getName(), DefaultConfig.class.getName());
        try {
            Class<?> classRef = Class.forName(configClassName, true, Config.class.getClassLoader());
            Constructor<?> construct = classRef.getConstructor(InputStream.class);
            SINGLETON = (Config)construct.newInstance(stream);
        }
        catch (Exception e) {
            throw new XFormsConfigException(e);
        }
    }

    public static synchronized Config getInstance() throws XFormsConfigException {
        if (SINGLETON == null) {
            LOGGER.info((Object)"loading config from default.xml");
            Config.initSingleton(Config.class.getResourceAsStream(DEFAULT_XML_FILE));
        }
        return SINGLETON;
    }

    public static synchronized Config getInstance(String file) throws XFormsConfigException {
        LOGGER.info((Object)((SINGLETON == null ? "loading" : "reloading") + " config from " + file));
        try {
            Config.initSingleton(new FileInputStream(file));
        }
        catch (FileNotFoundException e) {
            throw new XFormsConfigException(e);
        }
        return SINGLETON;
    }

    public static synchronized Config getInstance(InputStream inputStream) throws XFormsConfigException {
        LOGGER.info((Object)((SINGLETON == null ? "loading" : "reloading") + " config from an InputStream"));
        Config.initSingleton(inputStream);
        return SINGLETON;
    }

    public static synchronized void unloadConfig() {
        SINGLETON = null;
    }

    public String getProperty(String key) {
        return this.getProperty(key, null);
    }

    public String getProperty(String key, String value) {
        String s = (String)this.properties.get(key);
        return s != null ? s : value;
    }

    public String getStylesheet(String key) {
        return (String)this.generators.get(key);
    }

    public String getSubmissionHandler(String key) {
        return (String)this.submissionHandlers.get(key);
    }

    public String getURIResolver(String key) {
        return (String)this.uriResolvers.get(key);
    }

    public String getErrorMessage(String key) {
        if (this.errorMessages.containsKey(key)) {
            return (String)this.errorMessages.get(key);
        }
        return (String)this.errorMessages.get("default");
    }

    public Map getCustomElements() {
        return Collections.unmodifiableMap(this.customElements);
    }

    public InstanceSerializerMap getInstanceSerializerMap() {
        return this.instanceSerializerMap;
    }

    public String getConnectorFactory() {
        return this.connectorFactory;
    }

    static {
        LOGGER = LogFactory.getLog(Config.class);
    }
}

