/*
 * Decompiled with CFR 0.152.
 */
package de.betterform.xml.dom;

import de.betterform.xml.dom.DOMUtil;
import de.betterform.xml.dom.DOMWhitespace;
import java.util.Iterator;
import java.util.List;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DOMComparator {
    private boolean ignoreComments = false;
    private boolean ignoreNamespaceDeclarations = false;
    private boolean ignoreWhitespace = true;
    private boolean namespaceAware = true;
    private ErrorHandler errorHandler = new DefaultErrorHandler();

    public void setIgnoreComments(boolean state) {
        this.ignoreComments = state;
    }

    public void setIgnoreNamespaceDeclarations(boolean state) {
        this.ignoreNamespaceDeclarations = state;
    }

    public void setIgnoreWhitespace(boolean state) {
        this.ignoreWhitespace = state;
    }

    public void setNamespaceAware(boolean state) {
        this.namespaceAware = state;
    }

    public void setErrorHandler(ErrorHandler errorHandler) {
        this.errorHandler = errorHandler;
        if (this.errorHandler == null) {
            this.errorHandler = new DefaultErrorHandler();
        }
    }

    public boolean compare(Node left, Node right) {
        if (left == right) {
            return true;
        }
        if (left == null || right == null) {
            this.errorHandler.handleError("a node is null", null, left, right);
            return false;
        }
        if (left.getNodeType() != right.getNodeType()) {
            this.errorHandler.handleError("different node types", left.getNodeType() + " vs. " + right.getNodeType(), left, right);
            return false;
        }
        if (this.namespaceAware && (left.getNodeType() == 2 || left.getNodeType() == 1)) {
            if (!this.compare(left.getNamespaceURI(), right.getNamespaceURI())) {
                this.errorHandler.handleError("different namespaces", left.getNamespaceURI() + " vs. " + right.getNamespaceURI(), left, right);
                return false;
            }
            if (left.getNamespaceURI() != null) {
                if (!this.compare(left.getLocalName(), right.getLocalName())) {
                    this.errorHandler.handleError("different local names", left.getLocalName() + " vs. " + right.getLocalName(), left, right);
                    return false;
                }
            } else if (!this.compare(left.getNodeName(), right.getNodeName())) {
                this.errorHandler.handleError("different node names", left.getNodeName() + " vs. " + right.getNodeName(), left, right);
                return false;
            }
        } else if (!this.compare(left.getNodeName(), right.getNodeName())) {
            this.errorHandler.handleError("different node names", left.getNodeName() + " vs. " + right.getNodeName(), left, right);
            return false;
        }
        if (!this.compare(left.getNodeValue(), right.getNodeValue())) {
            this.errorHandler.handleError("different node values", left.getNodeValue() + " vs. " + right.getNodeValue(), left, right);
            return false;
        }
        if (!this.compare(left.getAttributes(), right.getAttributes())) {
            this.errorHandler.handleError("different node attributes", null, left, right);
            return false;
        }
        if (!this.compare(left.getChildNodes(), right.getChildNodes())) {
            this.errorHandler.handleError("different node children", null, left, right);
            return false;
        }
        return true;
    }

    protected boolean compare(NodeList left, NodeList right) {
        if (left == right) {
            return true;
        }
        if (left == null || right == null) {
            return false;
        }
        if (!this.ignoreComments && !this.ignoreWhitespace && left.getLength() != right.getLength()) {
            return false;
        }
        int leftIndex = this.getNextIndex(left, 0);
        int rightIndex = this.getNextIndex(right, 0);
        while (leftIndex < left.getLength() || rightIndex < right.getLength()) {
            if (!this.compare(left.item(leftIndex), right.item(rightIndex))) {
                return false;
            }
            leftIndex = this.getNextIndex(left, leftIndex + 1);
            rightIndex = this.getNextIndex(right, rightIndex + 1);
        }
        return true;
    }

    protected boolean compare(NamedNodeMap left, NamedNodeMap right) {
        if (left == right) {
            return true;
        }
        if (left == null || right == null) {
            return false;
        }
        if (this.getRealLength(left) != this.getRealLength(right)) {
            return false;
        }
        if (this.namespaceAware) {
            int index = this.getNextIndex(left, 0);
            Node item = null;
            while (index < left.getLength()) {
                item = left.item(index);
                if (item.getNamespaceURI() != null ? !this.compare(item, right.getNamedItemNS(item.getNamespaceURI(), item.getLocalName())) : !this.compare(item, right.getNamedItem(item.getNodeName()))) {
                    return false;
                }
                index = this.getNextIndex(left, index + 1);
            }
            return true;
        }
        for (int index = 0; index < left.getLength(); ++index) {
            if (this.compare(left.item(index), right.getNamedItem(left.item(index).getNodeName()))) continue;
            return false;
        }
        return true;
    }

    protected final boolean compare(String left, String right) {
        if (left == right) {
            return true;
        }
        if (left == null || right == null) {
            return false;
        }
        return left.equals(right);
    }

    private int getNextIndex(NodeList list, int start) {
        if (this.ignoreComments && this.ignoreWhitespace) {
            return DOMWhitespace.skipWhitespaceAndComments(list, start);
        }
        if (this.ignoreWhitespace) {
            return DOMWhitespace.skipWhitespace(list, start);
        }
        if (this.ignoreComments) {
            return DOMWhitespace.skipComments(list, start);
        }
        return start;
    }

    private int getNextIndex(NamedNodeMap map, int start) {
        if (this.namespaceAware && this.ignoreNamespaceDeclarations) {
            for (int index = start; index < map.getLength(); ++index) {
                if ("http://www.w3.org/2000/xmlns/".equals(map.item(index).getNamespaceURI())) continue;
                return index;
            }
            return map.getLength();
        }
        return start;
    }

    private int getRealLength(NamedNodeMap map) {
        if (this.namespaceAware && this.ignoreNamespaceDeclarations) {
            int difference = 0;
            for (int index = 0; index < map.getLength(); ++index) {
                if (!"http://www.w3.org/2000/xmlns/".equals(map.item(index).getNamespaceURI())) continue;
                ++difference;
            }
            return map.getLength() - difference;
        }
        return map.getLength();
    }

    public boolean compareSkeleton(Element skeleton, Element dataNode) {
        if (skeleton == dataNode) {
            return true;
        }
        if (skeleton == null || dataNode == null) {
            this.errorHandler.handleError("a node is null", null, skeleton, dataNode);
            return false;
        }
        if (skeleton.getNodeType() != dataNode.getNodeType()) {
            this.errorHandler.handleError("different node types", skeleton.getNodeType() + " vs. " + dataNode.getNodeType(), skeleton, dataNode);
            return false;
        }
        if (this.namespaceAware && (skeleton.getNodeType() == 2 || skeleton.getNodeType() == 1)) {
            if (!this.compare(skeleton.getNamespaceURI(), dataNode.getNamespaceURI())) {
                this.errorHandler.handleError("different namespaces", skeleton.getNamespaceURI() + " vs. " + dataNode.getNamespaceURI(), skeleton, dataNode);
                return false;
            }
            if (skeleton.getNamespaceURI() != null) {
                if (!this.compare(skeleton.getLocalName(), dataNode.getLocalName())) {
                    this.errorHandler.handleError("different local names", skeleton.getLocalName() + " vs. " + dataNode.getLocalName(), skeleton, dataNode);
                    return false;
                }
            } else if (!this.compare(skeleton.getNodeName(), dataNode.getNodeName())) {
                this.errorHandler.handleError("different node names", skeleton.getNodeName() + " vs. " + dataNode.getNodeName(), skeleton, dataNode);
                return false;
            }
        } else if (!this.compare(skeleton.getNodeName(), dataNode.getNodeName())) {
            this.errorHandler.handleError("different node names", skeleton.getNodeName() + " vs. " + dataNode.getNodeName(), skeleton, dataNode);
            return false;
        }
        if (skeleton.hasChildNodes()) {
            List skeletonChilds = DOMUtil.getChildElements(skeleton);
            List dataChilds = DOMUtil.getChildElements(dataNode);
            Iterator dataChildsElements = dataChilds.iterator();
            for (Element skeletonChildElement : skeletonChilds) {
                Element dataChildElement;
                if (this.compareSkeleton(skeletonChildElement, dataChildElement = (Element)dataChildsElements.next()) || skeletonChildElement.getNodeType() == 3) continue;
                return false;
            }
        }
        return true;
    }

    public static class SystemErrorHandler
    implements ErrorHandler {
        @Override
        public void handleError(String error, String detail, Node left, Node right) {
            StringBuffer buffer = new StringBuffer();
            buffer.append(error);
            if (detail != null) {
                buffer.append(" [");
                buffer.append(detail);
                buffer.append("]");
            }
            buffer.append(": left='");
            buffer.append(left == null ? "#null" : left.getNodeName());
            buffer.append("' right='");
            buffer.append(right == null ? "#null" : right.getNodeName());
            buffer.append("'");
            System.err.println(buffer);
        }
    }

    public static class DefaultErrorHandler
    implements ErrorHandler {
        @Override
        public void handleError(String error, String detail, Node left, Node right) {
        }
    }

    public static interface ErrorHandler {
        public void handleError(String var1, String var2, Node var3, Node var4);
    }
}

