/*
 * Decompiled with CFR 0.152.
 */
package de.betterform.xml.ns;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class NamespaceResolver {
    public static void init(Element root) {
        if (root.getUserData(NamespaceResolver.class.getName()) != null) {
            return;
        }
        NamespaceResolver.init(root, Collections.EMPTY_MAP);
    }

    public static Map getAllNamespaces(Element context) {
        Object nsPrefixMapping = context.getUserData(NamespaceResolver.class.getName());
        if (nsPrefixMapping == null) {
            Map parentNsPrefixMap = null;
            for (Node n = context.getParentNode(); n != null && parentNsPrefixMap == null; n = n.getParentNode()) {
                parentNsPrefixMap = (Map)n.getUserData(NamespaceResolver.class.getName());
            }
            return NamespaceResolver.setPrefixMappingUserData(context, parentNsPrefixMap);
        }
        return (Map)nsPrefixMapping;
    }

    public static String getNamespaceURI(Element context, String prefix) {
        NamedNodeMap attrs = context.getAttributes();
        for (int c = 0; c < attrs.getLength(); ++c) {
            Node attr = attrs.item(c);
            if (!"http://www.w3.org/2000/xmlns/".equals(attr.getNamespaceURI())) continue;
            if (attr.getPrefix() == null && (prefix == null || prefix.length() == 0)) {
                return attr.getNodeValue();
            }
            if (!"xmlns".equals(attr.getPrefix()) || !attr.getLocalName().equals(prefix)) continue;
            return attr.getNodeValue();
        }
        Node n = context.getParentNode();
        if (n != null && n.getNodeType() == 1) {
            return NamespaceResolver.getNamespaceURI((Element)n, prefix);
        }
        return null;
    }

    public static String getPrefix(Element context, String uri) {
        if (uri.equals(context.getNamespaceURI())) {
            return context.getPrefix();
        }
        NamedNodeMap attrs = context.getAttributes();
        for (int c = 0; c < attrs.getLength(); ++c) {
            Node attr = attrs.item(c);
            if (!"http://www.w3.org/2000/xmlns/".equals(attr.getNamespaceURI())) continue;
            if (attr.getPrefix() == null && attr.getNodeValue().equals(uri)) {
                return "";
            }
            if (!"xmlns".equals(attr.getPrefix()) || !attr.getNodeValue().equals(uri)) continue;
            return attr.getLocalName();
        }
        Node n = context.getParentNode();
        if (n != null && n.getNodeType() == 1) {
            return NamespaceResolver.getPrefix((Element)n, uri);
        }
        return null;
    }

    public static void applyNamespaces(Element context, Element candidate) {
        NamedNodeMap attrs = context.getAttributes();
        for (int c = 0; c < attrs.getLength(); ++c) {
            Node attr = attrs.item(c);
            if (!"http://www.w3.org/2000/xmlns/".equals(attr.getNamespaceURI()) || candidate.hasAttributeNS("http://www.w3.org/2000/xmlns/", attr.getLocalName())) continue;
            candidate.setAttributeNS("http://www.w3.org/2000/xmlns/", attr.getNodeName(), attr.getNodeValue());
        }
        Node n = context.getParentNode();
        if (n != null && n.getNodeType() == 1) {
            NamespaceResolver.applyNamespaces((Element)n, candidate);
        }
    }

    public static String getExpandedName(Element context, String name) {
        if (name == null) {
            return null;
        }
        int separator = name.indexOf(58);
        String prefix = separator > -1 ? name.substring(0, separator) : null;
        String localName = separator > -1 ? name.substring(separator + 1) : name;
        String namespaceURI = prefix != null ? NamespaceResolver.getNamespaceURI(context, prefix) : null;
        return NamespaceResolver.expand(namespaceURI, localName);
    }

    public static String expand(String namespaceURI, String localName) {
        StringBuffer buffer = new StringBuffer();
        if (namespaceURI != null) {
            buffer.append('{');
            buffer.append(namespaceURI);
            buffer.append('}');
        }
        buffer.append(localName);
        return buffer.toString();
    }

    private static void init(Element context, Map<String, String> parentNsPrefixMap) {
        Map<String, String> newParentNsPrefixMap = NamespaceResolver.setPrefixMappingUserData(context, parentNsPrefixMap);
        for (Node it = context.getFirstChild(); it != null; it = it.getNextSibling()) {
            if (it.getNodeType() != 1) continue;
            NamespaceResolver.init((Element)it, newParentNsPrefixMap);
        }
    }

    private static Map<String, String> setPrefixMappingUserData(Element context, Map<String, String> parentNsPrefixMap) {
        Map<String, String> newParentNsPrefixMap;
        HashMap<String, String> nsPrefixMap = null;
        NamedNodeMap attrs = context.getAttributes();
        for (int c = 0; c < attrs.getLength(); ++c) {
            Node attr = attrs.item(c);
            if (nsPrefixMap == null && parentNsPrefixMap != null) {
                nsPrefixMap = new HashMap<String, String>(parentNsPrefixMap);
            }
            String attrQName = attr.getNodeName();
            if (!attr.getNodeName().startsWith("xmlns")) continue;
            if (nsPrefixMap == null) {
                nsPrefixMap = new HashMap();
            }
            if (attrQName.equals("xmlns") && attr.getNodeValue().equals("http://www.w3.org/1999/xhtml")) {
                nsPrefixMap.put("html", attr.getNodeValue());
                continue;
            }
            if (attrQName.equals("xmlns")) {
                nsPrefixMap.put("", attr.getNodeValue());
                continue;
            }
            String nsName = attr.getNodeName().substring(attrQName.indexOf(":") + 1);
            nsPrefixMap.put(nsName, attr.getNodeValue());
        }
        if (nsPrefixMap == null) {
            newParentNsPrefixMap = parentNsPrefixMap;
        } else {
            nsPrefixMap.put("xmlns", "http://www.w3.org/2000/xmlns/");
            nsPrefixMap.remove("");
            newParentNsPrefixMap = Collections.unmodifiableMap(nsPrefixMap);
        }
        context.setUserData(NamespaceResolver.class.getName(), newParentNsPrefixMap, null);
        return newParentNsPrefixMap;
    }
}

