/*
 * Decompiled with CFR 0.152.
 */
package de.betterform.xml.xforms;

import de.betterform.xml.config.Config;
import de.betterform.xml.config.XFormsConfigException;
import de.betterform.xml.xforms.XFormsConstants;
import de.betterform.xml.xforms.action.AbstractAction;
import de.betterform.xml.xforms.exception.XFormsException;
import de.betterform.xml.xforms.model.Model;
import de.betterform.xml.xforms.ui.AbstractUIElement;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Element;

public class CustomElementFactory
implements XFormsConstants {
    private static final Log LOGGER = LogFactory.getLog(Config.class);
    private static final Map ELEMENTS = CustomElementFactory.getCustomElementsConfig();
    private boolean noCustomElements = ELEMENTS.isEmpty();

    private static Map getCustomElementsConfig() {
        try {
            Map elementClassNames = Config.getInstance().getCustomElements();
            HashMap elementClassRefs = new HashMap(elementClassNames.size());
            for (Map.Entry entry : elementClassNames.entrySet()) {
                String key = (String)entry.getKey();
                String className = (String)entry.getValue();
                Class<?> classRef = Class.forName(className, true, CustomElementFactory.class.getClassLoader());
                elementClassRefs.put(key, classRef);
            }
            return elementClassRefs;
        }
        catch (XFormsConfigException xfce) {
            LOGGER.error((Object)("could not load custom-elements config: " + xfce.getMessage()));
        }
        catch (ClassNotFoundException cnfe) {
            LOGGER.error((Object)("class configured for custom-element not found: " + cnfe.getMessage()));
        }
        return Collections.EMPTY_MAP;
    }

    public String getKeyForElement(Element element) {
        return element.getNamespaceURI() + ":" + element.getLocalName();
    }

    public boolean isCustomElement(Element element) throws XFormsException {
        if (this.noCustomElements) {
            return false;
        }
        String key = this.getKeyForElement(element);
        if (ELEMENTS.containsKey(key)) {
            return true;
        }
        if (element.hasAttributeNS("http://www.w3.org/2002/xforms", "mustUnderstand")) {
            String elementId = element.getPrefix() + ":" + element.getLocalName();
            throw new XFormsException("MustUnderstand Module failure at element " + elementId);
        }
        return false;
    }

    public Object createCustomXFormsElement(Element element, Model model) throws XFormsException {
        String key = this.getKeyForElement(element);
        Class elementClazz = (Class)ELEMENTS.get(key);
        if (elementClazz == null) {
            throw new XFormsException("No class defined for " + key);
        }
        if (elementClazz != null) {
            try {
                Object xformsElement = elementClazz.getConstructor(Element.class, Model.class).newInstance(element, model);
                if (xformsElement instanceof AbstractUIElement) {
                    element.setUserData("", (AbstractUIElement)xformsElement, null);
                    return (AbstractUIElement)xformsElement;
                }
                if (xformsElement instanceof AbstractAction) {
                    element.setUserData("", (AbstractAction)xformsElement, null);
                    return (AbstractAction)xformsElement;
                }
            }
            catch (Exception e) {
                throw new XFormsException(e);
            }
        }
        LOGGER.warn((Object)("Custom class for " + key + " not does not extend AbstractUIElement or AbstractAction"));
        return null;
    }
}

